/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.guis;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.anvil.AnvilGUI;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.gui.gui.GUI;
import com.eazyftw.ezcolors.gui.info.GUIInfo;
import com.eazyftw.ezcolors.guis.ChatColorGUI;
import com.eazyftw.ezcolors.guis.head.ChatColorEnum;
import com.eazyftw.ezcolors.guis.head.HeadEnum;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import com.eazyftw.ezcolors.types.GUIType;
import com.eazyftw.ezcolors.types.color.ChatColor;
import com.eazyftw.ezcolors.versions.MinecraftVersion;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class ChatColorCreatorGUI
extends GUI {
    private int time;
    private ChatColorUser user;
    private List<String> colors;
    private String hex;

    public ChatColorCreatorGUI(Player p) {
        super(p);
        this.setRandomHex();
        this.time = 0;
        this.colors = new ArrayList<String>();
        this.p = p;
        this.user = EZColors.getStorage().getUser(p.getUniqueId());
    }

    @Override
    protected void construct(GUIInfo info) {
        info.title(EZMessage.text(T.t("GUI_COLOR_CUSTOM_TITLE")).colored());
        info.rows(6);
        ++this.time;
        if (this.time > 20) {
            this.user = EZColors.getStorage().getUser(this.p.getUniqueId());
            this.setRandomHex();
            this.time = 0;
        }
        String[] list = T.tN("GUI_COLOR_FINISH_LORE", "7");
        List finish_lore = Arrays.stream(list).map(s -> s.replace("{CustomColor}", this.getCustomColor())).collect(Collectors.toList());
        for (ChatColorEnum cc : ChatColorEnum.values()) {
            if (!cc.shouldShowInCreator()) continue;
            info.button(button -> {
                button.material(XMaterial.PLAYER_HEAD).name(cc.getColorString() + "&l" + T.t(cc.getColor())).lores(this.getSelectedGUIMsg(T.t(cc.getColor())), "", this.hasPerm(cc.getPermission()) ? T.t("GUI_HAS_ACCESS_CUSTOM") : T.t("GUI_NO_ACCESS")).setSkullTexture(cc.getHeadEnum().getUrl());
                button.action(action -> {
                    if (this.hasPerm(cc.getPermission())) {
                        if (this.addCustomColor(cc.getColorName() + ";" + cc.getColor())) {
                            EZMessage.text(this.getAddedColorMsg(cc.getColorString() + T.t(cc.getColor()))).player(this.p);
                        }
                    } else {
                        EZMessage.text(T.t("COMMAND_NO_ACCESS")).player(this.p);
                    }
                });
            }, cc.getLocCreator().toNormal());
        }
        info.button(button -> {
            button.material(XMaterial.BARRIER).name("&4&l" + T.t("COLOR_RESET") + " " + T.t("COLOR")).lores(T.t("RESET_CUSTOM_COLORS_LIST"));
            button.action(action -> {
                this.colors = new ArrayList<String>();
            });
        }, 3, 3);
        info.button(button -> {
            button.material(XMaterial.EMERALD_BLOCK).name("&a&l" + T.t("GUI_COLOR_FINISH")).lore(finish_lore);
            button.action(action -> {
                this.finish();
                if (this.colors.size() > 0) {
                    EZMessage.text(T.t("GUI_FINISH_CUSTOM_COLOR")).player(this.p);
                }
                if (this.colors.size() == 0) {
                    new ChatColorGUI(this.p);
                }
            });
        }, 3, 5);
        info.button(button -> {
            button.material(XMaterial.OAK_SIGN).name("&a&l" + T.t("GUI_COLOR_BACK")).lores("&7" + T.t("GUI_COLOR_BACK_LORE"));
            button.action(action -> new ChatColorGUI(this.p));
        }, 3, 4);
        for (int i = 0; i < 9; ++i) {
            if (this.colors.size() <= i) continue;
            String color = this.colors.get(i);
            String co = color.split(";")[0];
            String tr = color.split(";")[1];
            int i2 = i;
            String col = ChatColor.getChatColor(co);
            info.button(button -> {
                button.material(XMaterial.PLAYER_HEAD).name("&r&" + col + "&l" + T.t(tr)).lores(T.tN("GUI_CUSTOM_COLOR_LORE", "7")).setSkullTexture(HeadEnum.getByName(co).getUrl());
                button.action(action -> this.removeCustomColor(i2));
            }, 5, i);
        }
        if (EZColors.getVersion().isAboveOrEqual(MinecraftVersion.V1_16_R1) && this.colors.size() == 0 && this.p.hasPermission("ezcolors.color.hex")) {
            info.button(button -> {
                button.material(XMaterial.PLAYER_HEAD).name(EZMessage.text("&f" + this.hex + "&l").colored() + T.t("COLOR_HEX_SELECT_TITLE")).lores(T.tN("COLOR_HEX_SELECT_LORE", "7")).setSkullTexture(HeadEnum.OCTOTHROPE.getUrl());
                button.action(action -> this.createHex());
            }, 5, 4);
        }
    }

    public void setRandomHex() {
        this.hex = ChatColor.getRandomHex(true);
    }

    public String getCustomColor() {
        if (this.colors.size() == 0) {
            return T.t("NO_COLOR_SET");
        }
        ArrayList<String> colors2 = new ArrayList<String>();
        for (String c : this.colors) {
            String color = c.split(";")[0];
            String color2 = ChatColor.getChatColor(color);
            colors2.add("&" + color2);
        }
        return ChatColor.createCustomChat(T.t("GUI_CUSTOM_COLOR_EXAMPLE"), colors2);
    }

    public void finish() {
        if (this.colors.size() == 0) {
            return;
        }
        ArrayList<String> colors2 = new ArrayList<String>();
        for (String c : this.colors) {
            String color = c.split(";")[0];
            String color2 = ChatColor.getChatColor(color);
            colors2.add("&" + color2);
        }
        String finishColor = String.join((CharSequence)";", colors2);
        this.user.setChatColor(finishColor);
    }

    public void createHex() {
        new AnvilGUI.Builder().onClose((AnvilGUI.StateSnapshot player) -> {
            if (EZColors.getGUIType() == GUIType.NORMAL) {
                new ChatColorGUI(this.p);
            }
        }).onClick((slot, stateSnapshot) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            String text = stateSnapshot.getText();
            if (text.matches("#[0-9A-Fa-f]{6}")) {
                ChatColorUser user = EZColors.getStorage().getUser(this.p.getUniqueId());
                user.setChatColor(text);
                this.p.sendMessage(EZMessage.text(T.t("COLOR_SELECTED")).colored().replaceAll("(?i)\\{color}", EZMessage.text("{" + text + "}").colored() + text));
                return Collections.singletonList(AnvilGUI.ResponseAction.close());
            }
            return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText(T.t("COLOR_HEX_CUSTOM_INCORRECT")));
        }).text(T.t("COLOR_HEX_CUSTOM_VALUE")).itemLeft(XMaterial.PAPER.parseItem()).title(T.t("COLOR_HEX_CUSTOM")).plugin((Plugin)EZColors.getInstance()).open(this.p);
    }

    public boolean addCustomColor(String color) {
        if (this.colors.size() >= 9) {
            EZMessage.text("%prefix% &7Sorry, but there's a max of 9 colors!").player(this.p);
            return false;
        }
        this.colors.add(color);
        return true;
    }

    public boolean removeCustomColor(int i) {
        try {
            this.colors.remove(i);
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    @Override
    public void onClose(Inventory inventory) {
        new ChatColorGUI(this.p);
    }

    public String getAddedColorMsg(String color) {
        return T.t("COLOR_ADDED_MSG").replace("{Color}", color);
    }

    public String getSelectedGUIMsg(String color) {
        return T.t("GUI_ADD_CUSTOM_COLOR").replace("{Color}", color);
    }

    public boolean hasPerm(String color) {
        return this.p.hasPermission("ezcolors.color." + color.toLowerCase());
    }
}

