/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.premade;

import com.eazyftw.ezcolors.animations.Animation;
import com.eazyftw.ezcolors.gui.action.BackAction;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.gui.PageableGUI;
import com.eazyftw.ezcolors.gui.info.PageableGUIInfo;
import com.eazyftw.ezcolors.gui.sort.SearchCheck;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class MaterialSelectorGUI
extends PageableGUI<XMaterial> {
    public MaterialSelectorGUI(Player p) {
        super(p);
    }

    @Override
    protected void construct(PageableGUIInfo<XMaterial> info) {
        info.title("Select a Material");
        info.searchCheck(new SearchCheck<XMaterial>(){

            @Override
            public String[] getSearchableText(XMaterial xMaterial) {
                return new String[]{xMaterial.getHumanName()};
            }
        });
        ArrayList<XMaterial> list = new ArrayList<XMaterial>();
        Inventory inventory = Bukkit.createInventory(null, (int)9, (String)"Testing");
        for (XMaterial xMaterial : XMaterial.values()) {
            if (!xMaterial.isSupported()) continue;
            inventory.setItem(0, xMaterial.parseItem());
            if (inventory.getItem(0) == null) continue;
            inventory.setItem(0, null);
            list.add(xMaterial);
        }
        XMaterial[] array = list.toArray(new XMaterial[0]);
        Arrays.sort(array, Comparator.comparing(XMaterial::getHumanName));
        info.objects((XMaterial[])array);
        info.back(this.onBack(this.p));
    }

    @Override
    protected void button(Button button, XMaterial xMaterial) {
        button.material(xMaterial).name(Animation.wave("&b&l", "&f&l", 3, xMaterial.getHumanName())).lores("&bClick&7 to choose.");
        button.action(a -> this.choose(this.p, xMaterial));
    }

    protected abstract void choose(Player var1, XMaterial var2);

    protected abstract BackAction onBack(Player var1);
}

