/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.info;

import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.gui.button.ButtonEntry;
import com.eazyftw.ezcolors.gui.gui.GUILoc;
import java.util.HashMap;

public class GUIInfo {
    private String title = "Unnamed Inventory";
    private int rows = 6;
    private boolean closable = true;
    private HashMap<GUILoc, ButtonEntry> entries = new HashMap();

    public GUIInfo title(String title) {
        this.title = EZMessage.text(title).colored();
        return this;
    }

    public GUIInfo rows(int rows) {
        if (rows < 1 || rows > 6) {
            throw new IndexOutOfBoundsException("The row count for the chest inventory must be between 1 and 6, found: " + rows);
        }
        this.rows = rows;
        return this;
    }

    public GUIInfo closable(boolean closable) {
        this.closable = closable;
        return this;
    }

    public GUIInfo button(ButtonEntry buttonEntry, int row, int column) {
        this.entries.put(GUILoc.of(row, column), buttonEntry);
        return this;
    }

    public GUIInfo button(ButtonEntry buttonEntry, int n) {
        this.entries.put(GUILoc.of(n), buttonEntry);
        return this;
    }

    public HashMap<GUILoc, ButtonEntry> entries() {
        return this.entries;
    }

    public boolean closable() {
        return this.closable;
    }

    public String title() {
        return this.title;
    }

    public int rows() {
        return this.rows;
    }
}

