/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.gui;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.animations.Animation;
import com.eazyftw.ezcolors.gui.action.Action;
import com.eazyftw.ezcolors.gui.action.ActionType;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.button.ButtonEntry;
import com.eazyftw.ezcolors.gui.gui.GUILoc;
import com.eazyftw.ezcolors.gui.info.PageableSmallGUIInfo;
import com.eazyftw.ezcolors.gui.sort.Sort;
import com.eazyftw.ezcolors.userinput.UserInput;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class PageableSmallGUI<OBJ>
implements Listener {
    protected Player p;
    private Inventory inventory;
    private BukkitTask task;
    private Runnable runnable;
    private HashMap<Integer, List<Action>> actions = new HashMap();
    private PageableSmallGUIInfo<OBJ> info = null;
    private boolean first = false;
    private List<Sort<OBJ>> sort = new ArrayList<Sort<OBJ>>();
    private int page;
    private int maxPage = 1;
    private String searchTerm;
    private long timeOpened;
    private boolean clicked = false;
    private int currentSort = 0;

    public PageableSmallGUI(Player p) {
        this.p = p;
        this.timeOpened = System.currentTimeMillis();
        this.runnable = () -> {
            int pages;
            if (!this.first) {
                PageableSmallGUIInfo info = new PageableSmallGUIInfo();
                this.construct(info);
                this.info = info;
            } else {
                this.construct(this.info);
            }
            ArrayList<Sort<OBJ>> sorts = new ArrayList<Sort<OBJ>>(Collections.singletonList(new Sort("No Sort", "&8No Sort", "Sort by the default layout.", (o1, o2) -> 0)));
            if (this.sort() != null && this.sort().size() != 0) {
                sorts.addAll(this.sort());
            }
            this.sort(sorts);
            List<Object> obj = this.info.objects();
            if (this.searchTerm != null) {
                obj = obj.stream().filter(o -> {
                    if (o == null) {
                        return true;
                    }
                    if (this.info.searchCheck() == null) {
                        return true;
                    }
                    String[] search = this.info.searchCheck().getSearchableText(o);
                    return Arrays.stream(search).anyMatch(s -> s.toLowerCase().contains(this.searchTerm.toLowerCase()));
                }).collect(Collectors.toList());
            }
            obj.sort(this.currentSort().getCompare());
            int min = Math.min(obj.size(), this.page * 21);
            List<Object> pageList = obj.subList(min, Math.min(obj.size(), min + this.info.perPage()));
            ArrayList<Integer> sides = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36));
            int total = 0;
            for (int i2 = 9; i2 < 35; ++i2) {
                if (pageList.size() < total + 1) continue;
                Object o3 = pageList.get(total);
                if (sides.contains(i2)) continue;
                this.info.button((Button button) -> this.button(button, o3), i2);
                ++total;
            }
            this.maxPage = pages = (int)Math.round(Math.ceil((float)obj.size() / (float)this.info.perPage()));
            this.info.button(button -> {
                button.item(this.info.sortItem(this.nextSort(), this.currentSort()));
                button.action(action -> this.addSort());
            }, 5, 8);
            if (this.page != 0) {
                this.info.button(button -> {
                    button.material(XMaterial.ARROW).name(Animation.wave(this.info.primaryColor() + "&l", this.info.secondaryColor() + "&l", 4, "Previous")).lores("&7Click to go to the " + Animation.flashing(this.info.primaryColor(), 30, this.info.secondaryColor(), 5, "previous") + " page.");
                    button.action(action -> {
                        --this.page;
                        if (this.page < 0) {
                            this.page = 0;
                        }
                    });
                }, 5, 1);
            }
            if (this.page + 1 < pages) {
                this.info.button(button -> {
                    button.material(XMaterial.ARROW).name(Animation.wave(this.info.primaryColor() + "&l", this.info.secondaryColor() + "&l", 4, "Next")).lores("&7Click to go to the " + Animation.flashing(this.info.primaryColor(), 30, this.info.secondaryColor(), 5, "next") + " page.");
                    button.action(action -> {
                        ++this.page;
                        if (this.page >= pages) {
                            this.page = pages - 1;
                        }
                    });
                }, 5, 2);
            }
            if (this.searchTerm == null) {
                this.info.button((Button button) -> {
                    button.item(this.info.searchItem());
                    button.action(action -> new UserInput(p, this.info.primaryColor() + "&lSearch", "&fType in a query.", null, (p1, reply, exited) -> {
                        if (!reply.isEmpty() && !exited) {
                            this.searchTerm = reply;
                            this.page = 0;
                        } else {
                            this.page = 0;
                            this.searchTerm = null;
                        }
                        this.reopen();
                        return true;
                    }));
                }, this.info.searchLoc().toNormal());
            } else {
                this.info.button((Button button) -> {
                    button.material(XMaterial.GRAY_DYE).name(Animation.wave("&c&l", "&f&l", 4, "Exit Search")).lores("&7Click to close the search menu.");
                    button.action(action -> {
                        this.searchTerm = null;
                        this.page = 0;
                    });
                }, this.info.searchLoc().toNormal());
            }
            HashMap<GUILoc, ButtonEntry> entries = new HashMap<GUILoc, ButtonEntry>(this.info.entries());
            if (this.inventory == null || !p.getOpenInventory().getTitle().equals(this.info.title()) || this.inventory.getSize() / 9 != this.info.rows()) {
                this.openInventory(this.p, this.info);
            }
            IntStream.range(0, this.inventory.getSize()).filter(i -> !entries.containsKey(GUILoc.of(i))).forEach(i -> this.inventory.clear());
            this.actions = new HashMap();
            entries.forEach((slot, entry) -> {
                Button button = new Button();
                entry.button(button);
                this.inventory.setItem(slot.toNormal(), button.item().build());
                this.actions.put(slot.toNormal(), button.actions());
            });
            p.updateInventory();
        };
        this.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    protected abstract void construct(PageableSmallGUIInfo<OBJ> var1);

    protected abstract void button(Button var1, OBJ var2);

    public void onClose(Inventory inventory) {
    }

    public void reopen() {
        if (this.inventory != null) {
            return;
        }
        this.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    private void startTask() {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)EazyAPI.getPluginAPI(), this.runnable, 0L, 1L);
    }

    public void stopTask() {
        this.task.cancel();
    }

    private void openInventory(Player p, PageableSmallGUIInfo<OBJ> info) {
        this.inventory = Bukkit.createInventory(null, (int)(info.rows() * 9), (String)info.title());
        p.openInventory(this.inventory);
    }

    private void close() {
        if (!this.clicked) {
            this.onClose(this.inventory);
        }
        this.inventory = null;
        this.stopTask();
        this.unregister();
    }

    private void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            e.setCancelled(true);
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory)) {
            e.setCancelled(true);
            if (this.actions.containsKey(e.getSlot())) {
                this.clicked = true;
                ActionType type = ActionType.fromClickType(e.getClick());
                this.actions.get(e.getSlot()).forEach(action -> action.run(type));
                Bukkit.getScheduler().runTaskLater((Plugin)EazyAPI.getPluginAPI(), () -> {
                    this.clicked = false;
                }, 3L);
            }
        } else {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getInventory() instanceof PlayerInventory) {
            return;
        }
        if (e.getInventorySlots().size() > 1) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void leave(PlayerQuitEvent e) {
        if (e.getPlayer().equals(this.p)) {
            this.close();
        }
    }

    @EventHandler
    public void close(InventoryCloseEvent e) {
        if (this.inventory != null && this.inventory.equals(e.getInventory())) {
            PageableSmallGUIInfo info = new PageableSmallGUIInfo();
            this.construct(info);
            if (!info.closable()) {
                Bukkit.getScheduler().runTask((Plugin)EazyAPI.getPluginAPI(), this::reopen);
            } else {
                this.close();
            }
        }
    }

    public Sort<OBJ> currentSort() {
        if (this.currentSort == -1) {
            return null;
        }
        if (this.sort.size() < this.currentSort) {
            return this.sort.get(0);
        }
        if (this.sort.size() > 0) {
            return this.sort.get(this.currentSort);
        }
        return null;
    }

    public int currentSortNum() {
        return this.currentSort;
    }

    public Sort<OBJ> nextSort() {
        if (this.sort.size() > this.currentSort + 1) {
            return this.sort.get(this.currentSort + 1);
        }
        return this.sort.get(0);
    }

    public Sort<OBJ> addSort() {
        this.currentSort = this.sort.size() > this.currentSort + 1 ? ++this.currentSort : 0;
        this.info.updateSort(this.nextSort(), this.currentSort());
        return this.sort.get(this.currentSort);
    }

    public List<Sort<OBJ>> sort() {
        return this.sort;
    }

    public void sort(List<Sort<OBJ>> sort) {
        this.sort = sort;
    }

    public int page() {
        return this.page;
    }

    public int maxPage() {
        return this.maxPage;
    }
}

