/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.gui;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.animations.Animation;
import com.eazyftw.ezcolors.gui.action.Action;
import com.eazyftw.ezcolors.gui.action.ActionType;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.button.ButtonEntry;
import com.eazyftw.ezcolors.gui.gui.GUILoc;
import com.eazyftw.ezcolors.gui.info.PageableGUIInfo;
import com.eazyftw.ezcolors.userinput.UserInput;
import com.eazyftw.ezcolors.utils.Formatter;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class PageableGUI<OBJ>
implements Listener {
    protected Player p;
    private Inventory inventory;
    private BukkitTask task;
    private Runnable runnable;
    private HashMap<Integer, List<Action>> actions = new HashMap();
    private PageableGUIInfo<OBJ> info = null;
    private boolean first = false;
    private int page;
    private int maxPage = 1;
    private String searchTerm;
    private long timeOpened;
    private boolean clicked = false;

    public PageableGUI(Player p) {
        this.p = p;
        this.timeOpened = System.currentTimeMillis();
        this.runnable = () -> {
            int pages;
            if (!this.first) {
                PageableGUIInfo info = new PageableGUIInfo();
                this.construct(info);
                this.info = info;
            } else {
                this.construct(this.info);
            }
            List<Object> obj = this.info.objects();
            if (this.searchTerm != null) {
                obj = obj.stream().filter(o -> {
                    if (o == null) {
                        return true;
                    }
                    if (this.info.searchCheck() == null) {
                        return true;
                    }
                    String[] search = this.info.searchCheck().getSearchableText(o);
                    return Arrays.stream(search).anyMatch(s -> s.toLowerCase().contains(this.searchTerm.toLowerCase()));
                }).collect(Collectors.toList());
            }
            int min = Math.min(obj.size(), this.page * 36);
            List<Object> pageList = obj.subList(min, Math.min(obj.size(), min + this.info.perPage()));
            int n = 0;
            for (Object o2 : pageList) {
                this.info.button((Button button) -> this.button(button, o2), n);
                ++n;
            }
            this.maxPage = pages = (int)Math.round(Math.ceil((float)obj.size() / (float)this.info.perPage()));
            if (this.page != 0) {
                this.info.button(button -> {
                    button.material(XMaterial.ARROW).name(Animation.wave(this.info.primaryColor() + "&l", this.info.secondaryColor() + "&l", 4, "Previous")).lores("&7Click to go to the " + Animation.flashing(this.info.primaryColor(), 30, this.info.secondaryColor(), 5, "previous") + " page.");
                    button.action(action -> {
                        --this.page;
                        if (this.page < 0) {
                            this.page = 0;
                        }
                    });
                }, 5, 3);
            }
            if (this.page + 1 < pages) {
                this.info.button(button -> {
                    button.material(XMaterial.ARROW).name(Animation.wave(this.info.primaryColor() + "&l", this.info.secondaryColor() + "&l", 4, "Next")).lores("&7Click to go to the " + Animation.flashing(this.info.primaryColor(), 30, this.info.secondaryColor(), 5, "next") + " page.");
                    button.action(action -> {
                        ++this.page;
                        if (this.page >= pages) {
                            this.page = pages - 1;
                        }
                    });
                }, 5, 5);
            }
            if (this.searchTerm == null) {
                this.info.button((Button button) -> {
                    button.item(this.info.searchItem());
                    button.action(action -> new UserInput(p, this.info.primaryColor() + "&lSearch", "&fType in a query.", null, (p1, reply, exited) -> {
                        if (!reply.isEmpty() && !exited) {
                            this.searchTerm = reply;
                            this.page = 0;
                        } else {
                            this.page = 0;
                            this.searchTerm = null;
                        }
                        this.reopen();
                        return true;
                    }));
                }, this.info.searchLoc().toNormal());
            } else {
                this.info.button((Button button) -> {
                    button.material(XMaterial.REDSTONE_BLOCK).name(Animation.wave("&c&l", "&f&l", 4, "Exit Search")).lores("&7Click to close the search menu.");
                    button.action(action -> {
                        this.searchTerm = null;
                        this.page = 0;
                    });
                }, this.info.searchLoc().toNormal());
            }
            if (this.info.hasBack()) {
                this.info.button((Button button) -> {
                    button.material(XMaterial.OAK_SIGN).name(Animation.wave(this.info.primaryColor() + "&l", "&f&l", 4, "Go Back")).lores("&7Click to go back!");
                    button.action(a -> this.info.back().run());
                }, 53);
            } else {
                this.info.button((Button button) -> {
                    button.material(XMaterial.BARRIER).name(Animation.wave("&c&l", "&f&l", 2, "Close")).lores("&7Click to close!");
                    button.action(a -> p.closeInventory());
                }, 53);
            }
            if (this.info.bar()) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.info.button(button -> button.material(XMaterial.GRAY_STAINED_GLASS_PANE).name(" "), 4, i2);
                }
            }
            if (this.info.info()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.info.primaryColor() + "Page &8\u00bb &f" + (this.page + 1));
                if (this.searchTerm != null) {
                    list.add(this.info.primaryColor() + "Search &8\u00bb &f" + this.searchTerm);
                }
                long seconds = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.timeOpened);
                list.add(this.info.primaryColor() + "Duration &8\u00bb &f" + Formatter.time(seconds));
                this.info.button(button -> button.material(XMaterial.BOOK).name(Animation.wave(this.info.primaryColor() + "&l", "&f&l", 4, "GUI Info")).lore(list), 5, 0);
            }
            HashMap<GUILoc, ButtonEntry> entries = new HashMap<GUILoc, ButtonEntry>(this.info.entries());
            if (this.inventory == null || !p.getOpenInventory().getTitle().equals(this.info.title()) || this.inventory.getSize() / 9 != this.info.rows()) {
                this.openInventory(this.p, this.info);
            }
            IntStream.range(0, this.inventory.getSize()).filter(i -> !entries.containsKey(GUILoc.of(i))).forEach(i -> this.inventory.clear());
            this.actions = new HashMap();
            entries.forEach((slot, entry) -> {
                Button button = new Button();
                entry.button(button);
                this.inventory.setItem(slot.toNormal(), button.item().build());
                this.actions.put(slot.toNormal(), button.actions());
            });
            p.updateInventory();
        };
        this.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    protected abstract void construct(PageableGUIInfo<OBJ> var1);

    protected abstract void button(Button var1, OBJ var2);

    public void onClose(Inventory inventory) {
    }

    public void reopen() {
        if (this.inventory != null) {
            return;
        }
        this.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    private void startTask() {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)EazyAPI.getPluginAPI(), this.runnable, 0L, 1L);
    }

    public void stopTask() {
        this.task.cancel();
    }

    private void openInventory(Player p, PageableGUIInfo<OBJ> info) {
        this.inventory = Bukkit.createInventory(null, (int)(info.rows() * 9), (String)info.title());
        p.openInventory(this.inventory);
    }

    private void close() {
        if (!this.clicked) {
            this.onClose(this.inventory);
        }
        this.inventory = null;
        this.stopTask();
        this.unregister();
    }

    private void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            e.setCancelled(true);
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory)) {
            e.setCancelled(true);
            if (this.actions.containsKey(e.getSlot())) {
                this.clicked = true;
                ActionType type = ActionType.fromClickType(e.getClick());
                this.actions.get(e.getSlot()).forEach(action -> action.run(type));
                Bukkit.getScheduler().runTaskLater((Plugin)EazyAPI.getPluginAPI(), () -> {
                    this.clicked = false;
                }, 3L);
            }
        } else {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getInventory() instanceof PlayerInventory) {
            return;
        }
        if (e.getInventorySlots().size() > 1) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void leave(PlayerQuitEvent e) {
        if (e.getPlayer().equals(this.p)) {
            this.close();
        }
    }

    @EventHandler
    public void close(InventoryCloseEvent e) {
        if (this.inventory != null && this.inventory.equals(e.getInventory())) {
            PageableGUIInfo info = new PageableGUIInfo();
            this.construct(info);
            if (!info.closable()) {
                Bukkit.getScheduler().runTask((Plugin)EazyAPI.getPluginAPI(), () -> e.getPlayer().openInventory(e.getInventory()));
            } else {
                this.close();
            }
        }
    }

    public int page() {
        return this.page;
    }

    public int maxPage() {
        return this.maxPage;
    }
}

