/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.gui;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.gui.action.Action;
import com.eazyftw.ezcolors.gui.action.ActionType;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.gui.GUILoc;
import com.eazyftw.ezcolors.gui.info.GUIInfo;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class LazyGUI
implements Listener {
    protected Player p;
    private Inventory inventory;
    private BukkitTask task;
    private Runnable runnable;
    private HashMap<Integer, List<Action>> actions = new HashMap();
    private boolean clicked = false;

    public LazyGUI(Player p) {
        this.p = p;
        GUIInfo info = new GUIInfo();
        this.construct(info);
        this.openInventory(this.p, info);
        p.updateInventory();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    protected abstract void construct(GUIInfo var1);

    public void onClose(Inventory inventory) {
    }

    public void setItem(GUILoc loc, Button button, Action action) {
        this.inventory.setItem(loc.toNormal(), button.item().build());
        this.actions.put(loc.toNormal(), button.action(action).actions());
    }

    public void reopen() {
        if (this.inventory != null) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    public void stopTask() {
        this.task.cancel();
    }

    private void openInventory(Player p, GUIInfo info) {
        this.inventory = Bukkit.createInventory(null, (int)(info.rows() * 9), (String)info.title());
        p.openInventory(this.inventory);
    }

    private void close() {
        if (!this.clicked) {
            this.onClose(this.inventory);
        }
        this.inventory = null;
        this.stopTask();
        this.unregister();
    }

    private void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            e.setCancelled(true);
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory)) {
            e.setCancelled(true);
            if (this.actions.containsKey(e.getSlot())) {
                this.clicked = true;
                ActionType type = ActionType.fromClickType(e.getClick());
                this.actions.get(e.getSlot()).forEach(action -> action.run(type));
                Bukkit.getScheduler().runTaskLater((Plugin)EazyAPI.getPluginAPI(), () -> {
                    this.clicked = false;
                }, 3L);
            }
        } else {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent e) {
        if (!e.getWhoClicked().equals(this.p) | e.getInventory() instanceof PlayerInventory) {
            return;
        }
        if (e.getInventorySlots().size() > 1) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void leave(PlayerQuitEvent e) {
        if (e.getPlayer().equals(this.p)) {
            this.close();
        }
    }

    @EventHandler
    public void close(InventoryCloseEvent e) {
        if (this.inventory != null && this.inventory.equals(e.getInventory())) {
            GUIInfo info = new GUIInfo();
            this.construct(info);
            if (!info.closable()) {
                Bukkit.getScheduler().runTask((Plugin)EazyAPI.getPluginAPI(), () -> e.getPlayer().openInventory(e.getInventory()));
            } else {
                this.close();
            }
        }
    }
}

