/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.examples;

import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.gui.GUI;
import com.eazyftw.ezcolors.gui.info.GUIInfo;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.Random;
import org.bukkit.entity.Player;

public class ExampleGUI
extends GUI {
    private int randomRow = 2;
    private int randomColumn = 4;
    private int clickedAmount = 0;
    private boolean canBeClosed = false;

    public ExampleGUI(Player p) {
        super(p);
    }

    @Override
    protected void construct(GUIInfo info) {
        if (this.canBeClosed) {
            info.title("&a&lYou can now close the gui!");
        } else {
            info.title("&c&lClick the diamond 10 times.");
        }
        info.rows(6);
        info.closable(this.canBeClosed);
        if (!this.canBeClosed) {
            info.button(this::testButton, this.randomRow, this.randomColumn);
        }
    }

    private void testButton(Button button) {
        button.material(XMaterial.DIAMOND);
        button.item().name("&c&lClick me!");
        button.item().lores("&7Click me &c" + (10 - this.clickedAmount) + " &7more times!");
        button.action(action -> {
            EZMessage.text("%prefix% I've moved!").player(this.p);
            this.randomRow = this.getRandomRow();
            this.randomColumn = this.getRandomColumn();
            ++this.clickedAmount;
            if (this.clickedAmount == 10) {
                this.setClosable();
            }
        });
    }

    public int getRandomRow() {
        return new Random().nextInt(5);
    }

    public int getRandomColumn() {
        return new Random().nextInt(8);
    }

    public void setClosable() {
        this.canBeClosed = true;
    }
}

