/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.entity;

import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class EntityEditor {
    private Entity entity;

    private EntityEditor(Entity entity) {
        this.entity = entity;
    }

    public static EntityEditor edit(Entity entity) {
        return new EntityEditor(entity);
    }

    public void delete() {
        this.entity.remove();
    }

    public boolean isLiving() {
        return this.entity instanceof LivingEntity;
    }

    public EntityType getType() {
        return this.entity.getType();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.isLiving()) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public EntityEditor setAI(boolean value) {
        this.getLivingEntity().setAI(value);
        return this;
    }

    public boolean getAI() {
        return this.getLivingEntity().hasAI();
    }

    public EntityEditor setSilent(boolean value) {
        this.entity.setSilent(value);
        return this;
    }

    public boolean isSilent() {
        return this.entity.isSilent();
    }

    public EntityEditor setGravity(boolean value) {
        this.entity.setGravity(value);
        return this;
    }

    public boolean getGravity() {
        return this.entity.hasGravity();
    }

    public EntityEditor setGlowing(boolean value) {
        this.entity.setGlowing(value);
        return this;
    }

    public boolean isGlowing() {
        return this.entity.isGlowing();
    }

    public EntityEditor setHealth(double value) {
        this.getLivingEntity().setHealth(value);
        return this;
    }

    public double getHealth() {
        return this.getLivingEntity().getHealth();
    }

    public EntityEditor setCustomName(String value) {
        this.entity.setCustomName(value);
        this.setCustomNameVisible(true);
        return this;
    }

    public String getCustomName() {
        return this.entity.getCustomName();
    }

    public EntityEditor setCustomNameVisible(boolean value) {
        this.entity.setCustomNameVisible(value);
        return this;
    }

    public boolean isCustomNameVisible() {
        return this.entity.isCustomNameVisible();
    }

    public EntityEditor setMetadata(String s, MetadataValue data) {
        this.entity.setMetadata(s, data);
        return this;
    }

    public List<MetadataValue> getMetadata(String s) {
        return this.entity.getMetadata(s);
    }

    public EntityEditor setInvulnerable(boolean value) {
        this.entity.setInvulnerable(value);
        return this;
    }

    public boolean isInvulnerable() {
        return this.entity.isInvulnerable();
    }

    public EntityEditor setHelmet(ItemStack item) {
        this.getLivingEntity().getEquipment().setHelmet(item);
        return this;
    }

    public ItemStack getHelmet() {
        return this.getLivingEntity().getEquipment().getHelmet();
    }

    public EntityEditor setChestplate(ItemStack item) {
        this.getLivingEntity().getEquipment().setChestplate(item);
        return this;
    }

    public ItemStack getChestplate() {
        return this.getLivingEntity().getEquipment().getChestplate();
    }

    public EntityEditor setLeggings(ItemStack item) {
        this.getLivingEntity().getEquipment().setLeggings(item);
        return this;
    }

    public ItemStack getLeggings() {
        return this.getLivingEntity().getEquipment().getLeggings();
    }

    public EntityEditor setBoots(ItemStack item) {
        this.getLivingEntity().getEquipment().setBoots(item);
        return this;
    }

    public ItemStack getBoots() {
        return this.getLivingEntity().getEquipment().getBoots();
    }

    public EntityEditor setMainHand(ItemStack item) {
        this.getLivingEntity().getEquipment().setItemInMainHand(item);
        return this;
    }

    public ItemStack getMainHand() {
        return this.getLivingEntity().getEquipment().getItemInMainHand();
    }

    public EntityEditor setOffHand(ItemStack item) {
        this.getLivingEntity().getEquipment().setItemInOffHand(item);
        return this;
    }

    public ItemStack getOffHand() {
        return this.getLivingEntity().getEquipment().getItemInOffHand();
    }

    public EntityEditor setArmorContents(ItemStack[] item) {
        this.getLivingEntity().getEquipment().setArmorContents(item);
        return this;
    }

    public ItemStack[] getArmorContents() {
        return this.getLivingEntity().getEquipment().getArmorContents();
    }
}

