/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.color;

import com.eazyftw.ezcolors.hooks.PlaceholderAPI;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.utils.Colors;
import com.eazyftw.ezcolors.utils.DefaultFontInfo;
import com.eazyftw.ezcolors.versions.messages.ActionBar;
import com.eazyftw.ezcolors.versions.messages.Titles;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class EZMessage {
    private String msg;
    private String msgColored;
    private String normal;

    private EZMessage(String message) {
        this.normal = message;
        this.msg = ChatColor.stripColor((String)message);
        this.msgColored = Colors.getColored(this.normal);
    }

    private EZMessage(String message, boolean forceClosestHex) {
        this.normal = message;
        this.msg = ChatColor.stripColor((String)message);
        this.msgColored = Colors.getColored(this.normal, forceClosestHex);
    }

    public static EZMessage text(String s) {
        return new EZMessage(s);
    }

    public static EZMessage t(String s, Object ... os) {
        String t = T.t(s);
        for (Object o : os) {
            t = t.replaceFirst("%[a-zA-Z](?=\\s|!|\\.|,|$)", o.toString());
        }
        return new EZMessage(t);
    }

    public static EZMessage text(String s, boolean forceClosestHex) {
        return new EZMessage(s, forceClosestHex);
    }

    public String message() {
        return this.msg;
    }

    public EZMessage replace(String s, String r) {
        this.normal = this.normal.replace(s, r);
        this.msg = this.msg.replace(s, r);
        this.msgColored = this.msgColored.replace(s, r);
        return this;
    }

    public String normal() {
        return this.normal;
    }

    public String colored() {
        return this.msgColored;
    }

    public void msg(String msg) {
        this.msg = msg;
    }

    public EZMessage broadcast() {
        return this.broadcast(false, true);
    }

    public EZMessage broadcast(boolean center, boolean colored) {
        if (colored) {
            if (center) {
                Bukkit.broadcastMessage((String)DefaultFontInfo.center(this.colored()));
            } else {
                Bukkit.broadcastMessage((String)this.colored());
            }
        } else if (center) {
            Bukkit.broadcastMessage((String)DefaultFontInfo.center(this.colored()));
        } else {
            Bukkit.broadcastMessage((String)this.message());
        }
        return this;
    }

    public EZMessage everyone() {
        return this.broadcast(false, true);
    }

    public EZMessage everyone(boolean center, boolean colored) {
        return this.broadcast(center, colored);
    }

    public EZMessage console() {
        return this.console(false, true, false);
    }

    public EZMessage actionbar(Player p) {
        return this.actionbar(p, true);
    }

    public EZMessage actionbar(Player p, boolean colored) {
        if (colored) {
            ActionBar.sendActionBar(p, this.colored());
        } else {
            ActionBar.sendActionBar(p, this.message());
        }
        return this;
    }

    public EZMessage actionbar(Player p, boolean colored, long duration) {
        if (colored) {
            ActionBar.sendActionBar(p, this.colored(), duration);
        } else {
            ActionBar.sendActionBar(p, this.message(), duration);
        }
        return this;
    }

    public EZMessage title(Player p, int fadeIn, int stay, int fadeOut, String title, String subtitle) {
        Titles.sendTitle(p, fadeIn, stay, fadeOut, title, subtitle);
        return this;
    }

    public EZMessage title(Player p, int fadeIn, int stay, int fadeOut, String title) {
        Titles.sendTitle(p, fadeIn, stay, fadeOut, title, null);
        return this;
    }

    public EZMessage subTitle(Player p, int fadeIn, int stay, int fadeOut, String subtitle) {
        Titles.sendTitle(p, fadeIn, stay, fadeOut, null, subtitle);
        return this;
    }

    public EZMessage clearTitle(Player p) {
        Titles.clearTitle(p);
        return this;
    }

    public EZMessage console(boolean center, boolean colored, boolean replaceServer) {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (colored) {
            if (replaceServer) {
                if (center) {
                    console.sendMessage(DefaultFontInfo.center(this.colored().replace("%server%", console.getServer().getName())));
                } else {
                    console.sendMessage(this.colored().replace("%server%", console.getServer().getName()));
                }
            } else if (center) {
                console.sendMessage(DefaultFontInfo.center(this.colored()));
            } else {
                console.sendMessage(this.colored());
            }
        } else if (replaceServer) {
            if (center) {
                console.sendMessage(DefaultFontInfo.center(this.message().replace("%server%", console.getServer().getName())));
            } else {
                console.sendMessage(this.message().replace("%server%", console.getServer().getName()));
            }
        } else if (center) {
            console.sendMessage(DefaultFontInfo.center(this.message()));
        } else {
            console.sendMessage(this.message());
        }
        return this;
    }

    public EZMessage player(Player p) {
        return this.player(p, false, true, false);
    }

    public EZMessage player(Player player, boolean center, boolean colored, boolean replaceName) {
        String PAPINotColored = PlaceholderAPI.Placeholder(player, this.message());
        String PAPIColored = PlaceholderAPI.Placeholder(player, this.colored());
        if (colored) {
            if (replaceName) {
                if (center) {
                    for (String s : PAPIColored.replace("%player%", player.getName()).split("\\|\\|")) {
                        player.sendMessage(DefaultFontInfo.center(s));
                    }
                } else {
                    for (String s : PAPIColored.replace("%player%", player.getName()).split("\\|\\|")) {
                        player.sendMessage(s);
                    }
                }
            } else if (center) {
                for (String s : this.colored().split("\\|\\|")) {
                    player.sendMessage(DefaultFontInfo.center(s));
                }
            } else {
                for (String s : this.colored().split("\\|\\|")) {
                    player.sendMessage(s);
                }
            }
        } else if (replaceName) {
            if (center) {
                for (String s : PAPINotColored.replace("%player%", player.getName()).split("\\|\\|")) {
                    player.sendMessage(DefaultFontInfo.center(s));
                }
            } else {
                for (String s : PAPINotColored.replace("%player%", player.getName()).split("\\|\\|")) {
                    player.sendMessage(s);
                }
            }
        } else if (center) {
            for (String s : this.message().split("\\|\\|")) {
                player.sendMessage(DefaultFontInfo.center(s));
            }
        } else {
            for (String s : this.message().split("\\|\\|")) {
                player.sendMessage(s);
            }
        }
        return this;
    }

    public EZMessage sender(CommandSender cs) {
        return this.sender(cs, false, true, false);
    }

    public EZMessage sender(CommandSender commandSender, boolean center, boolean colored, boolean replaceName) {
        if (colored) {
            if (replaceName) {
                if (center) {
                    for (String s : this.colored().replace("%sender%", commandSender.getName()).split("\\|\\|")) {
                        commandSender.sendMessage(DefaultFontInfo.center(s));
                    }
                } else {
                    for (String s : this.colored().replace("%sender%", commandSender.getName()).split("\\|\\|")) {
                        commandSender.sendMessage(s);
                    }
                }
            } else if (center) {
                for (String s : this.colored().split("\\|\\|")) {
                    commandSender.sendMessage(DefaultFontInfo.center(s));
                }
            } else {
                for (String s : this.colored().split("\\|\\|")) {
                    commandSender.sendMessage(s);
                }
            }
        } else if (replaceName) {
            if (center) {
                for (String s : this.message().replace("%sender%", commandSender.getName()).split("\\|\\|")) {
                    commandSender.sendMessage(DefaultFontInfo.center(s));
                }
            } else {
                for (String s : this.message().replace("%sender%", commandSender.getName()).split("\\|\\|")) {
                    commandSender.sendMessage(s);
                }
            }
        } else if (center) {
            for (String s : this.message().split("\\|\\|")) {
                commandSender.sendMessage(DefaultFontInfo.center(s));
            }
        } else {
            for (String s : this.message().split("\\|\\|")) {
                commandSender.sendMessage(s);
            }
        }
        return this;
    }
}

