/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.color;

import com.eazyftw.ezcolors.EazyAPIBungee;
import com.eazyftw.ezcolors.utils.BungeeUtils;
import com.eazyftw.ezcolors.utils.DefaultFontInfo;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeMessage {
    private String msg;
    private String msgColored;
    private String normal;

    private BungeeMessage(String message) {
        this.normal = message;
        this.msg = ChatColor.stripColor((String)message);
        this.msgColored = BungeeUtils.getColoredBungee(this.normal);
    }

    public static BungeeMessage text(String message) {
        return new BungeeMessage(message);
    }

    public String message() {
        return this.msg;
    }

    public String normal() {
        return this.normal;
    }

    public String colored() {
        return this.msgColored;
    }

    public void message(String msg) {
        this.msg = msg;
    }

    public void colored(String msgColored) {
        this.msgColored = msgColored;
    }

    public BungeeMessage broadcast() {
        return this.everyone(false, true);
    }

    public BungeeMessage broadcast(boolean center, boolean colored) {
        if (colored) {
            if (center) {
                EazyAPIBungee.getPluginAPI().getProxy().broadcast(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.colored())));
            } else {
                EazyAPIBungee.getPluginAPI().getProxy().broadcast(TextComponent.fromLegacyText((String)this.colored()));
            }
        } else if (center) {
            EazyAPIBungee.getPluginAPI().getProxy().broadcast(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.message())));
        } else {
            EazyAPIBungee.getPluginAPI().getProxy().broadcast(TextComponent.fromLegacyText((String)this.message()));
        }
        return this;
    }

    public BungeeMessage everyone() {
        return this.everyone(false, true);
    }

    public BungeeMessage everyone(boolean center, boolean colored) {
        return this.broadcast(center, colored);
    }

    public BungeeMessage console() {
        return this.console(false, true);
    }

    public BungeeMessage console(boolean center, boolean colored) {
        if (colored) {
            if (center) {
                EazyAPIBungee.getPluginAPI().getProxy().getConsole().sendMessage(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.colored())));
            } else {
                EazyAPIBungee.getPluginAPI().getProxy().getConsole().sendMessage(TextComponent.fromLegacyText((String)this.colored()));
            }
        } else if (center) {
            EazyAPIBungee.getPluginAPI().getProxy().getConsole().sendMessage(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.message())));
        } else {
            EazyAPIBungee.getPluginAPI().getProxy().getConsole().sendMessage(TextComponent.fromLegacyText((String)this.message()));
        }
        return this;
    }

    public BungeeMessage player(ProxiedPlayer p) {
        return this.player(p, false, true, false);
    }

    public BungeeMessage player(ProxiedPlayer player, boolean center, boolean colored, boolean replaceName) {
        if (colored) {
            if (replaceName) {
                if (center) {
                    player.sendMessage(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.colored().replace("%player%", player.getName()))));
                } else {
                    player.sendMessage(TextComponent.fromLegacyText((String)this.colored().replace("%player%", player.getName())));
                }
            } else if (center) {
                player.sendMessage(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.colored())));
            } else {
                player.sendMessage(TextComponent.fromLegacyText((String)this.colored()));
            }
        } else if (replaceName) {
            if (center) {
                player.sendMessage(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.message().replace("%player%", player.getName()))));
            } else {
                player.sendMessage(TextComponent.fromLegacyText((String)this.message().replace("%player%", player.getName())));
            }
        } else if (center) {
            player.sendMessage(TextComponent.fromLegacyText((String)DefaultFontInfo.center(this.message())));
        } else {
            player.sendMessage(TextComponent.fromLegacyText((String)this.message()));
        }
        return this;
    }
}

