/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.animations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Animation {
    public static String wave(String primary, String secondary, int duration, String content) {
        String frame;
        StringBuilder sb;
        int i;
        ArrayList<String> frames = new ArrayList<String>();
        for (i = 0; i < content.length() + 1; ++i) {
            sb = new StringBuilder(content);
            sb.insert(i, secondary);
            frame = sb.toString();
            frames.addAll(Collections.nCopies(duration, "\u00a7f" + primary + frame));
        }
        for (i = 0; i < content.length() + 1; ++i) {
            sb = new StringBuilder(content);
            sb.insert(i, primary);
            frame = sb.toString();
            frames.addAll(Collections.nCopies(duration, "\u00a7f" + secondary + frame));
        }
        return Animation.currentFrame(frames);
    }

    public static String flashing(String primary, int primaryDelay, String secondary, int secondaryDelay, String content) {
        ArrayList<String> frames = new ArrayList<String>();
        frames.addAll(Collections.nCopies(primaryDelay, primary + content));
        frames.addAll(Collections.nCopies(secondaryDelay, secondary + content));
        return Animation.currentFrame(frames);
    }

    private static String currentFrame(List<String> frames) {
        long tick = System.currentTimeMillis() / 50L;
        int currentFrame = (int)(tick % (long)frames.size());
        return frames.get(currentFrame);
    }

    public static String slideIn(String title, long onStart) {
        List frames = IntStream.rangeClosed(0, title.length()).mapToObj(i -> title.substring(0, i)).collect(Collectors.toList());
        frames.add(title);
        long time = System.currentTimeMillis() - onStart;
        int frame = Math.round(time / 70L);
        return frame >= frames.size() ? title : (String)frames.get(frame);
    }
}

