/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors;

import com.eazyftw.ezcolors.language.LanguageManager;
import com.eazyftw.ezcolors.npc.NPCLib;
import com.eazyftw.ezcolors.npc.api.NPC;
import com.eazyftw.ezcolors.regeneration.EZRegenerato;
import com.eazyftw.ezcolors.scoreboard.ScoreboardManager;
import com.eazyftw.ezcolors.system.StorageFile;
import com.eazyftw.ezcolors.system.StorageManager;
import com.eazyftw.ezcolors.utils.TaskManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EazyAPI
implements Listener {
    private static JavaPlugin pl;
    private static TaskManager tm;
    private static LanguageManager languageManager;
    private static StorageManager storageManager;
    private static ScoreboardManager scoreboardManager;
    private static NPCLib npcLib;
    private static EZRegenerato regenerator;
    private static UUID instanceUUID;

    public EazyAPI(JavaPlugin plugin) {
        pl = plugin;
        if (pl == null) {
            throw new NullPointerException("Plugin is null.");
        }
        if (plugin instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)pl, (Plugin)EazyAPI.getPluginAPI());
        }
        tm = new TaskManager();
        tm.enable();
        plugin.saveDefaultConfig();
        storageManager = new StorageManager();
        storageManager.init();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("CurrentTranslation", "en");
        StorageFile sf = new StorageFile("Translation", hm, true);
        storageManager.addFile(sf);
        languageManager = new LanguageManager();
        languageManager.init();
        instanceUUID = UUID.randomUUID();
    }

    public static JavaPlugin getPluginAPI() {
        return pl;
    }

    public static boolean usingPlaceholderAPI() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    public static boolean usingUltraPermissions() {
        return Bukkit.getPluginManager().isPluginEnabled("UltraPermissions");
    }

    public static boolean usingUltraPunishments() {
        return Bukkit.getPluginManager().isPluginEnabled("UltraPunishments");
    }

    public static boolean usingVault() {
        return Bukkit.getPluginManager().isPluginEnabled("Vault");
    }

    public static void registerCommand(Command command) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            commandMap.register(command.getLabel(), command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LanguageManager getLanguageManager() {
        return languageManager;
    }

    public static StorageManager getStorageManager() {
        return storageManager;
    }

    public static UUID getInstanceUUID() {
        return instanceUUID;
    }

    public static EazyAPI init(JavaPlugin plugin) {
        return new EazyAPI(plugin);
    }

    public EazyAPI enableNPCLib() {
        npcLib = new NPCLib(EazyAPI.getPluginAPI());
        return this;
    }

    public EazyAPI enableScoreboards() {
        scoreboardManager = new ScoreboardManager(EazyAPI.getPluginAPI());
        scoreboardManager.start();
        return this;
    }

    public NPC buildNPC() {
        return npcLib.createNPC();
    }

    public EazyAPI enableRegenerator() {
        regenerator = new EZRegenerato();
        regenerator.enable(EazyAPI.getPluginAPI());
        return this;
    }

    public static NPCLib getNPCLib() {
        return npcLib;
    }

    public static ScoreboardManager getScoreboardManager() {
        return scoreboardManager;
    }

    public static EZRegenerato getRegenerator() {
        return regenerator;
    }
}

