/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.anvil.version.VersionMatcher;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.languages.OnlineLanguagesManager;
import com.eazyftw.ezcolors.listeners.ChatListener;
import com.eazyftw.ezcolors.manager.CommandManager;
import com.eazyftw.ezcolors.metrics.bukkit.Metrics;
import com.eazyftw.ezcolors.metrics.charts.SimplePie;
import com.eazyftw.ezcolors.mysql.MySQL;
import com.eazyftw.ezcolors.papi.EZColorsPAPI;
import com.eazyftw.ezcolors.storage.ChatColorStorage;
import com.eazyftw.ezcolors.storage.ChatColorStorageYAML;
import com.eazyftw.ezcolors.types.GUIType;
import com.eazyftw.ezcolors.types.RainbowType;
import com.eazyftw.ezcolors.types.SelectionType;
import com.eazyftw.ezcolors.types.StorageType;
import com.eazyftw.ezcolors.versions.MinecraftVersion;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public final class EZColors
extends JavaPlugin {
    private static EZColors instance;
    private static CommandManager cmdManager;
    private static ChatColorStorage storage;
    private static ChatColorStorageYAML storageYAML;
    private static MySQL mysql;
    private static boolean usingMySQL;
    private static MinecraftVersion version;

    public void onEnable() {
        long time = System.currentTimeMillis();
        instance = this;
        this.saveDefaultConfig();
        EazyAPI.init(this);
        this.loadDefaultLocales();
        EazyAPI.getLanguageManager().checkLanguages();
        usingMySQL = false;
        StorageType storageType = StorageType.getFromString(Objects.requireNonNull(this.getConfig().getString("StorageType")));
        if (storageType.equals((Object)StorageType.MYSQL)) {
            mysql = new MySQL(this, EZColors.shouldCache());
            usingMySQL = mysql.hasConnected();
        }
        EZMessage.text("%prefix% &fLoading &bEZColors &8v" + this.getDescription().getVersion() + "&f!").console();
        version = MinecraftVersion.getServersVersion(true);
        if (version != MinecraftVersion.UNKNOWN) {
            try {
                new VersionMatcher().match();
            }
            catch (RuntimeException ex) {
                EZMessage.text("%prefix% &cCould not find a compatible Minecraft Version for AnvilGUI. Issues may occur. You're using: (" + (Object)((Object)version) + ")").console();
            }
        }
        storage = new ChatColorStorage();
        storageYAML = new ChatColorStorageYAML();
        cmdManager = new CommandManager();
        ChatListener.register(Objects.requireNonNull(this.getConfig().getString("ChatListener")));
        if (EazyAPI.usingPlaceholderAPI()) {
            EZMessage.text("%prefix% &fFound &bPlaceholderAPI. &aLoading hook!").console();
            boolean registered = new EZColorsPAPI().register();
            if (!registered) {
                EZMessage.text("%prefix% &fPlaceholder Hook didn't register for some reason!").console();
            }
        }
        this.loadMetrics();
        EZMessage.text("%prefix% &fSuccessfully Loaded &bEZColors &8v" + this.getDescription().getVersion() + " &fin " + (System.currentTimeMillis() - time) + "ms!").console();
    }

    public void onDisable() {
        EZMessage.text("%prefix% &fGoodbye, I hope to see you soon!").colored();
    }

    public static EZColors getInstance() {
        return instance;
    }

    public static ChatColorStorage getStorage() {
        return storage;
    }

    public static CommandManager getCmdManager() {
        return cmdManager;
    }

    public static SelectionType getSelectionType() {
        return SelectionType.getFromString(Objects.requireNonNull(EZColors.getInstance().getConfig().getString("Selection")));
    }

    public static RainbowType getRainbowType() {
        return RainbowType.getFromString(EZColors.getInstance().getConfig().getString("RainbowType"));
    }

    public static GUIType getGUIType() {
        return GUIType.getFromString(EZColors.getInstance().getConfig().getString("GUIType"));
    }

    public static boolean shouldCache() {
        return EZColors.getInstance().getConfig().contains("Cache") && EZColors.getInstance().getConfig().getBoolean("Cache");
    }

    public static MySQL getMySQL() {
        return mysql;
    }

    public static boolean usingMySQL() {
        return usingMySQL;
    }

    public void loadDefaultLocales() {
        boolean success;
        File file = new File(this.getDataFolder() + "/locales");
        if (!file.exists()) {
            file.mkdir();
        }
        boolean bl = success = EZColors.getInstance().getConfig().contains("DownloadLocales") && EZColors.getInstance().getConfig().getBoolean("DownloadLocales") && OnlineLanguagesManager.getLanguagesAndDownload();
        if (!success) {
            EZMessage.text("%prefix% &cFailed to download languages online. Fetching local languages! (These may be outdated)").console();
            EZColors.saveAllLocales(true, "en", "uken", "de", "es", "it", "zh", "nl", "sr", "id", "th", "ua");
        }
    }

    public static void saveAllLocales(boolean override, String ... locales) {
        Arrays.stream(locales).forEach(l -> EZColors.saveFileToResource("locales/locale_" + l + ".yml", override));
    }

    public static void saveFileToResource(String name, boolean override) {
        if (!new File(EZColors.getInstance().getDataFolder(), name).exists()) {
            EZColors.getInstance().saveResource(name, override);
        }
    }

    public static MinecraftVersion getVersion() {
        return version;
    }

    public static ChatColorStorageYAML getStorageYAML() {
        return storageYAML;
    }

    private void loadMetrics() {
        int pluginId = 6605;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new SimplePie("used_language", () -> EazyAPI.getLanguageManager().getLanguage()));
        metrics.addCustomChart(new SimplePie("selection_type", () -> EZColors.getSelectionType().getName()));
        metrics.addCustomChart(new SimplePie("using_mysql", () -> EZColors.usingMySQL() ? "Yes" : "No"));
        metrics.addCustomChart(new SimplePie("serverSoftware", () -> Bukkit.getVersion().split("-")[1]));
    }
}

