/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector.teamselector;

import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.teamselector.Main;
import com.andrei1058.bedwars.teamselector.api.events.TeamSelectorChooseEvent;
import com.andrei1058.bedwars.teamselector.api.events.TeamSelectorOpenEvent;
import com.andrei1058.bedwars.teamselector.configuration.Config;
import com.andrei1058.bedwars.teamselector.teamselector.TeamManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TeamSelectorGUI {
    public static final String TEAM_SELECTOR_IDENTIFIER = "BWTEAMSELECTOR";
    public static final String TEAM_JOIN_IDENTIFIER = "BWJOIN_";
    public static ArrayList<UUID> openGUIs = new ArrayList();

    public static void openGUI(Player player, boolean update) {
        int[] layer;
        int size;
        IArena arena = Main.bw.getArenaUtil().getArenaByPlayer(player);
        if (arena == null) {
            return;
        }
        if (arena.getStatus() == GameState.playing) {
            return;
        }
        if (arena.getStatus() == GameState.restarting) {
            return;
        }
        if (!update) {
            TeamSelectorOpenEvent e = new TeamSelectorOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
        }
        Config.playSound(player, "gui-open-sound");
        openGUIs.add(player.getUniqueId());
        switch (arena.getTeams().size()) {
            default: {
                size = 9;
                layer = new int[]{};
                break;
            }
            case 2: {
                layer = new int[]{11, 15};
                size = 27;
                break;
            }
            case 3: {
                layer = new int[]{11, 13, 15};
                size = 27;
                break;
            }
            case 4: {
                layer = new int[]{10, 12, 14, 16};
                size = 27;
                break;
            }
            case 5: {
                layer = new int[]{11, 12, 13, 14, 15};
                size = 27;
                break;
            }
            case 6: {
                layer = new int[]{10, 11, 12, 14, 15, 16};
                size = 27;
                break;
            }
            case 7: {
                layer = new int[]{10, 11, 12, 13, 14, 15, 16};
                size = 27;
                break;
            }
            case 8: {
                layer = new int[]{10, 12, 14, 16, 28, 30, 32, 34};
                size = 45;
                break;
            }
            case 9: {
                layer = new int[]{10, 11, 12, 14, 15, 16, 30, 31, 32};
                size = 45;
                break;
            }
            case 10: {
                layer = new int[]{11, 12, 13, 14, 15, 20, 21, 22, 23, 24};
                size = 36;
                break;
            }
            case 11: {
                layer = new int[]{11, 12, 13, 14, 15, 19, 20, 21, 23, 24, 25};
                size = 36;
                break;
            }
            case 12: {
                layer = new int[]{10, 11, 12, 14, 15, 16, 19, 20, 21, 23, 24, 25};
                size = 45;
            }
        }
        Inventory inv = update ? player.getOpenInventory().getTopInventory() : Bukkit.createInventory(null, (int)size, (String)Language.getMsg((Player)player, (String)"addons.team-selector.inventory-name"));
        ArrayList<Integer> usedSlots = new ArrayList<Integer>();
        int xx = 0;
        for (ITeam bwt : arena.getTeams()) {
            if (layer.length == xx) break;
            ItemStack i = new ItemStack(Material.valueOf((String)Config.config.getString("team-selector-item-stack")));
            i = Main.bw.getVersionSupport().colourItem(i, bwt);
            i = Main.bw.getVersionSupport().addCustomData(i, TEAM_JOIN_IDENTIFIER + bwt.getName());
            String membersCount = String.valueOf(TeamManager.getInstance().getPlayersCount(bwt, arena));
            String teamName = bwt.getDisplayName(Main.bw.getPlayerLanguage(player));
            ItemMeta im = i.getItemMeta();
            im.setDisplayName(Language.getMsg((Player)player, (String)"addons.team-selector.choice.name").replace("{color}", bwt.getColor().chat().toString()).replace("{team}", teamName).replace("{selected}", membersCount).replace("{total}", String.valueOf(arena.getMaxInTeam())));
            ArrayList<String> lore = new ArrayList<String>();
            for (String s : Language.getList((Player)player, (String)"addons.team-selector.choice.lore")) {
                if ((s = s.replace("{color}", bwt.getColor().chat().toString()).replace("{team}", teamName).replace("{selected}", membersCount).replace("{total}", String.valueOf(arena.getMaxInTeam()))).contains("{members}")) {
                    s = s.replace("{members}", "");
                    String color = ChatColor.getLastColors((String)s);
                    List<Player> members = TeamManager.getInstance().getMembers(bwt, arena);
                    if (members.isEmpty()) continue;
                    for (Player p : TeamManager.getInstance().getMembers(bwt, arena)) {
                        lore.add(color + p.getDisplayName());
                    }
                    continue;
                }
                lore.add(s);
            }
            im.setLore(lore);
            i.setItemMeta(im);
            inv.setItem(layer[xx], i);
            usedSlots.add(layer[xx]);
            ++xx;
        }
        ITeam selected = arena.getTeam(player);
        for (int x = 0; x < inv.getSize(); ++x) {
            if (usedSlots.contains(x)) continue;
            if (selected == null) {
                inv.setItem(x, new ItemStack(Material.AIR));
                continue;
            }
            String material = Main.bw.getForCurrentVersion("STAINED_GLASS_PANE", "STAINED_GLASS_PANE", "BLACK_STAINED_GLASS_PANE");
            inv.setItem(x, Main.bw.getVersionSupport().colourItem(new ItemStack(Material.valueOf((String)material)), selected));
        }
        player.openInventory(inv);
    }

    public static boolean joinTeam(Player player, String teamName) {
        IArena arena = Main.bw.getArenaUtil().getArenaByPlayer(player);
        if (arena == null) {
            return false;
        }
        if (arena.getStatus() == GameState.playing) {
            return false;
        }
        if (arena.getStatus() == GameState.restarting) {
            return false;
        }
        if (arena.getStatus() == GameState.starting && arena.getStartingTask().getCountdown() < 2) {
            return false;
        }
        ITeam bwt = arena.getTeam(teamName);
        if (bwt == null) {
            return false;
        }
        ITeam playerSelection = TeamManager.getInstance().getPlayerTeam(player, arena);
        if (bwt.equals(playerSelection)) {
            player.sendMessage(Language.getMsg((Player)player, (String)"addons.team-selector.already-in-team"));
            return false;
        }
        if (Main.bw.getPartyUtil().hasParty(player)) {
            player.sendMessage(Language.getMsg((Player)player, (String)"addons.team-selector.party-deny"));
            return false;
        }
        String teamDisplayName = bwt.getDisplayName(Main.bw.getPlayerLanguage(player));
        int playersInTeam = TeamManager.getInstance().getPlayersCount(bwt, arena);
        if (playersInTeam >= arena.getMaxInTeam()) {
            player.sendMessage(Language.getMsg((Player)player, (String)"addons.team-selector.team-full").replace("{color}", bwt.getColor().chat().toString()).replace("{team}", teamDisplayName));
            return false;
        }
        for (ITeam t : arena.getTeams()) {
            int inTeam;
            if (t == bwt || playersInTeam <= (inTeam = TeamManager.getInstance().getPlayersCount(t, arena)) || !Config.config.getBoolean("balance-teams")) continue;
            player.sendMessage(Language.getMsg((Player)player, (String)"addons.team-selector.teams-not-balanced"));
            return false;
        }
        if (playerSelection != null && !Config.config.getBoolean("allow-team-change")) {
            player.sendMessage(Language.getMsg((Player)player, (String)"addons.team-selector.switch-disabled"));
            return false;
        }
        TeamSelectorChooseEvent e = new TeamSelectorChooseEvent(player, arena, bwt, playerSelection);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        TeamManager.getInstance().setPlayerTeam(player, arena, bwt);
        TeamSelectorGUI.giveItem(player, bwt);
        player.sendMessage(Language.getMsg((Player)player, (String)"addons.team-selector.team-join").replace("{color}", bwt.getColor().chat().toString()).replace("{team}", teamDisplayName).replace("{selected}", String.valueOf(TeamManager.getInstance().getMembers(bwt, arena))).replace("{total}", String.valueOf(arena.getMaxInTeam())));
        return true;
    }

    public static void updateGUIs() {
        for (UUID player : new ArrayList<UUID>(openGUIs)) {
            Player p = Bukkit.getPlayer((UUID)player);
            if (p == null) continue;
            if (p.getOpenInventory() == null) {
                openGUIs.remove(player);
                continue;
            }
            TeamSelectorGUI.openGUI(p, true);
        }
    }

    public static void giveItem(Player p, ITeam team) {
        ItemStack i;
        try {
            i = new ItemStack(Material.valueOf((String)Config.config.getString("team-selector-item-stack")));
        }
        catch (Exception ex) {
            Main.plugin.getLogger().severe("Team-Selector Material is invalid!");
            ex.printStackTrace();
            return;
        }
        if (team != null && Config.config.getBoolean("give-team-color")) {
            i = Main.bw.getVersionSupport().colourItem(i, team);
        }
        ItemMeta im = i.getItemMeta();
        im.setLore(Language.getList((Player)p, (String)"addons.team-selector.selector-lore"));
        im.setDisplayName(Language.getMsg((Player)p, (String)"addons.team-selector.selector-name"));
        i.setItemMeta(im);
        i = Main.bw.getVersionSupport().addCustomData(i, TEAM_SELECTOR_IDENTIFIER);
        p.getInventory().setItem(Config.config.getInt("team-selector-slot"), i);
    }
}

