/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector.teamselector;

import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.teamselector.teamselector.ArenaPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;

public class TeamManager {
    private static TeamManager INSTANCE;
    private final HashMap<IArena, ArenaPreferences> cachedPreferences = new HashMap();

    private TeamManager() {
    }

    public static TeamManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TeamManager();
        }
        return INSTANCE;
    }

    public void clearArenaCache(IArena arena) {
        this.cachedPreferences.remove(arena);
    }

    public void onQuit(IArena arena, Player player) {
        ArenaPreferences preferences = this.getArena(arena);
        if (preferences != null) {
            preferences.removePlayer(player);
        }
    }

    public ITeam getPlayerTeam(Player player, IArena arena) {
        ArenaPreferences pref = this.getArena(arena);
        if (pref != null) {
            return pref.getTeam(player);
        }
        return null;
    }

    public int getPlayersCount(ITeam team, IArena arena) {
        ArenaPreferences preferences = this.getArena(arena);
        if (preferences != null) {
            return preferences.getPlayersCount(team);
        }
        return 0;
    }

    public List<Player> getMembers(ITeam team, IArena arena) {
        ArenaPreferences preferences = this.getArena(arena);
        if (preferences != null) {
            return preferences.getMembers(team);
        }
        return new ArrayList<Player>();
    }

    public void setPlayerTeam(Player player, IArena arena, ITeam team) {
        ArenaPreferences preferences = this.getArena(arena);
        if (preferences != null) {
            preferences.setPlayerTeam(player, team);
        }
    }

    public ArenaPreferences getArena(IArena arena) {
        return this.cachedPreferences.getOrDefault(arena, this.cachedPreferences.putIfAbsent(arena, new ArenaPreferences(arena)));
    }
}

