/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector.teamselector;

import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerGroup
implements Comparable<PlayerGroup> {
    private final ITeam preference;
    private final IArena arena;
    private final Set<Player> members = new LinkedHashSet<Player>();

    public PlayerGroup(IArena arena, ITeam team) {
        this.arena = arena;
        this.preference = team;
    }

    public void addPlayer(Player player) {
        if (this.members.size() == this.arena.getMaxInTeam()) {
            return;
        }
        this.members.add(player);
    }

    @NotNull
    public Set<Player> getMembers() {
        return this.preference == null ? (this.members.size() > 1 ? this.members : Collections.emptySet()) : this.members;
    }

    @Nullable
    public ITeam getPreference() {
        return this.preference;
    }

    @Override
    public int compareTo(@NotNull PlayerGroup otherGroup) {
        if (this.getPreference() == null) {
            if (otherGroup.getPreference() == null) {
                return Integer.compare(this.getMembers().size(), otherGroup.getMembers().size());
            }
            return otherGroup.getMembers().size() == this.arena.getMaxInTeam() ? -1 : 1;
        }
        if (this.getMembers().size() == this.arena.getMaxInTeam()) {
            return 1;
        }
        return -1;
    }
}

