/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector.teamselector;

import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.teamselector.api.events.TeamSelectorAbortEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ArenaPreferences {
    private final IArena arena;
    private final HashMap<Player, ITeam> selections = new HashMap();

    protected ArenaPreferences(IArena arena) {
        this.arena = arena;
    }

    public void removePlayer(Player player) {
        if (this.selections.remove(player) != null) {
            Bukkit.getPluginManager().callEvent((Event)new TeamSelectorAbortEvent(player));
        }
    }

    public ITeam getTeam(Player player) {
        return this.selections.get(player);
    }

    public int getTeamsCount() {
        return (int)this.selections.values().stream().distinct().count();
    }

    public int getMembersCount() {
        return this.selections.size();
    }

    int getPlayersCount(ITeam team) {
        return (int)this.selections.values().stream().filter(team2 -> team2.equals(team)).count();
    }

    public IArena getArena() {
        return this.arena;
    }

    public List<Player> getMembers(ITeam team) {
        ArrayList<Player> members = new ArrayList<Player>();
        if (this.selections.isEmpty()) {
            return members;
        }
        this.selections.entrySet().stream().filter(entry -> ((ITeam)entry.getValue()).equals(team)).forEach(entry -> members.add((Player)entry.getKey()));
        return members;
    }

    public void setPlayerTeam(Player player, ITeam team) {
        this.selections.remove(player);
        this.selections.put(player, team);
    }

    public HashMap<Player, ITeam> getSelections() {
        return this.selections;
    }
}

