/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector.configuration;

import com.andrei1058.bedwars.api.configuration.ConfigManager;
import com.andrei1058.bedwars.teamselector.Main;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Config {
    public static final String SELECTOR_ITEM_STACK_MATERIAL = "team-selector-item-stack";
    public static final String SELECTOR_SLOT = "team-selector-slot";
    public static final String GIVE_SELECTOR_SELECTED_TEAM_COLOR = "give-team-color";
    public static final String ALLOW_TEAM_CHANGE = "allow-team-change";
    public static final String ALLOW_MOVE_TROUGH_INVENTORY = "allow-move-in-inventory";
    public static final String BALANCE_TEAMS = "balance-teams";
    public static final String GUI_OPEN_SOUND = "gui-open-sound";
    public static final String SUCCESS_SOUND = "success-sound";
    public static final String ERROR_SOUND = "error-sound";
    public static ConfigManager config;

    private Config() {
    }

    public static void addDefaultConfig() {
        new File("plugins/BedWars1058/Addons/TeamSelector").mkdirs();
        config = new ConfigManager((Plugin)Main.plugin, "config", "plugins/BedWars1058/Addons/TeamSelector");
        YamlConfiguration yml = config.getYml();
        yml.options().header("Team Selector Add-on for BedWars1058 Mini-game.\n\nDocumentation:\nteam-selector-item-stack: WOOL - The material you want the team-selector item be.\nteam-selector-slot: 0 - The slot where to put the item. Set it to -1 to assign the first empty slot.\ngive-team-color: true - True if you the selector to have the selected team's color.\nallow-team-change: true - True if you want to allow players to change selected team.\nallow-move-in-inventory: false - True if you want to allow players to move it in inventory.\nbalance-teams: true - True if you want to have balanced teams size.\ngui-open-sound: BLOCK_SHULKER_BOX_OPEN - The sound to be played when you open the team selector.\nsuccess-sound: BLOCK_SHULKER_BOX_CLOSE - The sound to be played when you select a team successfully.\nerror-sound: BLOCK_ANVIL_DESTROY - The sound to be played when you can't select a team.\nSounds for latest version: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html\nSounds for 1.8 or older: http://docs.codelanx.com/Bukkit/1.8/org/bukkit/Sound.html");
        yml.addDefault(SELECTOR_ITEM_STACK_MATERIAL, (Object)Main.bw.getForCurrentVersion("WOOL", "WOOL", "WHITE_WOOL"));
        yml.addDefault(SELECTOR_SLOT, (Object)4);
        yml.addDefault(GIVE_SELECTOR_SELECTED_TEAM_COLOR, (Object)true);
        yml.addDefault(ALLOW_TEAM_CHANGE, (Object)true);
        yml.addDefault(ALLOW_MOVE_TROUGH_INVENTORY, (Object)false);
        yml.addDefault(BALANCE_TEAMS, (Object)true);
        yml.addDefault(GUI_OPEN_SOUND, (Object)Main.bw.getForCurrentVersion("CHEST_OPEN", "CHEST_OPEN", "BLOCK_SHULKER_BOX_OPEN"));
        yml.addDefault(SUCCESS_SOUND, (Object)Main.bw.getForCurrentVersion("CHEST_CLOSE", "CHEST_CLOSE", "BLOCK_SHULKER_BOX_CLOSE"));
        yml.addDefault(ERROR_SOUND, (Object)Main.bw.getForCurrentVersion("ANVIL_BREAK", "ANVIL_BREAK", "BLOCK_ANVIL_DESTROY"));
        yml.options().copyDefaults(true);
        config.save();
    }

    public static void playSound(Player player, String path) {
        if (player == null) {
            return;
        }
        String sound = config.getString(path);
        try {
            player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, 1.0f);
        }
        catch (Exception ex) {
            Config.sendSoundLog(sound);
        }
    }

    private static void sendSoundLog(String sound) {
        Main.plugin.getLogger().log(Level.SEVERE, sound + " it't not a valid sound for your server version!");
    }
}

