/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector;

import com.andrei1058.bedwars.api.BedWars;
import com.andrei1058.bedwars.teamselector.api.TeamSelector;
import com.andrei1058.bedwars.teamselector.api.TeamSelectorAPI;
import com.andrei1058.bedwars.teamselector.configuration.Config;
import com.andrei1058.bedwars.teamselector.configuration.Messages;
import com.andrei1058.bedwars.teamselector.libs.bukkit.Metrics;
import com.andrei1058.bedwars.teamselector.listeners.ArenaListener;
import com.andrei1058.bedwars.teamselector.listeners.InventoryListener;
import com.andrei1058.bedwars.teamselector.listeners.PlayerInteractListener;
import com.andrei1058.bedwars.teamselector.listeners.SelectorGuiUpdateListener;
import com.andrei1058.spigot.updater.SpigotUpdater;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static BedWars bw;
    public static Main plugin;

    private static void registerListeners(Listener ... listeners) {
        PluginManager pm = Bukkit.getPluginManager();
        for (Listener l : listeners) {
            pm.registerEvents(l, (Plugin)plugin);
        }
    }

    public void onEnable() {
        plugin = this;
        if (Bukkit.getPluginManager().getPlugin("BedWars1058") == null) {
            this.getLogger().severe("BedWars1058 was not found. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        bw = (BedWars)Bukkit.getServicesManager().getRegistration(BedWars.class).getProvider();
        if (bw == null) {
            this.getLogger().severe("Can't hook into BedWars1058.");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        Bukkit.getServicesManager().register(TeamSelectorAPI.class, (Object)new TeamSelector(), (Plugin)this, ServicePriority.Normal);
        this.getLogger().info("Hook into BedWars1058!");
        Config.addDefaultConfig();
        Messages.setupMessages();
        Main.registerListeners(new ArenaListener(), new InventoryListener(), new PlayerInteractListener(), new SelectorGuiUpdateListener());
        Metrics metrics = new Metrics((Plugin)this, 9091);
        metrics.addCustomChart(new Metrics.SimplePie("selector_slot", () -> String.valueOf(Config.config.getInt("team-selector-slot"))));
        metrics.addCustomChart(new Metrics.SimplePie("allot_team_change", () -> String.valueOf(Config.config.getBoolean("allow-team-change"))));
        metrics.addCustomChart(new Metrics.SimplePie("balance_teams", () -> String.valueOf(Config.config.getBoolean("balance-teams"))));
        metrics.addCustomChart(new Metrics.SimplePie("balance_teams", () -> String.valueOf(Config.config.getBoolean("balance-teams"))));
        new SpigotUpdater((Plugin)this, 60438, true).checkUpdate();
    }
}

