/*
 * Decompiled with CFR 0.152.
 */
package depend.xxmicloxx.NoteBlockAPI.utils;

import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import depend.xxmicloxx.NoteBlockAPI.model.Layer;
import depend.xxmicloxx.NoteBlockAPI.model.Note;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class NBSDecoder {
    public static Song parse(File decodeFile) {
        try {
            return NBSDecoder.parse(new FileInputStream(decodeFile), decodeFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Song parse(InputStream inputStream) {
        return NBSDecoder.parse(inputStream, null);
    }

    private static Song parse(InputStream inputStream, File decodeFile) {
        HashMap<Integer, Layer> layerHashMap = new HashMap<Integer, Layer>();
        try {
            short jumpTicks;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            short length = NBSDecoder.readShort(dataInputStream);
            byte nbsversion = 0;
            if (length == 0) {
                nbsversion = dataInputStream.readByte();
                dataInputStream.readByte();
                if (nbsversion >= 3) {
                    length = NBSDecoder.readShort(dataInputStream);
                }
            }
            int songHeight = NBSDecoder.readShort(dataInputStream);
            String title = NBSDecoder.readString(dataInputStream);
            String author = NBSDecoder.readString(dataInputStream);
            NBSDecoder.readString(dataInputStream);
            String description = NBSDecoder.readString(dataInputStream);
            float speed = (float)NBSDecoder.readShort(dataInputStream) / 100.0f;
            dataInputStream.readBoolean();
            dataInputStream.readByte();
            dataInputStream.readByte();
            NBSDecoder.readInt(dataInputStream);
            NBSDecoder.readInt(dataInputStream);
            NBSDecoder.readInt(dataInputStream);
            NBSDecoder.readInt(dataInputStream);
            NBSDecoder.readInt(dataInputStream);
            NBSDecoder.readString(dataInputStream);
            if (nbsversion >= 4) {
                dataInputStream.readByte();
                dataInputStream.readByte();
                NBSDecoder.readShort(dataInputStream);
            }
            short tick = -1;
            while ((jumpTicks = NBSDecoder.readShort(dataInputStream)) != 0) {
                short jumpLayers;
                tick = (short)(tick + jumpTicks);
                int layer = -1;
                while ((jumpLayers = NBSDecoder.readShort(dataInputStream)) != 0) {
                    layer = (short)(layer + jumpLayers);
                    byte instrument = dataInputStream.readByte();
                    byte key = dataInputStream.readByte();
                    byte velocity = 100;
                    int panning = 100;
                    short pitch = 0;
                    if (nbsversion >= 4) {
                        velocity = dataInputStream.readByte();
                        panning = 200 - dataInputStream.readUnsignedByte();
                        pitch = NBSDecoder.readShort(dataInputStream);
                    }
                    NBSDecoder.setNote(layer, tick, new Note(instrument, key, velocity, panning, pitch), layerHashMap);
                }
            }
            if (nbsversion > 0 && nbsversion < 3) {
                length = tick;
            }
            for (int i = 0; i < songHeight; ++i) {
                Layer layer = (Layer)layerHashMap.get(i);
                String name = NBSDecoder.readString(dataInputStream);
                if (nbsversion >= 4) {
                    dataInputStream.readByte();
                }
                byte volume = dataInputStream.readByte();
                int panning = 100;
                if (nbsversion >= 2) {
                    panning = 200 - dataInputStream.readUnsignedByte();
                }
                if (layer == null) continue;
                layer.setName(name);
                layer.setVolume(volume);
                layer.setPanning(panning);
            }
            return new Song(speed, layerHashMap, (short)songHeight, length, title, author, description, decodeFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (EOFException e) {
            String file = "";
            if (decodeFile != null) {
                file = decodeFile.getName();
            }
            LoggerManager.warn("This song is corrupted. File: " + file);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setNote(int layerIndex, int ticks, Note note, HashMap<Integer, Layer> layerHashMap) {
        Layer layer = layerHashMap.get(layerIndex);
        if (layer == null) {
            layer = new Layer();
            layerHashMap.put(layerIndex, layer);
        }
        layer.setNote(ticks, note);
    }

    private static short readShort(DataInputStream dataInputStream) throws IOException {
        int byte1 = dataInputStream.readUnsignedByte();
        int byte2 = dataInputStream.readUnsignedByte();
        return (short)(byte1 + (byte2 << 8));
    }

    private static int readInt(DataInputStream dataInputStream) throws IOException {
        int byte1 = dataInputStream.readUnsignedByte();
        int byte2 = dataInputStream.readUnsignedByte();
        int byte3 = dataInputStream.readUnsignedByte();
        int byte4 = dataInputStream.readUnsignedByte();
        return byte1 + (byte2 << 8) + (byte3 << 16) + (byte4 << 24);
    }

    private static String readString(DataInputStream dataInputStream) throws IOException {
        int length;
        StringBuilder stringBuilder = new StringBuilder(length);
        for (length = NBSDecoder.readInt(dataInputStream); length > 0; --length) {
            char c = (char)dataInputStream.readByte();
            if (c == '\r') {
                c = ' ';
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

