/*
 * Decompiled with CFR 0.152.
 */
package depend.xxmicloxx.NoteBlockAPI.songplayer;

import depend.xxmicloxx.NoteBlockAPI.NoteBlockAPI;
import depend.xxmicloxx.NoteBlockAPI.model.Layer;
import depend.xxmicloxx.NoteBlockAPI.model.NotePitch;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import depend.xxmicloxx.NoteBlockAPI.songplayer.RangeSongPlayer;
import depend.xxmicloxx.NoteBlockAPI.utils.InstrumentUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class NoteBlockSongPlayer
extends RangeSongPlayer {
    private Block noteBlock;

    public NoteBlockSongPlayer(Song song) {
        super(song);
    }

    public Block getNoteBlock() {
        return this.noteBlock;
    }

    public void setNoteBlock(Block noteBlock) {
        this.noteBlock = noteBlock;
    }

    @Override
    public void playTick(Player player, int tick) {
        if (this.noteBlock.getType() != Material.NOTE_BLOCK) {
            return;
        }
        if (!player.getWorld().getName().equals(this.noteBlock.getWorld().getName())) {
            return;
        }
        byte playerVolume = NoteBlockAPI.getPlayerVolume(player);
        Location loc = this.noteBlock.getLocation();
        loc = new Location(loc.getWorld(), loc.getX() + 0.5, loc.getY() - 0.5, loc.getZ() + 0.5);
        for (Layer layer : this.song.getLayerHashMap().values()) {
            depend.xxmicloxx.NoteBlockAPI.model.Note note = layer.getNote(tick);
            if (note == null) continue;
            player.playNote(loc, InstrumentUtils.getBukkitInstrument(note.getInstrument()), new Note(note.getKey() - 33));
            float volume = (float)(layer.getVolume() * this.volume * playerVolume * note.getVelocity()) / 1.0E8f * (0.0625f * (float)this.getDistance());
            float pitch = NotePitch.getPitch(note.getKey() - 33);
            player.playSound(loc, InstrumentUtils.getInstrument(note.getInstrument()), volume, pitch);
        }
    }

    @Override
    public boolean isInRange(Player player) {
        Location loc = this.noteBlock.getLocation();
        loc = new Location(loc.getWorld(), loc.getX() + 0.5, loc.getY() - 0.5, loc.getZ() + 0.5);
        return !(player.getLocation().distance(loc) > (double)this.getDistance());
    }
}

