/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.GMiniBlock;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.Animation;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class HalloweenAnimation
extends Animation {
    private ArmorStand armorStand;
    private float volume = 0.05f;
    private BlockFace blockFace = this.getMysteryVault().getBlockFace();
    private static float[] pitch = new float[]{0.5f, 0.529732f, 0.561231f, 0.594604f, 0.629961f, 0.66742f, 0.707107f, 0.749154f, 0.793701f, 0.840896f, 0.890899f, 0.943874f, 1.0f, 1.059463f, 1.122462f, 1.189207f, 1.259921f, 1.33484f, 1.414214f, 1.498307f, 1.587401f, 1.681793f, 1.781797f, 1.887749f, 2.0f};

    public HalloweenAnimation(PlayerManager pManager, MysteryVault mysteryVault, Quality quality, long delay) {
        super(pManager, mysteryVault, AnimationType.HALLOWEEN, quality, delay);
    }

    @Override
    public void onStart() {
        Location location = this.getMysteryVault().getLocation();
        location = new Location(location.getWorld(), location.getX() + 0.5, location.getY() - 0.4, location.getZ() + 0.5, GMiniBlock.getYawByBlockFace(this.getMysteryVault().getBlockFace()), 0.0f);
        ArmorStand miniBlock = (ArmorStand)this.getPlayer().getWorld().spawnEntity(location.clone(), EntityType.ARMOR_STAND);
        miniBlock.setVisible(false);
        miniBlock.setGravity(false);
        miniBlock.setSmall(true);
        try {
            miniBlock.setMarker(false);
            miniBlock.setCollidable(false);
            miniBlock.setSilent(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        miniBlock.setHelmet(this.getAnimation().getMiniBlock().getItemStack());
        miniBlock.setBasePlate(false);
        miniBlock.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.armorStand = miniBlock;
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 6, 0L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 9, 4L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 11, 8L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 13, 12L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 7, 16L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 11, 20L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 13, 24L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 14, 28L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 9, 32L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 12, 36L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 15, 40L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 16, 44L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 10, 48L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 14, 52L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 16, 56L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HARP, 18, 60L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 4L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 12L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 20L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 28L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 36L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 44L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 52L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_HAT, 12, 60L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 0L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 8L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 16L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 24L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 32L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 40L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 48L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_SNARE, 12, 56L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 1, 0L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 2, 2L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 3, 4L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 2, 6L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 3, 8L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 10L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 12L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 3, 14L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 16L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 18L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 20L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 22L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 24L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 26L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 28L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 30L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 32L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 4, 34L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 36L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 5, 38L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 40L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 42L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 44L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 6, 46L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 48L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 50L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 7, 52L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 54L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 56L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 9, 58L);
        this.playSound(SoundEffect.BLOCK_NOTE_BLOCK_BASS, 8, 60L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 16, 0L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 17, 2L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 18, 4L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 15, 6L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 18, 8L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 10L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 12L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 18, 14L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 16L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 18L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 20L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 22L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 24L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 26L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 28L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 30L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 32L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 19, 34L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 36L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 20, 38L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 40L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 42L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 44L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 21, 46L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 48L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 50L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 22, 52L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 54L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 56L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 24, 58L);
        this.playSound(SoundEffect.ENTITY_EXPERIENCE_ORB_TOUCH, 23, 60L);
    }

    @Override
    public void onUpdate() {
        Location loc;
        if (this.steps > 0 && this.steps <= 15) {
            loc = this.armorStand.getLocation().clone();
            loc.setY(loc.getY() + 0.05);
            this.armorStand.teleport(loc);
        }
        if (this.steps > 15 && this.steps <= 55) {
            loc = this.armorStand.getLocation().clone();
            double inc = 0.05235987755982988;
            double angle = (double)((this.steps + 100) * 3) * inc;
            Vector v = new Vector();
            if (this.blockFace == BlockFace.EAST) {
                v.setX(Math.sin(angle) * 0.3 / 4.0);
                v.setZ(-(Math.cos(angle) * 0.3) / 4.0);
            } else if (this.blockFace == BlockFace.SOUTH) {
                v.setX(Math.cos(angle) * 0.3 / 4.0);
                v.setZ(Math.sin(angle) * 0.3 / 4.0);
            } else if (this.blockFace == BlockFace.WEST) {
                v.setX(-(Math.sin(angle) * 0.3) / 4.0);
                v.setZ(Math.cos(angle) * 0.3 / 4.0);
            } else if (this.blockFace == BlockFace.NORTH) {
                v.setX(-(Math.cos(angle) * 0.3) / 4.0);
                v.setZ(-(Math.sin(angle) * 0.3) / 4.0);
            }
            loc.add(v);
            loc.setY(loc.getY() + 0.05625);
            this.armorStand.teleport(loc);
        }
    }

    @Override
    public void onUpdateParticleEffect() {
        if (this.armorStand == null) {
            return;
        }
        if (this.steps <= 55) {
            ParticleEffect.FIREWORKS_SPARK.display(this.armorStand.getEyeLocation().add(0.0, VersionManager.is1_13OrAbove() ? 0.15 : -0.4, 0.0), 1);
            if (this.steps % 4 == 0) {
                ParticleEffect.REDSTONE.displayRandomColor(this.armorStand.getEyeLocation().add(0.0, VersionManager.is1_13OrAbove() ? 0.15 : -0.4, 0.0));
            }
        }
        if (this.steps > 55) {
            ParticleEffect.CRIT_MAGIC.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.22f, 0.22f, 0.22f);
        }
    }

    @Override
    public void onUpdateSound() {
        if (this.steps == 1) {
            SoundEffect.ENTITY_FIREWORK_ROCKET_LAUNCH.playSound(this.getMysteryVault().getLocation().clone(), 0.4f, 1.0f);
        }
        if (this.armorStand == null) {
            return;
        }
        if (this.steps <= this.getQuality().getQuality() * 10 && this.steps % 10 == 0) {
            SoundEffect.ENTITY_ITEM_PICKUP.playSound(this.armorStand.getLocation().clone(), 1.0f, 1.0f);
        }
        if (this.steps > 55) {
            if (this.armorStand == null) {
                return;
            }
            if (this.steps <= 79) {
                ParticleEffect.ENCHANTMENT_TABLE.display(this.armorStand.getLocation().clone().add(0.0, 1.9, 0.0), 5.0f, 15);
                SoundEffect.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR.playSound(this.armorStand.getLocation().clone(), this.volume += 0.006f, 1.0f);
            } else if (this.steps <= 83) {
                SoundEffect.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR.playSound(this.armorStand.getLocation().clone(), 1.0f, 1.0f);
            } else if (this.steps == 129) {
                SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(this.armorStand.getLocation().clone());
            } else if (this.steps == 134) {
                ParticleEffect.LAVA.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.0f, 45);
                ParticleEffect.FLAME.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.45f, 40);
            } else if (this.steps == 149) {
                ParticleEffect.CLOUD.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.7f, 0.7f, 0.7f);
                SoundEffect.ENTITY_EXPERIENCE_ORB_PICKUP.playSound(this.armorStand.getLocation());
            } else if (this.steps > 149 && this.steps < 179) {
                ParticleEffect.CLOUD.display(this.armorStand.getLocation().clone().add(0.0, 0.8, 0.0), 0.7f, 0.7f, 0.7f);
            } else if (this.steps >= 179) {
                this.onClear();
                this.isContinue = false;
            }
        }
    }

    @Override
    public void onClear() {
        if (this.armorStand != null && this.armorStand.isValid()) {
            this.armorStand.remove();
            this.armorStand = null;
        }
        if (MysteryVaultManager.activatedVaults().contains(this.getMysteryVault())) {
            MysteryVaultManager.activatedVaults().remove(this.getMysteryVault());
        }
        this.getPlayerManager().setOpeningMysteryBox(false);
    }

    private void playSound(final SoundEffect sound, final int p, long delay) {
        new BukkitRunnable(){

            public void run() {
                sound.playSound(HalloweenAnimation.this.getMysteryVault().getLocation().clone(), 1.0f, pitch[p]);
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), delay);
    }
}

