/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations;

import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class GQualityBlock {
    private GMaterial material;
    private int rotationalAngleX;
    private int rotationalAngleY;
    private int rotationalAngleZ;
    private ItemStack itemStack;
    private boolean hasRotate;

    public GQualityBlock(GMaterial material) {
        this.material = material;
        this.rotationalAngleX = 0;
        this.rotationalAngleY = 0;
        this.rotationalAngleZ = 0;
        this.hasRotate = false;
        this.itemStack = this.material.isSkullHead() ? ItemUtils.itemSkull("quality block", null, this.material.getTexture()) : ItemUtils.item("quality block", this.material.getEnumMaterial(), this.material.getData());
    }

    public GQualityBlock(GMaterial material, int rotationalAngleX, int rotationalAngleY, int rotationalAngleZ) {
        this.material = material;
        this.rotationalAngleX = rotationalAngleX;
        this.rotationalAngleY = rotationalAngleY;
        this.rotationalAngleZ = rotationalAngleZ;
        this.hasRotate = true;
        this.itemStack = this.material.isSkullHead() ? ItemUtils.itemSkull("quality block", null, this.material.getTexture()) : ItemUtils.item("quality block", this.material.getEnumMaterial(), this.material.getData());
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public boolean hasRotate() {
        return this.hasRotate;
    }

    public int getRotationalAngleX() {
        return this.rotationalAngleX;
    }

    public int getRotationalAngleY() {
        return this.rotationalAngleY;
    }

    public int getRotationalAngleZ() {
        return this.rotationalAngleZ;
    }

    public EulerAngle getEulerAngle() {
        return new EulerAngle(GQualityBlock.degreeToRadians(this.rotationalAngleX), GQualityBlock.degreeToRadians(this.rotationalAngleY), GQualityBlock.degreeToRadians(this.rotationalAngleZ));
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String toString() {
        return this.itemStack.toString();
    }

    private static double degreeToRadians(int degree) {
        return (double)degree / 180.0 * Math.PI;
    }
}

