/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.GMiniBlock;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.GQualityBlock;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.Animation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.CountdownAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.CraftingAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.HalloweenAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.HolidayAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.NoneAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.NormalAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.StarAnimation;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.SummerAnimation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AnimationType {
    private static final List<AnimationType> ENABLED = new ArrayList<AnimationType>();
    private static final List<AnimationType> VALUES = new ArrayList<AnimationType>();
    public static final AnimationType NONE = new AnimationType("None", "&aAnimation: None", new GMaterial(EnumMaterial.BARRIER), Arrays.asList("&7Set your mystery vault", "&7animation to &aNone&7."), new GMiniBlock(new GMaterial(EnumMaterial.ENDER_CHEST)), "gadgetsmenu.animations.none", 1L, 20L, NoneAnimation.class);
    public static final AnimationType NORMAL = new AnimationType("Normal", "&aAnimation: Normal", new GMaterial(EnumMaterial.ENDER_CHEST), Arrays.asList("&7Set your mystery vault", "&7animation to &aNormal&7."), new GMiniBlock(new GMaterial(EnumMaterial.ENDER_CHEST)), "gadgetsmenu.animations.normal", 1L, 120L, NormalAnimation.class);
    public static final AnimationType COUNTDOWN = new AnimationType("CountDown", "&aAnimation: Countdown", new GMaterial(EnumMaterial.CLOCK), Arrays.asList("&7Set your mystery vault", "&7animation to &aCountdown&7."), new GMiniBlock(new GMaterial(EnumMaterial.ENDER_CHEST)), "gadgetsmenu.animations.countdown", 1L, 260L, CountdownAnimation.class);
    public static final AnimationType STAR = new AnimationType("Star", "&aAnimation: Star", new GMaterial(EnumMaterial.NETHER_STAR), Arrays.asList("&7Set your mystery vault", "&7animation to &aStar&7."), new GMiniBlock(new GMaterial(EnumMaterial.ENDER_CHEST)), new GQualityBlock(new GMaterial(EnumMaterial.NETHER_STAR)), "gadgetsmenu.animations.star", 1L, 219L, StarAnimation.class);
    public static final AnimationType CRAFTING = new AnimationType("Crafting", "&aAnimation: Crafting", new GMaterial(EnumMaterial.CRAFTING_TABLE), Arrays.asList("&7Set your mystery vault", "&7animation to &aCrafting&7."), new GMiniBlock(new GMaterial(EnumMaterial.ENDER_CHEST)), new GQualityBlock(new GMaterial(EnumMaterial.CRAFTING_TABLE), 270, 0, 45), "gadgetsmenu.animations.crafting", 1L, 219L, CraftingAnimation.class);
    public static final AnimationType SUMMER = new AnimationType("Summer", "&aAnimation: Summer", new GMaterial(EnumMaterial.SUNFLOWER), Arrays.asList("&7Set your mystery vault", "&7animation to &aSummer&7."), new GMiniBlock(new GMaterial("head:5a5ab05ea254c32e3c48f3fdcf9fd9d77d3cba04e6b5ec2e68b3cbdcfac3fd")), new GQualityBlock(new GMaterial(EnumMaterial.SUNFLOWER)), "gadgetsmenu.animations.summer", 1L, 219L, SummerAnimation.class);
    public static final AnimationType HALLOWEEN = new AnimationType("Halloween", "&aAnimation: Halloween", new GMaterial(EnumMaterial.JACK_O_LANTERN), Arrays.asList("&7Set your mystery vault", "&7animation to &aHalloween&7."), new GMiniBlock(new GMaterial(EnumMaterial.JACK_O_LANTERN)), "gadgetsmenu.animations.halloween", 1L, 159L, HalloweenAnimation.class);
    public static final AnimationType HOLIDAY = new AnimationType("Holiday", "&aAnimation: Holiday", new GMaterial(EnumMaterial.SNOWBALL), Arrays.asList("&7Set your mystery vault", "&7animation to &aHoliday&7."), new GMiniBlock(new GMaterial("head:f5612dc7b86d71afc1197301c15fd979e9f39e7b1f41d8f1ebdf8115576e2e")), new GQualityBlock(new GMaterial(EnumMaterial.SNOWBALL)), "gadgetsmenu.animations.holiday", 1L, 219L, HolidayAnimation.class);
    public static final AnimationType RANDOM = new AnimationType("Random", "Random");
    private String name;
    private String displayName;
    private GMaterial material;
    private List<String> lore;
    private GMiniBlock miniBlock;
    private GQualityBlock qualityBlock;
    private String permission;
    private long repeatDelay;
    private long durationTime;
    private Class<?> clazz;
    private boolean isEnable;

    private AnimationType(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.permission = EnumPermission.RANDOM_MYSTERY_VAULT_ANIMATIONS.getPermission();
        this.isEnable = false;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    private AnimationType(String name, String displayName, GMaterial material, List<String> lore, GMiniBlock miniBlock, String permission, long repeatDelay, long durationTime, Class<?> clazz) {
        this.name = name;
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getAnimationsFile().getString("Animations." + this.name + ".Name");
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            this.material = new GMaterial(FileManager.getAnimationsFile().getString("Animations." + this.name + ".Material"));
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getAnimationsFile().getBoolean("Animations." + this.name + ".Enabled");
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Mini-Block.Material") == null) {
            this.miniBlock = miniBlock;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Mini-Block.Material", this.miniBlock.getMaterial().getCombinedMaterial());
        } else {
            this.miniBlock = new GMiniBlock(new GMaterial(FileManager.getAnimationsFile().getString("Animations." + this.name + ".Mini-Block.Material")));
        }
        this.qualityBlock = null;
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getAnimationsFile().set("Animations." + this.name + ".Lore", "");
            } else {
                FileManager.getAnimationsFile().set("Animations." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getAnimationsFile().getStringList("Animations." + this.name + ".Lore");
        }
        this.permission = permission;
        this.repeatDelay = repeatDelay;
        this.durationTime = durationTime;
        this.clazz = clazz;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    private AnimationType(String name, String displayName, GMaterial material, List<String> lore, GMiniBlock miniBlock, GQualityBlock qualityBlock, String permission, long repeatDelay, long durationTime, Class<?> clazz) {
        this.name = name;
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getAnimationsFile().getString("Animations." + this.name + ".Name");
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            this.material = new GMaterial(FileManager.getAnimationsFile().getString("Animations." + this.name + ".Material"));
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getAnimationsFile().getBoolean("Animations." + this.name + ".Enabled");
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Mini-Block.Material") == null) {
            this.miniBlock = miniBlock;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Mini-Block.Material", this.miniBlock.getMaterial().getCombinedMaterial());
        } else {
            this.miniBlock = new GMiniBlock(new GMaterial(FileManager.getAnimationsFile().getString("Animations." + this.name + ".Mini-Block.Material")));
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Mystery-Box-Quality-Block.Material") == null) {
            this.qualityBlock = qualityBlock;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Mystery-Box-Quality-Block.Material", this.qualityBlock.getMaterial().getCombinedMaterial());
        } else if (!qualityBlock.hasRotate()) {
            this.qualityBlock = new GQualityBlock(new GMaterial(FileManager.getAnimationsFile().getString("Animations." + this.name + ".Mystery-Box-Quality-Block.Material")));
        }
        if (qualityBlock.hasRotate() && FileManager.getAnimationsFile().get("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle") == null) {
            this.qualityBlock = qualityBlock;
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle.X", this.qualityBlock.getRotationalAngleX());
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle.Y", this.qualityBlock.getRotationalAngleY());
            FileManager.getAnimationsFile().set("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle.Z", this.qualityBlock.getRotationalAngleZ());
        } else if (qualityBlock.hasRotate()) {
            this.qualityBlock = new GQualityBlock(new GMaterial(FileManager.getAnimationsFile().getString("Animations." + this.name + ".Mystery-Box-Quality-Block.Material")), FileManager.getAnimationsFile().getInt("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle.X"), FileManager.getAnimationsFile().getInt("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle.Y"), FileManager.getAnimationsFile().getInt("Animations." + this.name + ".Mystery-Box-Quality-Block.Rotational-Angle.Z"));
        }
        if (FileManager.getAnimationsFile().get("Animations." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getAnimationsFile().set("Animations." + this.name + ".Lore", "");
            } else {
                FileManager.getAnimationsFile().set("Animations." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getAnimationsFile().getStringList("Animations." + this.name + ".Lore");
        }
        this.permission = permission;
        this.repeatDelay = repeatDelay;
        this.durationTime = durationTime;
        this.clazz = clazz;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public GMiniBlock getMiniBlock() {
        return this.miniBlock;
    }

    public GQualityBlock getQualityBlock() {
        return this.qualityBlock;
    }

    public String getPermission() {
        return this.permission;
    }

    public long getRepeatDelay() {
        return this.repeatDelay;
    }

    public long getDurationTime() {
        return this.durationTime;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public static List<AnimationType> enabled() {
        return ENABLED;
    }

    public static List<AnimationType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (AnimationType type : AnimationType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public Animation equip(PlayerManager playerManager, MysteryVault mysteryVault, Quality quality, long delay) {
        Animation animation = null;
        try {
            animation = (Animation)this.clazz.getDeclaredConstructor(PlayerManager.class, MysteryVault.class, Quality.class, Long.TYPE).newInstance(new Object[]{playerManager, mysteryVault, quality, delay});
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return animation;
    }

    public String toString() {
        return this.name;
    }

    public static AnimationType valueOf(String name) throws NullPointerException {
        for (AnimationType type : AnimationType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

