/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryvault;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;

public class MysteryVaultManager {
    private static ArrayList<MysteryVault> vaults = new ArrayList();
    private static ArrayList<MysteryVault> activatedVaults = new ArrayList();
    private static boolean isIndividualHologramEnable = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Holograms.Individual-Holograms.Enabled");
    private static ArrayList<String> availableMysteryBoxesHolograms = new ArrayList();
    private static String zeroMysteryBoxesHologram = null;

    public static void loadMysteryVaults() {
        if (FileManager.getMysteryVaultFile().get("Mystery-Vaults") != null) {
            for (String vault : MysteryVaultUtils.getKeys(FileManager.getMysteryVaultFile(), "Mystery-Vaults")) {
                BlockFace blockFace = BlockFace.valueOf((String)FileManager.getMysteryVaultFile().getString("Mystery-Vaults." + vault + ".BlockFace"));
                Location location = MysteryVaultUtils.getLocation(FileManager.getMysteryVaultFile(), "Mystery-Vaults." + vault + ".Location");
                MysteryVault mysteryVault = new MysteryVault(vault, blockFace, location);
                vaults.add(mysteryVault);
            }
        }
    }

    public static boolean isIndividualHologramEnabled() {
        return isIndividualHologramEnable;
    }

    public static ArrayList<String> getAvailableMysteryBoxesHolograms() {
        if (availableMysteryBoxesHolograms.isEmpty()) {
            for (String holograms : FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Holograms.Individual-Holograms.Available-Mystery-Boxes")) {
                availableMysteryBoxesHolograms.add(ChatUtil.format(holograms));
            }
            return availableMysteryBoxesHolograms;
        }
        return availableMysteryBoxesHolograms;
    }

    public static String getZeroMysteryBoxAvailableHologram() {
        if (zeroMysteryBoxesHologram == null) {
            zeroMysteryBoxesHologram = ChatUtil.format(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Holograms.Individual-Holograms.Zero-Mystery-Box-Available"));
            return zeroMysteryBoxesHologram;
        }
        if (zeroMysteryBoxesHologram.equals("")) {
            zeroMysteryBoxesHologram = ChatUtil.format("&c");
            return zeroMysteryBoxesHologram;
        }
        return zeroMysteryBoxesHologram;
    }

    public static void forceRemoveHolograms() {
        for (MysteryVault vault : vaults) {
            vault.removeHolograms();
        }
    }

    public static void forceRemoveIndividualHologram() {
        for (MysteryVault vault : vaults) {
            vault.removeIndividualHologram();
        }
    }

    public static void forceRemoveLootHologram() {
        for (MysteryVault vault : vaults) {
            vault.removeLootHologram();
        }
    }

    public static MysteryVault getVaultByName(String name) {
        for (MysteryVault vault : vaults) {
            if (!vault.getName().equalsIgnoreCase(name)) continue;
            return vault;
        }
        return null;
    }

    public static MysteryVault getVaultByLocation(Location location) {
        for (MysteryVault vault : vaults) {
            if (!vault.getLocation().equals((Object)location)) continue;
            return vault;
        }
        return null;
    }

    public static ArrayList<MysteryVault> vaults() {
        return vaults;
    }

    public static ArrayList<MysteryVault> activatedVaults() {
        return activatedVaults;
    }
}

