/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Quality;
import java.util.List;

public enum MysteryBoxType {
    NORMAL_MYSTERY_BOX_1("Normal Mystery Box #1", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.One-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.One-Star.Material")), "gadgetsmenu.mysteryboxes.open.1", Quality.ONE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Normal-Mystery-Box.One-Star.Lore")),
    NORMAL_MYSTERY_BOX_2("Normal Mystery Box #2", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Two-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Two-Star.Material")), "gadgetsmenu.mysteryboxes.open.2", Quality.TWO_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Normal-Mystery-Box.Two-Star.Lore")),
    NORMAL_MYSTERY_BOX_3("Normal Mystery Box #3", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Three-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Three-Star.Material")), "gadgetsmenu.mysteryboxes.open.3", Quality.THREE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Normal-Mystery-Box.Three-Star.Lore")),
    NORMAL_MYSTERY_BOX_4("Normal Mystery Box #4", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Four-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Four-Star.Material")), "gadgetsmenu.mysteryboxes.open.4", Quality.FOUR_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Normal-Mystery-Box.Four-Star.Lore")),
    NORMAL_MYSTERY_BOX_5("Normal Mystery Box #5", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Five-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Normal-Mystery-Box.Five-Star.Material")), "gadgetsmenu.mysteryboxes.open.5", Quality.FIVE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Normal-Mystery-Box.Five-Star.Lore")),
    GIFTED_MYSTERY_BOX_1("Gifted Mystery Box #1", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.One-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.One-Star.Material")), "gadgetsmenu.mysteryboxes.open.1", Quality.ONE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Gifted-Mystery-Box.One-Star.Lore")),
    GIFTED_MYSTERY_BOX_2("Gifted Mystery Box #2", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Two-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Two-Star.Material")), "gadgetsmenu.mysteryboxes.open.2", Quality.TWO_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Gifted-Mystery-Box.Two-Star.Lore")),
    GIFTED_MYSTERY_BOX_3("Gifted Mystery Box #3", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Three-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Three-Star.Material")), "gadgetsmenu.mysteryboxes.open.3", Quality.THREE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Gifted-Mystery-Box.Three-Star.Lore")),
    GIFTED_MYSTERY_BOX_4("Gifted Mystery Box #4", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Four-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Four-Star.Material")), "gadgetsmenu.mysteryboxes.open.4", Quality.FOUR_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Gifted-Mystery-Box.Four-Star.Lore")),
    GIFTED_MYSTERY_BOX_5("Gifted Mystery Box #5", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Five-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Gifted-Mystery-Box.Five-Star.Material")), "gadgetsmenu.mysteryboxes.open.5", Quality.FIVE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Gifted-Mystery-Box.Five-Star.Lore")),
    CRAFTED_MYSTERY_BOX_1("Crafted Mystery Box #1", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.One-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.One-Star.Material")), "gadgetsmenu.mysteryboxes.open.1", Quality.ONE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Crafted-Mystery-Box.One-Star.Lore")),
    CRAFTED_MYSTERY_BOX_2("Crafted Mystery Box #2", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Two-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Two-Star.Material")), "gadgetsmenu.mysteryboxes.open.2", Quality.TWO_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Crafted-Mystery-Box.Two-Star.Lore")),
    CRAFTED_MYSTERY_BOX_3("Crafted Mystery Box #3", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Three-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Three-Star.Material")), "gadgetsmenu.mysteryboxes.open.3", Quality.THREE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Crafted-Mystery-Box.Three-Star.Lore")),
    CRAFTED_MYSTERY_BOX_4("Crafted Mystery Box #4", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Four-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Four-Star.Material")), "gadgetsmenu.mysteryboxes.open.4", Quality.FOUR_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Crafted-Mystery-Box.Four-Star.Lore")),
    CRAFTED_MYSTERY_BOX_5("Crafted Mystery Box #5", FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Five-Star.Name"), new GMaterial(FileManager.getMysteryBoxesFile().getString("Mystery-Boxes.Types.Crafted-Mystery-Box.Five-Star.Material")), "gadgetsmenu.mysteryboxes.open.5", Quality.FIVE_STAR, FileManager.getMysteryBoxesFile().getStringList("Mystery-Boxes.Types.Crafted-Mystery-Box.Five-Star.Lore"));

    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private Quality quality;
    private List<String> lore;
    private boolean isNormalMysteryBox = false;
    private boolean isGiftedMysteryBox = false;
    private boolean isCraftedMysteryBox = false;

    private MysteryBoxType(String name, String displayName, GMaterial material, String permission, Quality quality, List<String> lore) {
        this.name = name;
        this.displayName = displayName;
        this.material = material;
        this.quality = quality;
        this.permission = permission;
        this.lore = lore;
        if (name.contains("Normal")) {
            this.isNormalMysteryBox = true;
        }
        if (name.contains("Gifted")) {
            this.isGiftedMysteryBox = true;
        }
        if (name.contains("Crafted")) {
            this.isCraftedMysteryBox = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public boolean isNormalMysteryBox() {
        return this.isNormalMysteryBox;
    }

    public boolean isGiftedMysteryBox() {
        return this.isGiftedMysteryBox;
    }

    public boolean isCraftedMysteryBox() {
        return this.isCraftedMysteryBox;
    }

    public String toString() {
        return this.name;
    }

    public static MysteryBoxType valueOfByName(String name) throws NullPointerException {
        for (MysteryBoxType type : MysteryBoxType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

