/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.EnumPotion;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemUtils {
    public static ItemStack item(ItemStack itemStack, String placeHolder, String replace) {
        ItemStack item = itemStack.clone();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.hasLore()) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : itemMeta.getLore()) {
                itemLore.add(ChatUtil.format(s1.replace(placeHolder, replace)));
            }
            itemMeta.setLore(itemLore);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack item(ItemStack itemStack, List<String> placeHolder, List<String> replace) {
        ItemStack item = itemStack.clone();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.hasLore()) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : itemMeta.getLore()) {
                if (placeHolder.size() == replace.size()) {
                    String lore = s1;
                    for (int i = 0; i < placeHolder.size(); ++i) {
                        lore = ChatUtil.format(lore.replace(placeHolder.get(i), replace.get(i)));
                    }
                    itemLore.add(lore);
                    continue;
                }
                itemLore.add(ChatUtil.format(s1));
            }
            itemMeta.setLore(itemLore);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack item(String displayName, EnumMaterial material) {
        return ItemUtils.item(displayName, material, material.getData(), null);
    }

    public static ItemStack item(String displayName, EnumMaterial material, int data) {
        return ItemUtils.item(displayName, material, data, null);
    }

    public static ItemStack item(String displayName, EnumMaterial material, int data, List<String> lore) {
        ItemStack item = new ItemStack(material.getType(), 1, (short)data);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(ChatUtil.format(displayName));
        if (lore != null) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
            itemMeta.setLore(itemLore);
        }
        if (VersionManager.is1_9OrAbove() && EnumPotion.isPotion(material)) {
            item.setDurability((short)0);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        if (VersionManager.is1_9OrAbove()) {
            if (!VersionManager.is1_13OrAbove() && material.isSpawnEgg()) {
                item = GadgetsMenu.getNMSManager().spawnEgg(item, EntityType.fromId((int)data).getName());
            }
            if (EnumPotion.isPotion(material)) {
                item = GadgetsMenu.getNMSManager().getPotionFromId(item, material, data);
            }
        }
        return item;
    }

    public static ItemStack item(String displayName, GMaterial material) {
        return ItemUtils.item(displayName, material, null);
    }

    public static ItemStack item(String displayName, GMaterial material, List<String> lore) {
        if (material.isSkullHead()) {
            return ItemUtils.itemSkull(displayName, lore, material.getTexture());
        }
        if (material.isBanner()) {
            ItemStack item = new ItemStack(material.getBannerPatterns().getBaseColor().getColoredBanner().getType(), 1);
            BannerMeta itemMeta = (BannerMeta)item.getItemMeta();
            itemMeta.setDisplayName(ChatUtil.format(displayName));
            if (material.getBannerPatterns().getBaseColor() != null) {
                itemMeta.setBaseColor(material.getBannerPatterns().getBaseColor().getColor());
            }
            if (material.getBannerPatterns().getPatterns() != null) {
                itemMeta.setPatterns(material.getBannerPatterns().getPatterns());
            }
            if (lore != null) {
                ArrayList<String> itemLore = new ArrayList<String>();
                for (String s1 : lore) {
                    itemLore.add(ChatUtil.format(s1));
                }
                itemMeta.setLore(itemLore);
            }
            InventoryUtils.addItemFlags((ItemMeta)itemMeta);
            item.setItemMeta((ItemMeta)itemMeta);
            return item;
        }
        EnumMaterial enumMaterial = material.getEnumMaterial();
        ItemStack item = new ItemStack(enumMaterial.getType(), 1, (short)enumMaterial.getData());
        ItemMeta itemMeta = item.getItemMeta();
        if (material.isColorableMaterial()) {
            itemMeta = (LeatherArmorMeta)item.getItemMeta();
            ((LeatherArmorMeta)itemMeta).setColor(material.getColor());
        }
        itemMeta.setDisplayName(ChatUtil.format(displayName));
        if (lore != null) {
            ArrayList<String> itemLore = new ArrayList<String>();
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
            itemMeta.setLore(itemLore);
        }
        if (VersionManager.is1_9OrAbove() && EnumPotion.isPotion(enumMaterial)) {
            item.setDurability((short)0);
        }
        InventoryUtils.addItemFlags(itemMeta);
        item.setItemMeta(itemMeta);
        if (VersionManager.is1_9OrAbove()) {
            if (!VersionManager.is1_13OrAbove() && material.getEnumMaterial().isSpawnEgg()) {
                item = GadgetsMenu.getNMSManager().spawnEgg(item, EntityType.fromId((int)enumMaterial.getData()).getName());
            }
            if (EnumPotion.isPotion(enumMaterial)) {
                item = GadgetsMenu.getNMSManager().getPotionFromId(item, material);
            }
        }
        return item;
    }

    public static ItemStack itemSkull(String displayName, String url) {
        return ItemUtils.itemSkull(displayName, null, url);
    }

    public static ItemStack itemSkull(String displayName, List<String> lore, String url) {
        if (!url.startsWith("http://textures.minecraft.net/texture/")) {
            url = "http://textures.minecraft.net/texture/" + url;
        }
        ItemStack head = new ItemStack(EnumMaterial.PLAYER_HEAD.getType(), 1, (short)EnumMaterial.PLAYER_HEAD.getData());
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        skullMeta.setDisplayName(ChatUtil.format(displayName));
        ArrayList<String> itemLore = new ArrayList<String>();
        if (lore != null) {
            for (String s1 : lore) {
                itemLore.add(ChatUtil.format(s1));
            }
            skullMeta.setLore(itemLore);
        }
        if (url.isEmpty()) {
            return head;
        }
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        try {
            ReflectionUtils.setValue(skullMeta, true, "profile", profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        InventoryUtils.addItemFlags((ItemMeta)skullMeta);
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }

    public static boolean getCurrentItem(InventoryClickEvent event, int slot) {
        return event.getSlot() == slot;
    }

    public static boolean getCurrentItem(InventoryClickEvent event, ItemStack itemStack) {
        return event.getCurrentItem().getType() == itemStack.getType() && event.getCurrentItem().getDurability() == itemStack.getDurability() && itemStack.hasItemMeta() && event.getCurrentItem().hasItemMeta() && itemStack.getItemMeta().hasDisplayName() && event.getCurrentItem().getItemMeta().hasDisplayName() && event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(itemStack.getItemMeta().getDisplayName()));
    }

    public static boolean getCurrentItem(InventoryClickEvent event, ItemStack itemStack, int slot) {
        return ItemUtils.getCurrentItem(event, itemStack) && event.getSlot() == slot;
    }

    public static boolean getCurrentItem(InventoryClickEvent event, String displayName, int slot) {
        return event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(displayName)) && event.getSlot() == slot;
    }

    public static boolean getCurrentItem(InventoryClickEvent event, String displayName, GMaterial material) {
        return ItemUtils.getCurrentItem(event, displayName, material.getEnumMaterial(), material.getData());
    }

    public static boolean getCurrentItem(InventoryClickEvent event, String displayName, GMaterial material, int slot) {
        return ItemUtils.getCurrentItem(event, displayName, material.getEnumMaterial(), material.getData(), slot);
    }

    public static boolean getCurrentItem(InventoryClickEvent event, String displayName, EnumMaterial material, int data, int slot) {
        return event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(displayName)) && event.getCurrentItem().getType() == material.getType() && event.getCurrentItem().getDurability() == data && event.getSlot() == slot;
    }

    public static boolean getCurrentItem(InventoryClickEvent event, String displayName, EnumMaterial material, int data) {
        return event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(displayName)) && event.getCurrentItem().getType() == material.getType() && event.getCurrentItem().getDurability() == data;
    }
}

