/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.discount;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class DiscountManager {
    private PlayerManager pManager;
    private boolean purchasable;
    private int price;
    private int discountedPrice;
    private List<String> lore;

    public DiscountManager(PlayerManager pManager, boolean purchasable, int price) {
        this.pManager = pManager;
        this.purchasable = purchasable;
        this.price = price;
        this.lore = new ArrayList<String>();
        if (purchasable) {
            ItemCostDiscount discount = DiscountManager.getHighestDiscountGroup(pManager.getPlayer());
            if (discount == null && pManager.getItemCostDiscount() != null) {
                pManager.setItemCostDiscount(null);
            }
            if (GadgetsMenu.getGadgetsMenuData().isItemCostDiscountEnabled() && GadgetsMenu.getGadgetsMenuData().isCosmeticItemDiscountEnabled() && discount != null) {
                pManager.setItemCostDiscount(discount);
                this.discountedPrice = discount.getPriceAfterDiscount(this.price);
                if (pManager.getMysteryDust() < this.discountedPrice) {
                    for (String s : discount.getNotEnoughMysteryDustLore()) {
                        this.lore.add(this.replacePlaceHolders(s, this.price).replace("{COST_LEFT}", String.valueOf(this.discountedPrice - pManager.getMysteryDust())));
                    }
                } else {
                    for (String s : discount.getEnoughMysteryDustLore()) {
                        this.lore.add(this.replacePlaceHolders(s, this.price));
                    }
                }
            } else if (pManager.getMysteryDust() < price) {
                for (String s : EnumItem.NOT_ENOUGH_MYSTERY_DUST.getLore()) {
                    this.lore.add(s.replace("{COST}", String.valueOf(price)).replace("{COST_LEFT}", String.valueOf(price - pManager.getMysteryDust())));
                }
            } else {
                for (String s : EnumItem.ENOUGH_MYSTERY_DUST.getLore()) {
                    this.lore.add(s.replace("{COST}", String.valueOf(price)));
                }
            }
        } else {
            for (String s : EnumItem.ITEM_UNPURCHASABLE.getLore()) {
                this.lore.add(s);
            }
        }
    }

    public DiscountManager(PlayerManager pManager, List<String> craftingMysteryBoxLore, int price) {
        this.pManager = pManager;
        this.purchasable = true;
        this.price = price;
        this.lore = new ArrayList<String>();
        this.lore.addAll(craftingMysteryBoxLore);
        ItemCostDiscount discount = DiscountManager.getHighestDiscountGroup(pManager.getPlayer());
        if (discount == null && pManager.getItemCostDiscount() != null) {
            pManager.setItemCostDiscount(null);
        }
        if (GadgetsMenu.getGadgetsMenuData().isItemCostDiscountEnabled() && GadgetsMenu.getGadgetsMenuData().isCraftingMysteryBoxDiscountEnabled() && discount != null) {
            pManager.setItemCostDiscount(discount);
            this.discountedPrice = discount.getPriceAfterDiscount(this.price);
            if (pManager.getMysteryDust() < this.discountedPrice) {
                for (String s : discount.getNotEnoughMysteryDustLore()) {
                    this.lore.add(this.replacePlaceHolders(s, this.price).replace("{COST_LEFT}", String.valueOf(this.discountedPrice - pManager.getMysteryDust())));
                }
            } else {
                for (String s : discount.getEnoughMysteryDustLore()) {
                    this.lore.add(this.replacePlaceHolders(s, this.price));
                }
            }
        } else if (pManager.getMysteryDust() < price) {
            for (String s : EnumItem.NOT_ENOUGH_MYSTERY_DUST_TO_CRAFT_MYSTERY_BOX.getLore()) {
                this.lore.add(s.replace("{COST}", String.valueOf(this.price)).replace("{COST_LEFT}", String.valueOf(price - pManager.getMysteryDust())));
            }
        } else {
            for (String s : EnumItem.ENOUGH_MYSTERY_DUST_TO_CRAFT_MYSTERY_BOX.getLore()) {
                this.lore.add(s.replace("{COST}", String.valueOf(this.price)));
            }
        }
    }

    public PlayerManager getPlayerManager() {
        return this.pManager;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public int getOldPrice() {
        return this.price;
    }

    public int getDiscountedPrice() {
        return this.discountedPrice;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public static ItemCostDiscount getHighestDiscountGroup(Player player) {
        if (player == null || !player.isOnline()) {
            return null;
        }
        ItemCostDiscount group = null;
        for (ItemCostDiscount discount : ItemCostDiscount.getArrangedGroups()) {
            if (PermissionUtils.noPermission(player, discount.getPermission(), EnumPermission.ITEM_COST_DISCOUNT.getPermission(), false)) continue;
            group = discount;
        }
        return group;
    }

    private String replacePlaceHolders(String arg0, int oldPrice) {
        String newString = arg0.replace("{COST}", String.valueOf(oldPrice));
        for (ItemCostDiscount group : ItemCostDiscount.getArrangedGroups()) {
            if (!newString.contains("COST}")) continue;
            newString = newString.replace("{" + group.getName().toUpperCase() + "_COST}", String.valueOf(group.getPriceAfterDiscount(oldPrice)));
        }
        return newString;
    }
}

