/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.GDisguise;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.GDisguiseType;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.BlazeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CreeperWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PigWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class LibDisguise
implements GDisguise {
    private static boolean showNameForDisguise = GadgetsMenu.getGadgetsMenuData().showNameForMobDisguise();

    @Override
    public boolean isDisguised(Player player) {
        return DisguiseAPI.isDisguised((Entity)player);
    }

    @Override
    public GDisguiseType getDisguise(Player player) {
        return GDisguiseType.valueOfLibDisguiseType(DisguiseAPI.getDisguise((Entity)player).getType());
    }

    @Override
    public boolean disguise(Player player, GDisguiseType type) {
        if (player == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        if (DisguiseAPI.isDisguised((Entity)player)) {
            DisguiseAPI.undisguiseToAll((Entity)player);
        }
        MobDisguise disguise = new MobDisguise(type.getLibDisguiseType());
        disguise.setModifyBoundingBox(false);
        LivingWatcher watcher = disguise.getWatcher();
        watcher.setCustomNameVisible(showNameForDisguise);
        if (showNameForDisguise) {
            watcher.setCustomName(player.getName());
        }
        if (GadgetsMenu.getPlayerManager(player).canSeeSelfMorph()) {
            disguise.setViewSelfDisguise(true);
            this.setViewDisguiseToggled(player, true);
        } else {
            disguise.setViewSelfDisguise(false);
            this.setViewDisguiseToggled(player, false);
        }
        if (type == GDisguiseType.BLAZE) {
            watcher = (BlazeWatcher)disguise.getWatcher();
            watcher.setBurning(true);
        } else if (type == GDisguiseType.CREEPER) {
            watcher = (CreeperWatcher)disguise.getWatcher();
            watcher.setPowered(true);
        } else if (type == GDisguiseType.PIG) {
            watcher = (PigWatcher)disguise.getWatcher();
            watcher.setSaddled(true);
        }
        DisguiseAPI.disguiseToAll((Entity)player, (Disguise)disguise);
        return true;
    }

    @Override
    public void setViewDisguiseToggled(Player player, boolean toggle) {
        DisguiseAPI.setViewDisguiseToggled((Entity)player, (boolean)toggle);
    }

    @Override
    public boolean disguiseCreeper(final Player player) {
        if (player == null) {
            return false;
        }
        MobDisguise disguise = new MobDisguise(DisguiseType.CREEPER);
        disguise.setModifyBoundingBox(false);
        LivingWatcher watcher = disguise.getWatcher();
        watcher.setCustomNameVisible(showNameForDisguise);
        if (showNameForDisguise) {
            watcher.setCustomName(player.getName());
        }
        if (GadgetsMenu.getPlayerManager(player).canSeeSelfMorph()) {
            disguise.setViewSelfDisguise(true);
            GadgetsMenu.getGDisguise().setViewDisguiseToggled(player, true);
        } else {
            disguise.setViewSelfDisguise(false);
            GadgetsMenu.getGDisguise().setViewDisguiseToggled(player, false);
        }
        DisguiseAPI.disguiseToAll((Entity)player, (Disguise)disguise);
        watcher = (CreeperWatcher)disguise.getWatcher();
        watcher.setIgnited(true);
        new BukkitRunnable((CreeperWatcher)watcher, disguise){
            final /* synthetic */ CreeperWatcher val$watcher;
            final /* synthetic */ MobDisguise val$disguise;
            {
                this.val$watcher = creeperWatcher;
                this.val$disguise = mobDisguise;
            }

            public void run() {
                if (!player.isOnline() || GadgetsMenu.getPlayerManager(player).getCurrentMorph() == null || GadgetsMenu.getPlayerManager(player).getCurrentMorph().getType() != MorphType.CREEPER) {
                    this.cancel();
                    return;
                }
                ParticleEffect.EXPLOSION_HUGE.display(player.getLocation());
                ParticleEffect.SMOKE_LARGE.display(player.getLocation());
                SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(player.getLocation());
                for (Player target : PlayerUtils.getNearbyPlayers(player.getLocation(), 3.0)) {
                    if (!(target instanceof Player) || target == player || target.hasMetadata("NPC")) continue;
                    MathUtil.applyVelocity((Entity)target, new Vector(target.getVelocity().getX(), 1.0, target.getVelocity().getZ()).add(MathUtil.getRandomCircleVector().multiply(0.7)));
                }
                if (GadgetsMenu.getGDisguise().getDisguise(player) == null) {
                    return;
                }
                if (GadgetsMenu.getGDisguise().getDisguise(player) != GDisguiseType.CREEPER) {
                    return;
                }
                this.val$watcher.setIgnited(false);
                this.val$watcher.setPowered(true);
                this.val$disguise.setModifyBoundingBox(false);
                LivingWatcher watcher = this.val$disguise.getWatcher();
                watcher.setCustomNameVisible(showNameForDisguise);
                if (showNameForDisguise) {
                    watcher.setCustomName(player.getName());
                }
                if (GadgetsMenu.getPlayerManager(player).canSeeSelfMorph()) {
                    this.val$disguise.setViewSelfDisguise(true);
                    GadgetsMenu.getGDisguise().setViewDisguiseToggled(player, true);
                } else {
                    this.val$disguise.setViewSelfDisguise(false);
                    GadgetsMenu.getGDisguise().setViewDisguiseToggled(player, false);
                }
                DisguiseAPI.disguiseToAll((Entity)player, (Disguise)this.val$disguise);
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 30L);
        return true;
    }

    @Override
    public boolean disguiseSheep(final Player player) {
        if (player == null) {
            return false;
        }
        SoundEffect.ENTITY_SHEEP_AMBIENT.playSound(player);
        final String[] colors = new String[]{"BLACK", "BLUE", "BROWN", "CYAN", "GRAY", "GREEN", "LIGHT_BLUE", "LIME", "MAGENTA", "ORANGE", "PINK", "PURPLE", "RED", "SILVER", "WHITE", "YELLOW"};
        MobDisguise disguise = new MobDisguise(DisguiseType.SHEEP);
        disguise.setModifyBoundingBox(false);
        LivingWatcher watcher = disguise.getWatcher();
        watcher.setCustomNameVisible(showNameForDisguise);
        if (showNameForDisguise) {
            watcher.setCustomName(player.getName());
        }
        if (GadgetsMenu.getPlayerManager(player).canSeeSelfMorph()) {
            disguise.setViewSelfDisguise(true);
            GadgetsMenu.getGDisguise().setViewDisguiseToggled(player, true);
        } else {
            disguise.setViewSelfDisguise(false);
            GadgetsMenu.getGDisguise().setViewDisguiseToggled(player, false);
        }
        DisguiseAPI.disguiseToAll((Entity)player, (Disguise)disguise);
        watcher = (SheepWatcher)disguise.getWatcher();
        BukkitRunnable runnable = new BukkitRunnable((SheepWatcher)watcher){
            int step = 0;
            final /* synthetic */ SheepWatcher val$watcher;
            {
                this.val$watcher = sheepWatcher;
            }

            public void run() {
                ++this.step;
                if (!player.isOnline() || GadgetsMenu.getPlayerManager(player).getCurrentMorph() == null || GadgetsMenu.getPlayerManager(player).getCurrentMorph().getType() != MorphType.SHEEP) {
                    this.step = 33;
                    this.cancel();
                    return;
                }
                if (this.step <= 32) {
                    AnimalColor color = AnimalColor.WHITE;
                    try {
                        color = AnimalColor.valueOf((String)colors[GadgetsMenu.random().nextInt(colors.length)]);
                    }
                    catch (IllegalArgumentException e) {
                        color = AnimalColor.LIGHT_GRAY;
                    }
                    this.val$watcher.setColor(color);
                } else {
                    this.val$watcher.setColor(AnimalColor.WHITE);
                    this.cancel();
                }
            }
        };
        runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 1L, 5L);
        return true;
    }

    @Override
    public boolean undisguise(Player player) {
        if (player == null) {
            return false;
        }
        DisguiseAPI.undisguiseToAll((Entity)player);
        return true;
    }
}

