/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PluginUtils {
    private static File jarFile = null;

    public static boolean reload(Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null.");
        PluginUtils.unload(plugin);
        return PluginUtils.load();
    }

    private static boolean load() {
        if (jarFile == null) {
            return false;
        }
        return PluginUtils.load(jarFile.getName());
    }

    public static boolean load(String name) {
        Plugin target = null;
        File pluginDir = new File("plugins");
        if (!pluginDir.isDirectory()) {
            return false;
        }
        File pluginFile = new File(pluginDir, name);
        if (!pluginFile.isFile()) {
            return false;
        }
        try {
            target = Bukkit.getPluginManager().loadPlugin(pluginFile);
        }
        catch (InvalidDescriptionException | InvalidPluginException e) {
            e.printStackTrace();
        }
        target.onLoad();
        Bukkit.getPluginManager().enablePlugin(target);
        return true;
    }

    public static void unload(Plugin plugin) {
        ClassLoader cl;
        boolean isPaperServer = VersionManager.isPaperServer();
        String name = plugin.getName();
        PluginManager pluginManager = Bukkit.getPluginManager();
        List plugins = null;
        Map names = null;
        Map listeners = null;
        SimpleCommandMap commandMap = null;
        Map commands = null;
        boolean reloadlisteners = true;
        if (pluginManager != null) {
            pluginManager.disablePlugin(plugin);
            try {
                Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                pluginsField.setAccessible(true);
                plugins = (List)pluginsField.get(pluginManager);
                Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                lookupNamesField.setAccessible(true);
                names = (Map)lookupNamesField.get(pluginManager);
                if (VersionManager.isVersionGreaterEqual(VersionManager.getMinecraftVersion(), "1.19.3") && isPaperServer) {
                    Object instance = ReflectionUtils.invokeMethod(null, Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl"), "getInstance", new Object[0]);
                    Object implField = ReflectionUtils.getValue(instance, instance.getClass(), true, "instanceManager");
                    Object fieldPlugins = ReflectionUtils.getValue(implField, Class.forName("io.papermc.paper.plugin.manager.PaperPluginInstanceManager"), true, "plugins");
                    Object fieldLookupNames = ReflectionUtils.getValue(implField, Class.forName("io.papermc.paper.plugin.manager.PaperPluginInstanceManager"), true, "lookupNames");
                    ((List)fieldPlugins).remove(plugin);
                    ((Map)fieldLookupNames).remove(name.toLowerCase(Locale.ROOT));
                }
                try {
                    Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                    listenersField.setAccessible(true);
                    listeners = (Map)listenersField.get(pluginManager);
                }
                catch (Exception e) {
                    reloadlisteners = false;
                }
                Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                commands = (Map)knownCommandsField.get(commandMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        pluginManager.disablePlugin(plugin);
        if (plugins != null && plugins.contains(plugin)) {
            plugins.remove(plugin);
        }
        if (names != null) {
            if (names.containsKey(name)) {
                names.remove(name);
            }
            if (names.containsKey(name.toLowerCase(Locale.ROOT))) {
                names.remove(name.toLowerCase(Locale.ROOT));
            }
        }
        if (listeners != null && reloadlisteners) {
            for (SortedSet set : listeners.values()) {
                set.removeIf(value -> value.getPlugin() == plugin);
            }
        }
        if (commandMap != null) {
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand c;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                c.unregister(commandMap);
                it.remove();
            }
        }
        if ((cl = plugin.getClass().getClassLoader()) instanceof URLClassLoader) {
            try {
                Field pluginField = cl.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                pluginField.set(cl, null);
                Field pluginInitField = cl.getClass().getDeclaredField("pluginInit");
                pluginInitField.setAccessible(true);
                pluginInitField.set(cl, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                ex.printStackTrace();
            }
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        System.gc();
    }

    static {
        try {
            jarFile = new File(((Object)((Object)GadgetsMenu.getInstance())).getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

