/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.util.INMSParticle;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.ServerVersion;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public enum ParticleEffect {
    SPELL_MOB_AMBIENT("SPELL_MOB_AMBIENT", 16, 8, "a", "AMBIENT_ENTITY_EFFECT", "a", "a", "a"),
    VILLAGER_ANGRY("VILLAGER_ANGRY", 20, 8, "b", "ANGRY_VILLAGER", "b", "b", "b"),
    BLOCK_CRACK("BLOCK_CRACK", 37, 8, "d", "BLOCK", "e", "c", "c"),
    BLOCK_DUST("BLOCK_DUST", 38, 8, "d", "BLOCK", "e", "c", "c"),
    BARRIER("BARRIER", 35, 8, "c", "BARRIER", "c", "d", "d"),
    WATER_BUBBLE("WATER_BUBBLE", 4, 8, "e", "BUBBLE", "f", "e", "e"),
    CLOUD("CLOUD", 29, 8, "g", "CLOUD", "g", "f", "f"),
    CRIT("CRIT", 9, 8, "h", "CRIT", "h", "g", "g"),
    DAMAGE_INDICATOR("DAMAGE_INDICATOR", 44, 9, "i", "DAMAGE_INDICATOR", "i", "h", "h"),
    DRAGON_BREATH("DRAGON_BREATH", 42, 9, "j", "DRAGON_BREATH", "j", "i", "i"),
    DRIP_LAVA("DRIP_LAVA", 19, 8, "k", "DRIPPING_LAVA", "k", "j", "j"),
    FALLING_LAVA("FALLING_LAVA", 14, "l", "k", "k"),
    LANDING_LAVA("LANDING_LAVA", 14, "m", "l", "l"),
    DRIP_WATER("DRIP_WATER", 18, 8, "l", "DRIPPING_WATER", "n", "m", "m"),
    FALLING_WATER("FALLING_WATER", 14, "o", "n", "n"),
    REDSTONE("REDSTONE", 30, 8, "m", "DUST", "p", "o", "o"),
    SPELL("SPELL", 13, 8, "n", "EFFECT", "r", "q", "q"),
    MOB_APPEARANCE("MOB_APPEARANCE", 41, 8, "o", "ELDER_GUARDIAN", "s", "r", "r"),
    CRIT_MAGIC("CRIT_MAGIC", 10, 8, "p", "ENCHANTED_HIT", "t", "s", "s"),
    ENCHANTMENT_TABLE("ENCHANTMENT_TABLE", 25, 8, "q", "ENCHANT", "u", "t", "t"),
    END_ROD("END_ROD", 43, 9, "r", "END_ROD", "v", "u", "u"),
    SPELL_MOB("SPELL_MOB", 15, 8, "s", "ENTITY_EFFECT", "w", "v", "v"),
    EXPLOSION_HUGE("EXPLOSION_HUGE", 2, 8, "t", "EXPLOSION_EMITTER", "x", "w", "w"),
    EXPLOSION_LARGE("EXPLOSION_LARGE", 1, 8, "u", "EXPLOSION", "y", "x", "x"),
    SONIC_BOOM("SONIC_BOOM", 19, "y"),
    FALLING_DUST("FALLING_DUST", 46, 10, "v", "FALLING_DUST", "z", "y", "z"),
    FIREWORKS_SPARK("FIREWORKS_SPARK", 3, 8, "w", "FIREWORK", "A", "z", "A"),
    WATER_WAKE("WATER_WAKE", 6, 8, "x", "FISHING", "B", "A", "B"),
    FLAME("FLAME", 26, 8, "y", "FLAME", "C", "B", "C"),
    CHERRY_LEAVES("CHERRY_LEAVES", 20),
    SCULK_SOUL("SCULK_SOUL", 19, "D"),
    SCULK_CHARGE("SCULK_CHARGE", 19, "E"),
    SCULK_CHARGE_POP("SCULK_CHARGE_POP", 19, "F"),
    SOUL_FIRE_FLAME("SOUL_FIRE_FLAME", 16, "D", "C", "G"),
    SOUL("SOUL", 16, "E", "D", "H"),
    FLASH("FLASH", 14, "F", "E", "I"),
    VILLAGER_HAPPY("VILLAGER_HAPPY", 21, 8, "z", "HAPPY_VILLAGER", "G", "F", "J"),
    COMPOSTER("COMPOSTER", 14, "H", "G", "K"),
    HEART("HEART", 34, 8, "A", "HEART", "I", "H", "L"),
    SPELL_INSTANT("SPELL_INSTANT", 14, 8, "B", "INSTANT_EFFECT", "J", "I", "M"),
    ITEM_CRACK("ITEM_CRACK", 36, 8, "C", "ITEM", "K", "J", "N"),
    SLIME("SLIME", 33, 8, "D", "ITEM_SLIME", "M", "L", "P"),
    SNOWBALL("SNOWBALL", 31, 8, "E", "ITEM_SNOWBALL", "N", "M", "Q"),
    SMOKE_LARGE("SMOKE_LARGE", 12, 8, "F", "LARGE_SMOKE", "O", "N", "R"),
    LAVA("LAVA", 27, 8, "G", "LAVA", "P", "O", "S"),
    TOWN_AURA("TOWN_AURA", 22, 8, "H", "MYCELIUM", "Q", "P", "T"),
    NOTE("NOTE", 23, 8, "I", "NOTE", "R", "Q", "U"),
    EXPLOSION_NORMAL("EXPLOSION_NORMAL", 0, 8, "J", "POOF", "S", "R", "V"),
    SNOW_SHOVEL("SNOW_SHOVEL", 32, 8, "J", "POOF", "S", "R", "V"),
    PORTAL("PORTAL", 24, 8, "K", "PORTAL", "T", "S", "W"),
    WATER_DROP("WATER_DROP", 39, 8, "L", "RAIN", "U", "T", "X"),
    SMOKE_NORMAL("SMOKE_NORMAL", 11, 8, "M", "SMOKE", "V", "U", "Y"),
    SNEEZE("SNEEZE", 14, "W", "V", "Z"),
    SPIT("SPIT", 48, 11, "N", "SPIT", "X", "W", "aa"),
    SQUID_INK("SQUID_INK", 13, "V", "SQUID_INK", "Y", "X", "ab"),
    SWEEP_ATTACK("SWEEP_ATTACK", 45, 9, "O", "SWEEP_ATTACK", "Z", "Y", "ac"),
    TOTEM("TOTEM", 47, 11, "P", "TOTEM_OF_UNDYING", "aa", "Z", "ad"),
    SUSPENDED("SUSPENDED", 7, 8, "Q", "UNDERWATER", "ab", "aa", "ae"),
    WATER_SPLASH("WATER_SPLASH", 5, 8, "R", "SPLASH", "ac", "ab", "af"),
    SPELL_WITCH("SPELL_WITCH", 17, 8, "S", "WITCH", "ad", "ac", "ag"),
    BUBBLE_POP("BUBBLE_POP", 13, "T", "BUBBLE_POP", "ae", "ad", "ah"),
    CURRENT_DOWN("CURRENT_DOWN", 13, "U", "CURRENT_DOWN", "af", "ae", "ai"),
    BUBBLE_COLUMN_UP("BUBBLE_COLUMN_UP", 13, "f", "BUBBLE_COLUMN_UP", "ag", "af", "aj"),
    NAUTILUS("NAUTILUS", 13, "W", "NAUTILUS", "ah", "ag", "ak"),
    DOLPHIN("DOLPHIN", 13, "X", "DOLPHIN", "ai", "ah", "al"),
    CAMPFIRE_COSY_SMOKE("CAMPFIRE_COSY_SMOKE", 14, "aj", "ai", "am"),
    CAMPFIRE_SIGNAL_SMOKE("CAMPFIRE_SIGNAL_SMOKE", 14, "ak", "aj", "an"),
    DRIPPING_HONEY("DRIPPING_HONEY", 15, "al", "ak", "ao"),
    FALLING_HONEY("FALLING_HONEY", 15, "am", "al", "ap"),
    LANDING_HONEY("LANDING_HONEY", 15, "an", "am", "aq"),
    FALLING_NECTAR("FALLING_NECTAR", 15, "ao", "an", "ar"),
    FALLING_SPORE_BLOSSOM("FALLING_SPORE_BLOSSOM", 17, "ap", "ao", "as"),
    ASH("ASH", 16, "aq", "ap", "at"),
    CRIMSON_SPORE("CRIMSON_SPORE", 16, "ar", "aq", "au"),
    WARPED_SPORE("WARPED_SPORE", 16, "as", "ar", "av"),
    SPORE_BLOSSOM_AIR("SPORE_BLOSSOM_AIR", 17, "at", "as", "aw"),
    DRIPPING_OBSIDIAN_TEAR("DRIPPING_OBSIDIAN_TEAR", 16, "au", "at", "ax"),
    FALLING_OBSIDIAN_TEAR("FALLING_OBSIDIAN_TEAR", 16, "av", "au", "ay"),
    LANDING_OBSIDIAN_TEAR("LANDING_OBSIDIAN_TEAR", 16, "aw", "av", "az"),
    REVERSE_PORTAL("REVERSE_PORTAL", 16, "ax", "aw", "aA"),
    WHITE_ASH("WHITE_ASH", 16, "ay", "ax", "aB"),
    SMALL_FLAME("SMALL_FLAME", 17, "az", "ay", "aC"),
    SNOWFLAKE("SNOWFLAKE", 17, "aA", "az", "aD"),
    DRIPPING_DRIPSTONE_LAVA("DRIPPING_DRIPSTONE_LAVA", 17, "aB", "aA", "aE"),
    FALLING_DRIPSTONE_LAVA("FALLING_DRIPSTONE_LAVA", 17, "aC", "aB", "aF"),
    DRIPPING_DRIPSTONE_WATER("DRIPPING_DRIPSTONE_WATER", 17, "aD", "aC", "aG"),
    FALLING_DRIPSTONE_WATER("FALLING_DRIPSTONE_WATER", 17, "aE", "aD", "aH"),
    GLOW_SQUID_INK("GLOW_SQUID_INK", 17, "aF", "aE", "aI"),
    GLOW("GLOW", 17, "aG", "aF", "aJ"),
    WAX_ON("WAX_ON", 17, "aH", "aG", "aK"),
    WAX_OFF("WAX_OFF", 17, "aI", "aH", "aL"),
    ELECTRIC_SPARK("ELECTRIC_SPARK", 17, "aI", "aJ", "aM"),
    SCRAPE("SCRAPE", 17, "aK", "aJ", "aN"),
    SHRIEK("SHRIEK", 19, "aO");

    private final String name;
    private final int id;
    private final int requiredVersion;
    private final String v1_13Name;
    private final String v1_14Name;
    private final String v1_17Name;
    private final String v1_18Name;
    private final String v1_19Name;
    private static final int maxRange = 128;

    private ParticleEffect(String name, int requiredVersion) {
        this(name, 0, requiredVersion, name, name, name, name, name);
    }

    private ParticleEffect(String name, int requiredVersion, String v1_19Name) {
        this(name, 0, requiredVersion, name, v1_19Name, v1_19Name, v1_19Name, v1_19Name);
    }

    private ParticleEffect(String name, int requiredVersion, String v1_17Name, String v1_18Name, String v1_19Name) {
        this(name, 0, requiredVersion, name, name, v1_17Name, v1_18Name, v1_19Name);
    }

    private ParticleEffect(String name, int requiredVersion, String v1_13Name, String v1_14Name, String v1_17Name, String v1_18Name, String v1_19Name) {
        this(name, 0, requiredVersion, v1_13Name, v1_14Name, v1_17Name, v1_18Name, v1_19Name);
    }

    private ParticleEffect(String name, int id, int requiredVersion, String v1_13Name, String v1_14Name, String v1_17Name, String v1_18Name, String v1_19Name) {
        this.name = name;
        this.id = id;
        this.requiredVersion = requiredVersion;
        this.v1_13Name = v1_13Name;
        this.v1_14Name = v1_14Name;
        this.v1_17Name = v1_17Name;
        this.v1_18Name = v1_18Name;
        this.v1_19Name = v1_19Name;
    }

    public String getName() {
        return this.name;
    }

    public String getV1_13Name() {
        return this.v1_13Name;
    }

    public String getV1_14Name() {
        return this.v1_14Name;
    }

    public String getV1_17Name() {
        return this.v1_17Name;
    }

    public String getV1_18Name() {
        return this.v1_18Name;
    }

    public String getV1_19Name() {
        return this.v1_19Name;
    }

    public int getId() {
        return this.id;
    }

    public int getRequiredVersion() {
        return this.requiredVersion;
    }

    public boolean isVersionSupported() {
        return ServerVersion.getServerVersion().getCurrentVersionNumber() >= this.getRequiredVersion();
    }

    public void display(Location location) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, 1, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, boolean hideForVanishedPlayer, Player player) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, 1, true, null).sendTo(location, hideForVanishedPlayer, player);
    }

    public void display(Location location, Player player) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, 1, true, null).sendTo(location, player);
    }

    public void display(Location location, float speed) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, 1, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, Player player, float speed) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, 1, true, null).sendTo(location, player);
    }

    public void display(Location location, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, amount, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, Player player, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, amount, true, null).sendTo(location, player);
    }

    public void display(Location location, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, amount, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, boolean hideForVanishedPlayer, Player player, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, amount, true, null).sendTo(location, hideForVanishedPlayer, player);
    }

    public void display(Location location, Player player, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, amount, true, null).sendTo(location, player);
    }

    public void display(Location location, float offsetX, float offsetY, float offsetZ) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, 1, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, Player player, float offsetX, float offsetY, float offsetZ) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, 1, true, null).sendTo(location, player);
    }

    public void display(Location location, float offsetX, float offsetY, float offsetZ, float speed) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, 1, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, Player player, float offsetX, float offsetY, float offsetZ, float speed) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, 1, true, null).sendTo(location, player);
    }

    public void display(Location location, float offsetX, float offsetY, float offsetZ, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, amount, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, Player player, float offsetX, float offsetY, float offsetZ, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, amount, true, null).sendTo(location, player);
    }

    public void display(Location location, boolean hideForVanishedPlayer, Player player, float offsetX, float offsetY, float offsetZ, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, amount, true, null).sendTo(location, hideForVanishedPlayer, player);
    }

    public void display(Location location, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, null).sendTo(location, 128.0);
    }

    public void display(Location location, Player player, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, null).sendTo(location, player);
    }

    public void display(Location location, boolean hideForVanishedPlayer, Player player, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, null).sendTo(location, hideForVanishedPlayer, player);
    }

    public void displayRandomColor(Location location) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, new OrdinaryColor(MathUtil.randomInt(1, 255), MathUtil.randomInt(1, 255), MathUtil.randomInt(1, 255), 1.0f), true).sendTo(location, 128.0);
    }

    public void displayColor(Location location, int red, int green, int blue) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, new OrdinaryColor(red, green, blue, 1.0f), true).sendTo(location, 128.0);
    }

    public void displayColor(Location location, Player player, int red, int green, int blue) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, new OrdinaryColor(red, green, blue, 1.0f), true).sendTo(location, player);
    }

    public void displayColor(Location location, boolean hideForVanishedPlayer, Player player, int red, int green, int blue) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, new OrdinaryColor(red, green, blue, 1.0f), true).sendTo(location, hideForVanishedPlayer, player);
    }

    public void display(ItemData data, Location location, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, data).sendTo(location, 128.0);
    }

    public void display(ItemData data, Location location, float offsetX, float offsetY, float offsetZ) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, 1, true, data).sendTo(location, 128.0);
    }

    public void display(ItemData data, Location location, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, amount, true, data).sendTo(location, 128.0);
    }

    public void display(ItemData data, Location location, float speed) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, 1, true, data).sendTo(location, 128.0);
    }

    public void display(ItemData data, Location location, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, amount, true, data).sendTo(location, 128.0);
    }

    public void display(BlockData data, Location location, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, true, data).sendTo(location, 128.0);
    }

    public void display(BlockData data, Location location, float offsetX, float offsetY, float offsetZ) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, 0.0f, 1, true, data).sendTo(location, 128.0);
    }

    public void display(BlockData data, Location location, float speed, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, amount, true, data).sendTo(location, 128.0);
    }

    public void display(BlockData data, Location location, float speed) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, speed, 1, true, data).sendTo(location, 128.0);
    }

    public void display(BlockData data, Location location, int amount) {
        if (this.isUnSupported()) {
            return;
        }
        new ParticlePacket(this, 0.0f, 0.0f, 0.0f, 0.0f, amount, true, data).sendTo(location, 128.0);
    }

    private boolean isUnSupported() {
        if (!this.isVersionSupported()) {
            LoggerManager.printLogWithHeader(LoggerManager.LogLevel.WARNING, "------------------------------------------------------", MessageType.PARTICLE_EFFECT_NOT_SUPPORTED.getFormatMessage().replace("{PARTICLE}", this.name));
            GadgetsMenu.getGPlayer().unequipParticle();
            return true;
        }
        return false;
    }

    public static final class ParticlePacket {
        private static int version;
        private static Class<?> enumParticle;
        private static Class<?> nmsPacketPlayOutParticles;
        private static Constructor<?> packetConstructor;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static boolean initialized;
        private final ParticleEffect effect;
        private float offsetX;
        private final float offsetY;
        private final float offsetZ;
        private float size = 1.0f;
        private float speed;
        private int amount;
        private final boolean longDistance;
        private final ParticleData data;
        private Object packet;
        private INMSParticle nmsParticle;

        public ParticlePacket(ParticleEffect effect, float offsetX, float offsetY, float offsetZ, float speed, int amount, boolean longDistance, ParticleData data) throws IllegalArgumentException {
            ParticlePacket.initialize();
            this.effect = effect;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.speed = speed;
            this.amount = amount;
            this.longDistance = longDistance;
            this.data = data;
            if (speed < 0.0f) {
                this.speed = 0.0f;
                throw new IllegalArgumentException("The speed is lower than 0");
            }
            if (amount < 0) {
                this.amount = 1;
                throw new IllegalArgumentException("The amount is lower than 0");
            }
            this.nmsParticle = GadgetsMenu.getNMSManager().getNMSParticle();
        }

        public ParticlePacket(ParticleEffect effect, Vector direction, float speed, boolean longDistance, ParticleData data) throws IllegalArgumentException {
            this(effect, (float)direction.getX(), (float)direction.getY(), (float)direction.getZ(), speed, 0, longDistance, data);
        }

        public ParticlePacket(ParticleEffect effect, ParticleColor color, boolean longDistance) {
            this(effect, color.getValueX(), color.getValueY(), color.getValueZ(), 1.0f, 0, longDistance, null);
            this.size = color.getValueSize();
            if (effect == REDSTONE && color instanceof OrdinaryColor && ((OrdinaryColor)color).getRed() == 0) {
                this.offsetX = Float.MIN_NORMAL;
            }
        }

        public static void initialize() throws VersionIncompatibleException {
            if (initialized) {
                return;
            }
            try {
                version = Integer.parseInt(ReflectionUtils.PackageType.getServerVersion().split("\\_")[1]);
                if (version > 7) {
                    enumParticle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass(VersionManager.is1_13OrAbove() ? "Particles" : "EnumParticle", "core.particles");
                }
                nmsPacketPlayOutParticles = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("PacketPlayOutWorldParticles", "network.protocol.game");
                packetConstructor = VersionManager.is1_17OrAbove() ? ReflectionUtils.getConstructor(nmsPacketPlayOutParticles, ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("PacketDataSerializer", "network")) : ReflectionUtils.getConstructor(nmsPacketPlayOutParticles, new Class[0]);
                getHandle = ReflectionUtils.getMethod("CraftPlayer", ReflectionUtils.AdvancedPackageType.fromPath(ReflectionUtils.PackageType.CRAFTBUKKIT_ENTITY), "getHandle", new Class[0]);
                playerConnection = VersionManager.is1_20OrAbove() ? ReflectionUtils.getField("EntityPlayer", ReflectionUtils.AdvancedPackageType.fromPath(ReflectionUtils.PackageType.MINECRAFT_SERVER, "server.level"), false, "c") : (VersionManager.is1_17OrAbove() ? ReflectionUtils.getField("EntityPlayer", ReflectionUtils.AdvancedPackageType.fromPath(ReflectionUtils.PackageType.MINECRAFT_SERVER, "server.level"), false, "b") : ReflectionUtils.getField("EntityPlayer", ReflectionUtils.AdvancedPackageType.fromPath(ReflectionUtils.PackageType.MINECRAFT_SERVER), false, "playerConnection"));
                sendPacket = VersionManager.is1_18OrAbove() ? ReflectionUtils.getMethod(playerConnection.getType(), "a", ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Packet", "network.protocol")) : ReflectionUtils.getMethod(playerConnection.getType(), "sendPacket", ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Packet", "network.protocol"));
            }
            catch (Exception exception) {
                throw new VersionIncompatibleException("Your current bukkit version seems to be incompatible with this library", exception);
            }
            initialized = true;
        }

        public static int getVersion() {
            if (!initialized) {
                ParticlePacket.initialize();
            }
            return version;
        }

        public static boolean isInitialized() {
            return initialized;
        }

        private void initializePacket(Location center) throws PacketInstantiationException {
            if (this.packet != null) {
                return;
            }
            try {
                if (VersionManager.is1_13OrAbove()) {
                    String effectName = this.effect.getV1_13Name();
                    if (VersionManager.is1_19OrAbove()) {
                        effectName = this.nmsParticle != null ? this.nmsParticle.getParticleMappingList().get((Object)this.effect) : this.effect.getV1_19Name();
                    } else if (VersionManager.is1_18OrAbove()) {
                        effectName = this.effect.getV1_18Name();
                    } else if (VersionManager.is1_17OrAbove()) {
                        effectName = this.effect.getV1_17Name();
                    } else if (VersionManager.is1_14OrAbove()) {
                        effectName = this.effect.getV1_14Name();
                    }
                    Object particle = enumParticle.getField(effectName).get(effectName);
                    if (this.effect == REDSTONE) {
                        particle = VersionManager.is1_19_R2Version() || VersionManager.is1_19_R3Version() || VersionManager.is1_20OrAbove() ? (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f ? ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone", "core.particles").getConstructor(Vector3f.class, Float.TYPE).newInstance(new Vector3f(this.offsetX, this.offsetY, this.offsetZ), Float.valueOf(this.size)) : ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone", "core.particles").getConstructor(Vector3f.class, Float.TYPE).newInstance(new Vector3f(MathUtil.randomFloat(0.3137f, 1.0f), MathUtil.randomFloat(0.3137f, 1.0f), MathUtil.randomFloat(0.3137f, 1.0f)), Float.valueOf(this.size))) : (VersionManager.is1_17OrAbove() ? (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f ? ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone", "core.particles").getConstructor(Class.forName("com.mojang.math.Vector3fa"), Float.TYPE).newInstance(ReflectionUtils.getConstructor(Class.forName("com.mojang.math.Vector3fa"), Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(this.offsetX), Float.valueOf(this.offsetY), Float.valueOf(this.offsetZ)), Float.valueOf(this.size)) : ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone", "core.particles").getConstructor(Class.forName("com.mojang.math.Vector3fa"), Float.TYPE).newInstance(ReflectionUtils.getConstructor(Class.forName("com.mojang.math.Vector3fa"), Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(MathUtil.randomFloat(0.3137f, 1.0f)), Float.valueOf(MathUtil.randomFloat(0.3137f, 1.0f)), Float.valueOf(MathUtil.randomFloat(0.3137f, 1.0f))), Float.valueOf(this.size))) : (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f ? ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone", new String[0]).getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(this.offsetX), Float.valueOf(this.offsetY), Float.valueOf(this.offsetZ), Float.valueOf(this.size)) : ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamRedstone", new String[0]).getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(MathUtil.randomFloat(0.3137f, 1.0f)), Float.valueOf(MathUtil.randomFloat(0.3137f, 1.0f)), Float.valueOf(MathUtil.randomFloat(0.3137f, 1.0f)), Float.valueOf(this.size))));
                    } else if (this.effect == BLOCK_CRACK || this.effect == BLOCK_DUST || this.effect == FALLING_DUST || VersionManager.is1_18OrAbove() && this.effect == BARRIER) {
                        Object blockHandle;
                        ParticleData newData = this.data;
                        if (newData == null) {
                            newData = this.effect == BARRIER ? new BlockData(EnumMaterial.BARRIER, 0) : new BlockData(EnumMaterial.GRASS_BLOCK, 0);
                        }
                        if (VersionManager.is1_17OrAbove()) {
                            Class<?> craftMagicNumbersClass = ReflectionUtils.PackageType.CRAFTBUKKIT.getClass("util.CraftMagicNumbers", new String[0]);
                            Class<?> blockClass = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Block", "world.level.block");
                            Object iblockData = craftMagicNumbersClass.getDeclaredMethod("getBlock", Material.class).invoke(craftMagicNumbersClass, newData.getMaterial().getType());
                            blockHandle = VersionManager.is1_20OrAbove() ? blockClass.getDeclaredMethod("n", new Class[0]).invoke(iblockData, new Object[0]) : (VersionManager.is1_19_R3Version() ? blockClass.getDeclaredMethod("o", new Class[0]).invoke(iblockData, new Object[0]) : (VersionManager.is1_19_R2Version() ? blockClass.getDeclaredMethod("n", new Class[0]).invoke(iblockData, new Object[0]) : (VersionManager.is1_19OrAbove() ? blockClass.getDeclaredMethod("m", new Class[0]).invoke(iblockData, new Object[0]) : (VersionManager.is1_18OrAbove() ? blockClass.getDeclaredMethod("n", new Class[0]).invoke(iblockData, new Object[0]) : blockClass.getDeclaredMethod("getBlockData", new Class[0]).invoke(iblockData, new Object[0])))));
                        } else {
                            Class<?> blockStateClass = ReflectionUtils.PackageType.CRAFTBUKKIT.getClass("block.CraftBlockState", new String[0]);
                            Object material = blockStateClass.getConstructor(Material.class).newInstance(newData.getMaterial().getType());
                            blockStateClass.getDeclaredMethod("setRawData", Byte.TYPE).invoke(material, (byte)10);
                            blockHandle = blockStateClass.getDeclaredMethod("getHandle", new Class[0]).invoke(material, new Object[0]);
                        }
                        particle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamBlock", "core.particles").getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Particle", "core.particles"), ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("IBlockData", "world.level.block.state")).newInstance(particle, blockHandle);
                    } else if (this.effect == ITEM_CRACK) {
                        Object itemStack = ReflectionUtils.PackageType.CRAFTBUKKIT.getClass("inventory.CraftItemStack", new String[0]).getDeclaredMethod("asCraftCopy", ItemStack.class).invoke(null, new ItemStack(this.data == null ? EnumMaterial.GRASS_BLOCK.getType() : this.data.getMaterial().getType()));
                        Object nmsItemStack = ReflectionUtils.PackageType.CRAFTBUKKIT.getClass("inventory.CraftItemStack", new String[0]).getDeclaredMethod("asNMSCopy", ItemStack.class).invoke(null, itemStack);
                        particle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParamItem", "core.particles").getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Particle", "core.particles"), ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ItemStack", "world.item")).newInstance(particle, nmsItemStack);
                    } else if (this.effect == SCULK_CHARGE) {
                        particle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("SculkChargeParticleOptions", "core.particles").getConstructor(Float.TYPE).newInstance(0);
                    } else if (this.effect == SHRIEK) {
                        particle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ShriekParticleOption", "core.particles").getConstructor(Integer.TYPE).newInstance(3);
                    }
                    this.packet = VersionManager.is1_15OrAbove() ? nmsPacketPlayOutParticles.getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParam", "core.particles"), Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE).newInstance(particle, true, center.getX(), center.getY(), center.getZ(), Float.valueOf(this.offsetX), Float.valueOf(this.offsetY), Float.valueOf(this.offsetZ), Float.valueOf(this.speed), this.amount) : nmsPacketPlayOutParticles.getConstructor(ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ParticleParam", new String[0]), Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE).newInstance(particle, true, Float.valueOf((float)center.getX()), Float.valueOf((float)center.getY()), Float.valueOf((float)center.getZ()), Float.valueOf(this.offsetX), Float.valueOf(this.offsetY), Float.valueOf(this.offsetZ), Float.valueOf(this.speed), this.amount);
                } else {
                    ParticleData newData = this.data;
                    if ((this.effect == BLOCK_CRACK || this.effect == BLOCK_DUST || this.effect == FALLING_DUST || this.effect == ITEM_CRACK) && newData == null) {
                        newData = new BlockData(EnumMaterial.GRASS_BLOCK, 0);
                    }
                    this.packet = packetConstructor.newInstance(new Object[0]);
                    ReflectionUtils.setValue(this.packet, true, "a", enumParticle.getEnumConstants()[this.effect.getId()]);
                    ReflectionUtils.setValue(this.packet, true, "j", this.longDistance);
                    if (newData != null) {
                        int[] nArray;
                        int[] packetData = newData.getPacketData();
                        if (this.effect == ITEM_CRACK) {
                            nArray = packetData;
                        } else {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = packetData[0] | packetData[1] << 12;
                        }
                        ReflectionUtils.setValue(this.packet, true, "k", nArray);
                    }
                    ReflectionUtils.setValue(this.packet, true, "b", Float.valueOf((float)center.getX()));
                    ReflectionUtils.setValue(this.packet, true, "c", Float.valueOf((float)center.getY()));
                    ReflectionUtils.setValue(this.packet, true, "d", Float.valueOf((float)center.getZ()));
                    ReflectionUtils.setValue(this.packet, true, "e", Float.valueOf(this.offsetX));
                    ReflectionUtils.setValue(this.packet, true, "f", Float.valueOf(this.offsetY));
                    ReflectionUtils.setValue(this.packet, true, "g", Float.valueOf(this.offsetZ));
                    ReflectionUtils.setValue(this.packet, true, "h", Float.valueOf(this.speed));
                    ReflectionUtils.setValue(this.packet, true, "i", this.amount);
                }
            }
            catch (Exception exception) {
                throw new PacketInstantiationException("Packet instantiation failed", exception);
            }
        }

        public void sendTo(Location center, Player player) throws PacketInstantiationException, PacketSendingException {
            Validate.notNull((Object)center, (String)"Location cannot be null.");
            Validate.notNull((Object)player, (String)"Player cannot be null.");
            if (center.getWorld() != player.getWorld()) {
                return;
            }
            this.initializePacket(center);
            try {
                sendPacket.invoke(playerConnection.get(getHandle.invoke((Object)player, new Object[0])), this.packet);
            }
            catch (Exception exception) {
                throw new PacketSendingException("Failed to send the packet to player '" + player.getName() + "'", exception);
            }
        }

        public void sendTo(Location center, boolean hideForVanishedPlayer, Player targetPlayer) throws IllegalArgumentException {
            Validate.notNull((Object)targetPlayer, (String)"Player cannot be null.");
            if (hideForVanishedPlayer) {
                double squared = 16384.0;
                for (Player viewer : Bukkit.getOnlinePlayers()) {
                    if (viewer.getWorld() != center.getWorld() || viewer.getLocation().distanceSquared(center) > squared || (!viewer.canSee(targetPlayer) || targetPlayer.getGameMode() == GameMode.SPECTATOR) && viewer != targetPlayer) continue;
                    this.sendTo(center, viewer);
                }
            } else {
                this.sendTo(center, 128.0);
            }
        }

        public void sendTo(Location center, List<Player> players) throws IllegalArgumentException {
            if (players.isEmpty()) {
                throw new IllegalArgumentException("The player list is empty");
            }
            for (Player player : players) {
                this.sendTo(center, player);
            }
        }

        public void sendTo(Location center, double range) throws IllegalArgumentException {
            if (range < 1.0) {
                throw new IllegalArgumentException("The range is lower than 1");
            }
            String worldName = center.getWorld().getName();
            double squared = range * range;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(center) > squared) continue;
                this.sendTo(center, player);
            }
        }

        private static final class VersionIncompatibleException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public VersionIncompatibleException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static final class PacketInstantiationException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketInstantiationException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static final class PacketSendingException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketSendingException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    public static abstract class ParticleData {
        private final EnumMaterial material;
        private final byte data;
        private final int[] packetData;

        public ParticleData(EnumMaterial material, byte data) {
            this.material = material;
            this.data = data;
            this.packetData = new int[]{material.getTypeId(), data};
        }

        public EnumMaterial getMaterial() {
            return this.material;
        }

        public byte getData() {
            return this.data;
        }

        public int[] getPacketData() {
            return this.packetData;
        }

        public String getPacketDataString() {
            return "_" + this.packetData[0] + "_" + this.packetData[1];
        }
    }

    public static final class OrdinaryColor
    extends ParticleColor {
        private final int red;
        private final int green;
        private final int blue;
        private final float size;

        public OrdinaryColor(int red, int green, int blue, float size) throws IllegalArgumentException {
            if (red < 0) {
                throw new IllegalArgumentException("The red is lower than 0");
            }
            if (red > 255) {
                throw new IllegalArgumentException("The red is higher than 255");
            }
            this.red = red;
            if (green < 0) {
                throw new IllegalArgumentException("The green is lower than 0");
            }
            if (green > 255) {
                throw new IllegalArgumentException("The green is higher than 255");
            }
            this.green = green;
            if (blue < 0) {
                throw new IllegalArgumentException("The blue is lower than 0");
            }
            if (blue > 255) {
                throw new IllegalArgumentException("The blue is higher than 255");
            }
            this.blue = blue;
            if (size < 0.0f) {
                throw new IllegalArgumentException("The size is lower than 0");
            }
            if (size > 4.0f) {
                throw new IllegalArgumentException("The size is higher than 4");
            }
            this.size = size;
        }

        public OrdinaryColor(Color color, float size) {
            this(color.getRed(), color.getGreen(), color.getBlue(), size);
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        public float getSize() {
            return this.size;
        }

        @Override
        public float getValueX() {
            return (float)this.red / 255.0f;
        }

        @Override
        public float getValueY() {
            return (float)this.green / 255.0f;
        }

        @Override
        public float getValueZ() {
            return (float)this.blue / 255.0f;
        }

        @Override
        public float getValueSize() {
            return this.size;
        }
    }

    public static abstract class ParticleColor {
        public abstract float getValueX();

        public abstract float getValueY();

        public abstract float getValueZ();

        public abstract float getValueSize();
    }

    public static final class NoteColor
    extends ParticleColor {
        private final int note;

        public NoteColor(int note) throws IllegalArgumentException {
            if (note < 0) {
                throw new IllegalArgumentException("The note is lower than 0");
            }
            if (note > 24) {
                throw new IllegalArgumentException("The note is higher than 24");
            }
            this.note = note;
        }

        @Override
        public float getValueX() {
            return (float)this.note / 24.0f;
        }

        @Override
        public float getValueY() {
            return 0.0f;
        }

        @Override
        public float getValueZ() {
            return 0.0f;
        }

        @Override
        public float getValueSize() {
            return 1.0f;
        }
    }

    public static final class BlockData
    extends ParticleData {
        public BlockData(EnumMaterial material, byte data) throws IllegalArgumentException {
            super(material, data);
            if (!material.getType().isBlock()) {
                throw new IllegalArgumentException("The material is not a block");
            }
        }
    }

    public static final class ItemData
    extends ParticleData {
        public ItemData(EnumMaterial material, byte data) {
            super(material, data);
        }
    }
}

