/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public class ChatUtil {
    private static final char COLOR_CHAR = '\u00a7';
    private static final String[] colors = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e"};
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)" + String.valueOf('&') + "[0-9A-FK-ORX]");
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("[{](#[0-9A-Fa-f]{6}+)[}]");
    private static Random random = new Random();

    public static String format(String arg0) {
        if (arg0 == null) {
            return null;
        }
        if (GadgetsMenu.getGadgetsMenuData() != null && GadgetsMenu.getGadgetsMenuData().getPrefix() != null) {
            arg0 = arg0.replace("{PREFIX}", GadgetsMenu.getGadgetsMenuData().getPrefix());
        }
        if (VersionManager.is1_16OrAbove() && HEX_COLOR_PATTERN.matcher(arg0).find()) {
            String colorPattern = null;
            String strColored = null;
            Matcher m = HEX_COLOR_PATTERN.matcher(arg0);
            while (m.find()) {
                colorPattern = m.group();
                StringBuilder magic = new StringBuilder("\u00a7x");
                for (char c : colorPattern.substring(2, m.group().length() - 1).toUpperCase().toCharArray()) {
                    magic.append('\u00a7').append(c);
                }
                strColored = magic.toString();
                arg0 = arg0.replace(colorPattern, strColored);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)arg0);
    }

    public static List<String> format(List<String> arg0) {
        if (arg0 == null) {
            return null;
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (String msg : arg0) {
            messages.add(ChatUtil.format(msg));
        }
        return messages;
    }

    public static String randomColor(String arg0) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + colors[random.nextInt(colors.length)] + arg0));
    }

    public static String getRandomColor() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + colors[random.nextInt(colors.length)]));
    }

    public static String stripColor(String arg0) {
        String newString = arg0;
        newString = ChatUtil.stripColorFormat(newString);
        if (VersionManager.is1_16OrAbove()) {
            newString = HEX_COLOR_PATTERN.matcher(newString).replaceAll("");
        }
        if (GadgetsMenu.getGadgetsMenuData() != null && GadgetsMenu.getGadgetsMenuData().getPrefix() != null) {
            newString = newString.replace("{PREFIX}", GadgetsMenu.getGadgetsMenuData().getPrefix());
        }
        return ChatColor.stripColor((String)newString);
    }

    private static String stripColorFormat(String string) {
        return STRIP_COLOR_PATTERN.matcher(string).replaceAll("");
    }
}

