/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.utils;

import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;

public class BlockUtil {
    private static final Set<Material> transparentBlocks = new HashSet<Material>(Arrays.asList(EnumMaterial.AIR.getType(), EnumMaterial.GRASS.getType(), EnumMaterial.TALL_GRASS.getType()));

    public static List<Block> getBlocksInRadius(Location location, int radius, boolean hollow) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int bX = location.getBlockX();
        int bY = location.getBlockY();
        int bZ = location.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - radius; y <= bY + radius; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    Location l;
                    double distance = (bX - x) * (bX - x) + (bY - y) * (bY - y) + (bZ - z) * (bZ - z);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || (l = new Location(location.getWorld(), (double)x, (double)y, (double)z)).getBlock().getType() == Material.BARRIER) continue;
                    blocks.add(l.getBlock());
                }
            }
        }
        return blocks;
    }

    public static List<Block> getBlocksInRadiusXZ(Location location, int radius, boolean hollow) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int bX = location.getBlockX();
        int bY = location.getBlockY();
        int bZ = location.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - 1; y <= bY; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    Location l;
                    double distance = (bX - x) * (bX - x) + (bY - y) * (bY - y) + (bZ - z) * (bZ - z);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || (l = new Location(location.getWorld(), (double)x, (double)y, (double)z)).getBlock().getType() == Material.BARRIER) continue;
                    blocks.add(l.getBlock());
                }
            }
        }
        return blocks;
    }

    public static List<Block> getSquareBlocks(Location location, int radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int minX = location.getBlockX() - radius / 2;
        int minY = location.getBlockY() - radius / 2;
        int minZ = location.getBlockZ() - radius / 2;
        for (int x = minX; x < minX + radius; ++x) {
            for (int y = minY; y < minY + radius; ++y) {
                for (int z = minZ; z < minZ + radius; ++z) {
                    blocks.add(location.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static List<Location> getLocationsInRadius(Location location, int radius, boolean hollow) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int bX = location.getBlockX();
        int bY = location.getBlockY();
        int bZ = location.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - radius; y <= bY + radius; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    double distance = (bX - x) * (bX - x) + (bY - y) * (bY - y) + (bZ - z) * (bZ - z);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1))) continue;
                    Location l = new Location(location.getWorld(), (double)x, (double)y, (double)z);
                    locations.add(l.getBlock().getLocation());
                }
            }
        }
        return locations;
    }

    public static Block getTargetBlock(Player player, int range) {
        try {
            return player.getTargetBlock((Set)null, range);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static boolean isOnGround(Entity entity) {
        Block block = entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
        return block.getType().isSolid();
    }

    public static double getDistance(int x1, int z1, int x2, int z2) {
        int dx = x1 - x2;
        int dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static boolean hasBlockObject(Block b) {
        return b.getType() == EnumMaterial.ALLIUM.getType() || b.getType() == EnumMaterial.AZURE_BLUET.getType() || b.getType() == EnumMaterial.ATTACHED_MELON_STEM.getType() || b.getType() == EnumMaterial.ATTACHED_PUMPKIN_STEM.getType() || b.getType().toString().toLowerCase().contains("bed") || b.getType() == EnumMaterial.BAMBOO.getType() || b.getType() == EnumMaterial.BEETROOTS.getType() || b.getType() == EnumMaterial.BIG_DRIPLEAF.getType() || b.getType() == EnumMaterial.BIG_DRIPLEAF_STEM.getType() || b.getType() == EnumMaterial.BLUE_ORCHID.getType() || b.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || b.getType() == EnumMaterial.CACTUS.getType() || b.getType() == EnumMaterial.CAKE.getType() || b.getType().toString().toLowerCase().contains("cake_block") || b.getType() == EnumMaterial.CARROTS.getType() || b.getType() == EnumMaterial.COCOA.getType() || b.getType() == EnumMaterial.CORNFLOWER.getType() || b.getType().toString().toLowerCase().contains("crops") || b.getType() == EnumMaterial.DANDELION.getType() || b.getType() == EnumMaterial.DEAD_BUSH.getType() || b.getType().toString().toLowerCase().contains("double_plant") || b.getType() == EnumMaterial.FERN.getType() || b.getType() == EnumMaterial.FIRE.getType() || b.getType() == EnumMaterial.FLOWER_POT.getType() || b.getType() == EnumMaterial.GRASS.getType() || b.getType() == EnumMaterial.LARGE_FERN.getType() || b.getType() == EnumMaterial.LILAC.getType() || b.getType() == EnumMaterial.LILY_PAD.getType() || b.getType() == EnumMaterial.LILY_OF_THE_VALLEY.getType() || b.getType().toString().toLowerCase().contains("long_grass") || b.getType() == EnumMaterial.MELON_STEM.getType() || b.getType() == EnumMaterial.MUSHROOM_STEM.getType() || b.getType() == EnumMaterial.NETHER_WART.getType() || b.getType() == EnumMaterial.OXEYE_DAISY.getType() || b.getType() == EnumMaterial.PEONY.getType() || b.getType() == EnumMaterial.POPPY.getType() || b.getType() == EnumMaterial.POTATOES.getType() || b.getType() == EnumMaterial.PUMPKIN_STEM.getType() || b.getType() == EnumMaterial.REDSTONE_WIRE.getType() || b.getType().toString().toLowerCase().contains("redstone_torch") || b.getType() == EnumMaterial.RED_BED.getType() || b.getType() == EnumMaterial.RED_MUSHROOM.getType() || b.getType().toString().toLowerCase().contains("red_rose") || b.getType() == EnumMaterial.ROSE_BUSH.getType() || b.getType().toString().toLowerCase().contains("sapling") || b.getType() == EnumMaterial.SEAGRASS.getType() || b.getType().toString().toLowerCase().contains("seeds") || b.getType() == EnumMaterial.SMALL_DRIPLEAF.getType() || b.getType() == EnumMaterial.SNOW.getType() || b.getType() == EnumMaterial.SUGAR_CANE.getType() || b.getType().toString().toLowerCase().contains("sugar_cane_block") || b.getType() == EnumMaterial.SUNFLOWER.getType() || b.getType() == EnumMaterial.SWEET_BERRY_BUSH.getType() || b.getType() == EnumMaterial.TALL_GRASS.getType() || b.getType() == EnumMaterial.TALL_SEAGRASS.getType() || b.getType() == EnumMaterial.TORCH.getType() || b.getType().toString().toLowerCase().contains("tulip") || b.getType() == EnumMaterial.WHEAT.getType() || b.getType() == EnumMaterial.WITHER_ROSE.getType();
    }

    public static BlockFace getBlockFace(int facing) {
        if (facing == 0) {
            return BlockFace.EAST;
        }
        if (facing == 1 || facing == 4) {
            return BlockFace.WEST;
        }
        if (facing == 2 || facing == 5) {
            return BlockFace.SOUTH;
        }
        if (facing == 3) {
            return BlockFace.NORTH;
        }
        return BlockFace.EAST;
    }

    private static BlockFace getBlockFace(Block targetBlock, Block oppositeBlock) {
        for (BlockFace bf : BlockFace.values()) {
            if (!targetBlock.getRelative(bf).getLocation().equals((Object)oppositeBlock.getLocation())) continue;
            if (bf.getOppositeFace() != BlockFace.EAST && bf.getOppositeFace() != BlockFace.SOUTH && bf.getOppositeFace() != BlockFace.WEST && bf.getOppositeFace() != BlockFace.NORTH) {
                return BlockFace.EAST;
            }
            return bf.getOppositeFace();
        }
        return null;
    }

    public static BlockFace getTargetBlockBlockFace(Player player, int distance) {
        List blocks = player.getLastTwoTargetBlocks(transparentBlocks, distance);
        if (blocks.size() <= 1) {
            return BlockFace.EAST;
        }
        return BlockUtil.getBlockFace((Block)blocks.get(0), (Block)blocks.get(1));
    }

    public static boolean isOutsideOfBorder(Location location) {
        if (location == null) {
            return false;
        }
        if (VersionManager.is1_11OrAbove()) {
            return !location.getWorld().getWorldBorder().isInside(location);
        }
        WorldBorder border = location.getWorld().getWorldBorder();
        Location center = border.getCenter();
        double x = location.getX();
        double z = location.getZ();
        double size = border.getSize();
        return Math.abs(x - center.getX()) > size / 2.0 || Math.abs(z - center.getZ()) > size / 2.0;
    }

    public static boolean isPortalBlock(Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (block.getRelative(face).getType() != EnumMaterial.NETHER_PORTAL.getType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemFrame(Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (block.getRelative(face).getType() != EnumMaterial.ITEM_FRAME.getType()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHangingEntities(Location location) {
        if (VersionManager.is1_8_R1Version()) {
            return false;
        }
        for (Entity ent : location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0)) {
            if (!(ent instanceof ItemFrame) && !(ent instanceof Painting) && (!VersionManager.is1_17OrAbove() || !(ent instanceof GlowItemFrame)) || !location.equals((Object)ent.getLocation().getBlock().getLocation())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCocoaBlock(Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (block.getRelative(face).getType() != EnumMaterial.COCOA.getType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isStem(Block block) {
        for (BlockFace face : Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN, BlockFace.SELF)) {
            if (block.getRelative(face).getType() != EnumMaterial.ATTACHED_MELON_STEM.getType() && block.getRelative(face).getType() != EnumMaterial.ATTACHED_PUMPKIN_STEM.getType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMushroomBlock(Block block) {
        BlockFace[] blockface;
        for (BlockFace face : blockface = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST}) {
            if (block.getRelative(face).getType() != EnumMaterial.BROWN_MUSHROOM.getType() && block.getRelative(face).getType() != EnumMaterial.RED_MUSHROOM.getType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isChorusPlant(Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (block.getRelative(face).getType() != EnumMaterial.CHORUS_PLANT.getType()) continue;
            return true;
        }
        return false;
    }
}

