/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.player;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.event.mysterydust.AssignMysteryDustEvent;
import com.yapzhenyie.GadgetsMenu.api.event.mysterydust.GainMysteryDustEvent;
import com.yapzhenyie.GadgetsMenu.api.event.mysterydust.RemoveMysteryDustEvent;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Cloak;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.Emote;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.emotes.EmoteType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHat;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.animated.AnimatedHatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.hats.standard.HatType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.Pet;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetCategoryType;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitEquipmentType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.database.DatabaseStorage;
import com.yapzhenyie.GadgetsMenu.database.DatabaseUtils;
import com.yapzhenyie.GadgetsMenu.economy.GStorage;
import com.yapzhenyie.GadgetsMenu.menu.menus.GadgetTypesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.ItemPurchaseMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.MainMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.PetTypesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.SuitEquipmentMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.ConfirmOpenMultipleBoxesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryvault.MysteryVaultMenu;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxes;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxesManager;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumCache;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.PurchaseData;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.MysteryBoxesReward;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVault;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.types.Animation;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PlayerManager
extends OfflinePlayerManager {
    private UUID uuid;
    private Player player;
    private int mysteryDust = -1;
    private BukkitTask mysteryBoxesRewardTask;
    private int afkTime = 0;
    private int playTime = 0;
    private AnimationType mysteryVaultAnimation;
    private Animation animation;
    private ConfirmOpenMultipleBoxesMenu.OpenMultipleBoxesType openType = null;
    private ArrayList<MysteryBoxes> mysteryBoxes = new ArrayList();
    private ArrayList<MysteryBoxes> mysteryBoxesCache = new ArrayList();
    private MysteryVault selectedMysteryVault;
    private MysteryBoxes selectedMysteryBox;
    private boolean isOpeningMysteryBox;
    private String recentLootsFound;
    private int giftPacks = -1;
    private int giftSent = -1;
    private int giftReceived = -1;
    private boolean isRefreshTaskActivated = false;
    private Player selectedSendGiftPlayer = null;
    private String petName = null;
    private EnumCache canSeeSelfMorph = EnumCache.UNLOADED;
    private EnumCache isBypassCooldown = EnumCache.UNLOADED;
    private boolean renamingPet = false;
    private HatType selectedHat = null;
    private AnimatedHatType selectedAnimatedHat = null;
    private ParticleType selectedParticle = null;
    private Map<EnumArmorType, SuitEquipmentType> selectedSuitEquipment = new HashMap<EnumArmorType, SuitEquipmentType>();
    private GadgetCategoryType selectedCategoryGadget = null;
    private GadgetType selectedGadget = null;
    private PetCategoryType selectedCategoryPet = null;
    private PetType selectedPet = null;
    private MorphType selectedMorph = null;
    private BannerType selectedBanner = null;
    private EmoteType selectedEmote = null;
    private CloakType selectedCloak = null;
    private BukkitRunnable particleRunnableTask;
    private HatType cacheEquippedHat = null;
    private AnimatedHatType cacheEquippedAnimatedHat = null;
    private ParticleType cacheEquippedParticle = null;
    private Map<EnumArmorType, SuitEquipmentType> cacheEquippedSuitEquipment = new HashMap<EnumArmorType, SuitEquipmentType>();
    private GadgetType cacheEquippedGadget = null;
    private PetType cacheEquippedPet = null;
    private MorphType cacheEquippedMorph = null;
    private BannerType cacheEquippedBanner = null;
    private EmoteType cacheEquippedEmote = null;
    private CloakType cacheEquippedCloak = null;
    private AnimatedHat animatedHat;
    private Suit suit;
    private Gadget gadget;
    private Pet pet;
    private Morph morph;
    private Emote emote;
    private Cloak cloak;
    private HashMap<SuitType, Long> suitCooldown = new HashMap();
    private HashMap<GadgetType, Long> gadgetCooldown = new HashMap();
    private HashMap<MorphType, Long> morphCooldown = new HashMap();
    private HashMap<EmoteType, Long> emoteCooldown = new HashMap();
    private int currentHatsPage = 1;
    private int currentParticlesPage = 1;
    private int currentGadgetsPage = 1;
    private int currentPetsPage = 1;
    private int currentBannersPage = 1;
    private int currentEmotesPage = 1;
    private int currentMysteryVaultPage = 1;
    private int currentRadioGadgetPage = 1;
    private int currentGiftInventoryPage = 1;
    private int currentSendGiftPage = 1;
    private ItemCostDiscount itemCostDiscount;
    private PurchaseData purchaseData;
    private boolean disableBlockDamage = false;
    private boolean disableFireDamage = false;
    private boolean disableFallDamage = false;
    private int UID = -1;
    private boolean isMoving = false;
    private boolean isLoaded = false;
    private boolean cosmeticUsageStatus = true;

    public PlayerManager(UUID uuid) {
        super(uuid);
        this.uuid = uuid;
        this.player = Bukkit.getPlayer((UUID)this.uuid);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Override
    public String getName() {
        if (this.player == null) {
            Player p = Bukkit.getPlayer((UUID)this.uuid);
            if (p == null) {
                return null;
            }
            return p.getName();
        }
        return this.player.getName();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isOfflinePlayer() {
        return false;
    }

    public void initCacheData() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            if (!this.isLoaded) {
                if (this.getPlayer() == null || !this.getPlayer().isOnline()) {
                    return;
                }
                ItemCostDiscount discount = DiscountManager.getHighestDiscountGroup(this.getPlayer());
                if (discount != null) {
                    this.setItemCostDiscount(discount);
                }
                this.loadMysteryBoxes();
                this.updateMysteryDust();
            }
        });
    }

    @Override
    public int getMysteryDust() {
        if (!this.isLoaded && GadgetsMenu.getGadgetsMenuData().getDatabaseStorage() == DatabaseStorage.SQLITE && GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage().equals(GStorage.DEFAULT) && this.mysteryDust == -1) {
            try {
                this.mysteryDust = GadgetsMenu.getGEconomyProvider().getMysteryDust(this);
                return this.mysteryDust;
            }
            catch (NullPointerException e) {
                this.mysteryDust = -1;
                return -1;
            }
        }
        int oldMysteryDust = this.mysteryDust;
        if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage().equals(GStorage.DEFAULT)) {
            return this.mysteryDust;
        }
        this.mysteryDust = GadgetsMenu.getGEconomyProvider().getMysteryDust(this);
        if (this.mysteryDust != oldMysteryDust) {
            this.updateMenuSelectorDescription();
        }
        return this.mysteryDust;
    }

    @Override
    public boolean addMysteryDust(int amount) {
        GainMysteryDustEvent event = new GainMysteryDustEvent(this.getPlayer(), amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean isSuccessful = GadgetsMenu.getGEconomyProvider().addMysteryDust(this, amount);
        this.mysteryDust = this.getMysteryDust() + amount;
        this.updateMenuSelectorDescription();
        return isSuccessful;
    }

    @Override
    public boolean setMysteryDust(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("The data cannot be negative value.");
        }
        AssignMysteryDustEvent event = new AssignMysteryDustEvent(this.getPlayer(), amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean isSuccessful = GadgetsMenu.getGEconomyProvider().setMysteryDust(this, amount);
        this.mysteryDust = amount;
        this.updateMenuSelectorDescription();
        return isSuccessful;
    }

    @Override
    public boolean removeMysteryDust(int amount) {
        if (this.getMysteryDust() - amount < 0) {
            throw new IllegalArgumentException("The new data cannot be negative value.");
        }
        RemoveMysteryDustEvent event = new RemoveMysteryDustEvent(this.getPlayer(), amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean isSuccessful = GadgetsMenu.getGEconomyProvider().removeMysteryDust(this, amount);
        this.mysteryDust = this.getMysteryDust() - amount;
        this.updateMenuSelectorDescription();
        return isSuccessful;
    }

    public void updateMysteryDust() {
        int oldMysteryDust = this.mysteryDust;
        this.mysteryDust = GadgetsMenu.getGEconomyProvider().getMysteryDust(this);
        if (this.mysteryDust != oldMysteryDust) {
            this.updateMenuSelectorDescription();
        }
    }

    public void goBackToMainMenu() {
        if (GadgetsMenu.getGadgetsMenuData().isExecuteCommandsWhenBackToMainMenu()) {
            for (String command : GadgetsMenu.getGadgetsMenuData().getBackToMainMenuCustomCommands()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)ChatUtil.format(command.replace("{PLAYER}", this.getPlayer().getName())));
            }
        } else {
            MainMenu.openMainMenu(this.getPlayer());
        }
    }

    public void openHatsMenu(int page) {
        Category.HATS.openMenu(this.getPlayer(), page);
    }

    public void openAnimatedHatsMenu(int page) {
        Category.ANIMATED_HATS.openMenu(this.getPlayer(), page);
    }

    public void openParticlesMenu(int page) {
        Category.PARTICLES.openMenu(this.getPlayer(), page);
    }

    public void openSuitsMenu() {
        Category.SUITS.openMenu(this.getPlayer(), 1);
    }

    public void openSuitEquipmentMenu(SuitType type) {
        SuitEquipmentMenu.openSuitEquipmentMenu(this.getPlayer(), type.getName());
    }

    public void openCategoryGadgetsMenu() {
        Category.GADGETS.openMenu(this.getPlayer(), 1);
    }

    public void openGadgetTypesMenu(GadgetCategoryType type, int page) {
        GadgetTypesMenu.openGadgetTypesMenu(this.getPlayer(), type.getName(), page);
    }

    public void openCategoryPetsMenu() {
        Category.PETS.openMenu(this.getPlayer(), 1);
    }

    public void openPetTypesMenu(PetCategoryType type, int page) {
        PetTypesMenu.openPetsEntityMenu(this.getPlayer(), type.getName(), page);
    }

    public void openMorphsMenu() {
        Category.MORPHS.openMenu(this.getPlayer(), 1);
    }

    public void openBannersMenu(int page) {
        Category.BANNERS.openMenu(this.getPlayer(), page);
    }

    public void openEmotesMenu(int page) {
        Category.EMOTES.openMenu(this.getPlayer(), page);
    }

    public void openCloaksMenu() {
        Category.CLOAKS.openMenu(this.getPlayer(), 1);
    }

    public void openItemPurchaseMenu() {
        ItemPurchaseMenu.openItemPurchaseMenu(this.getPlayer());
    }

    public void openMysteryVaultMenu(int page) {
        MysteryVaultMenu.openMysteryVaultMenu(this.getPlayer(), page);
    }

    public boolean isCosmeticActivated() {
        if (this.selectedHat != null) {
            return true;
        }
        if (this.selectedAnimatedHat != null) {
            return true;
        }
        if (this.selectedParticle != null) {
            return true;
        }
        if (!this.selectedSuitEquipment.isEmpty()) {
            return true;
        }
        if (this.selectedGadget != null) {
            return true;
        }
        if (this.selectedPet != null) {
            return true;
        }
        if (this.selectedMorph != null) {
            return true;
        }
        if (this.selectedBanner != null) {
            return true;
        }
        if (this.selectedEmote != null) {
            return true;
        }
        return this.selectedCloak != null;
    }

    public void unequipActiveCosmetics() {
        this.unequipHat();
        this.unequipAnimatedHat();
        this.unequipParticle();
        this.unequipSuit();
        this.unequipGadget();
        this.unequipPet();
        this.unequipMorph();
        this.unequipBanner();
        this.unequipEmote();
        this.unequipCloak();
    }

    public void equipHat(HatType type) {
        HatManager.equipHat(this.getPlayer(), type);
    }

    public void unequipHat() {
        HatManager.unequipHat(this.getPlayer());
    }

    public void equipAnimatedHat(AnimatedHatType type) {
        AnimatedHatManager.equipAnimatedHat(this.getPlayer(), type);
    }

    public void unequipAnimatedHat() {
        AnimatedHatManager.unequipAnimatedHat(this.getPlayer());
    }

    public void equipParticle(ParticleType type) {
        ParticleManager.equipParticle(this.getPlayer(), type);
    }

    public void unequipParticle() {
        ParticleManager.unequipParticle(this.getPlayer());
    }

    public void equipSuit(SuitType type) {
        SuitManager.equipSuit(this.getPlayer(), type);
    }

    public void unequipSuit() {
        SuitManager.unequipSuit(this.getPlayer());
    }

    public void equipSuitEquipment(EnumArmorType armor, SuitEquipmentType type) {
        if (armor == EnumArmorType.HELMET) {
            SuitManager.equipHelmet(this.getPlayer(), type);
        } else if (armor == EnumArmorType.CHESTPLATE) {
            SuitManager.equipChestplate(this.getPlayer(), type);
        } else if (armor == EnumArmorType.LEGGINGS) {
            SuitManager.equipLeggings(this.getPlayer(), type);
        } else if (armor == EnumArmorType.BOOTS) {
            SuitManager.equipBoots(this.getPlayer(), type);
        }
    }

    public void unequipSuitEquipment(EnumArmorType armor) {
        switch (armor) {
            case HELMET: {
                SuitManager.unequipHelmet(this.getPlayer());
                break;
            }
            case CHESTPLATE: {
                SuitManager.unequipChestplate(this.getPlayer());
                break;
            }
            case LEGGINGS: {
                SuitManager.unequipLeggings(this.getPlayer());
                break;
            }
            case BOOTS: {
                SuitManager.unequipBoots(this.getPlayer());
            }
        }
    }

    public void equipGadget(GadgetType type) {
        GadgetManager.equipGadget(this.getPlayer(), type);
    }

    public void unequipGadget() {
        GadgetManager.unequipGadget(this.getPlayer());
    }

    public void equipPet(PetType type) {
        PetManager.equipPet(this.getPlayer(), type);
    }

    public void unequipPet() {
        PetManager.unequipPet(this.getPlayer());
    }

    public void equipMorph(MorphType type) {
        MorphManager.equipMorph(this.getPlayer(), type);
    }

    public void unequipMorph() {
        MorphManager.unequipMorph(this.getPlayer());
    }

    public void equipBanner(BannerType type) {
        BannerManager.equipBanner(this.getPlayer(), type);
    }

    public void unequipBanner() {
        BannerManager.unequipBanner(this.getPlayer());
    }

    public void equipEmote(EmoteType type) {
        EmoteManager.equipEmote(this.getPlayer(), type);
    }

    public void unequipEmote() {
        EmoteManager.unequipEmote(this.getPlayer());
    }

    public void equipCloak(CloakType type) {
        CloakManager.equipCloak(this.getPlayer(), type);
    }

    public void unequipCloak() {
        CloakManager.unequipCloak(this.getPlayer());
    }

    public void cacheEquippedCosmetics() {
        if (!GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            return;
        }
        if (this.selectedHat != null) {
            this.cacheEquippedHat = this.selectedHat;
        }
        if (this.selectedAnimatedHat != null) {
            this.cacheEquippedAnimatedHat = this.selectedAnimatedHat;
        }
        if (this.selectedParticle != null) {
            this.cacheEquippedParticle = this.selectedParticle;
        }
        if (this.selectedSuitEquipment.get((Object)EnumArmorType.HELMET) != null) {
            if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.HELMET) != null) {
                this.cacheEquippedSuitEquipment.replace(EnumArmorType.HELMET, this.selectedSuitEquipment.get((Object)EnumArmorType.HELMET));
            } else {
                this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.HELMET, this.selectedSuitEquipment.get((Object)EnumArmorType.HELMET));
            }
        }
        if (this.selectedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE) != null) {
            if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE) != null) {
                this.cacheEquippedSuitEquipment.replace(EnumArmorType.CHESTPLATE, this.selectedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE));
            } else {
                this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.CHESTPLATE, this.selectedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE));
            }
        }
        if (this.selectedSuitEquipment.get((Object)EnumArmorType.LEGGINGS) != null) {
            if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.LEGGINGS) != null) {
                this.cacheEquippedSuitEquipment.replace(EnumArmorType.LEGGINGS, this.selectedSuitEquipment.get((Object)EnumArmorType.LEGGINGS));
            } else {
                this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.LEGGINGS, this.selectedSuitEquipment.get((Object)EnumArmorType.LEGGINGS));
            }
        }
        if (this.selectedSuitEquipment.get((Object)EnumArmorType.BOOTS) != null) {
            if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.BOOTS) != null) {
                this.cacheEquippedSuitEquipment.replace(EnumArmorType.BOOTS, this.selectedSuitEquipment.get((Object)EnumArmorType.BOOTS));
            } else {
                this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.BOOTS, this.selectedSuitEquipment.get((Object)EnumArmorType.BOOTS));
            }
        }
        if (this.selectedGadget != null) {
            this.cacheEquippedGadget = this.selectedGadget;
        }
        if (this.selectedPet != null) {
            this.cacheEquippedPet = this.selectedPet;
        }
        if (this.selectedMorph != null) {
            this.cacheEquippedMorph = this.selectedMorph;
        }
        if (this.selectedBanner != null) {
            this.cacheEquippedBanner = this.selectedBanner;
        }
        if (this.selectedEmote != null) {
            this.cacheEquippedEmote = this.selectedEmote;
        }
        if (this.selectedCloak != null) {
            this.cacheEquippedCloak = this.selectedCloak;
        }
    }

    public void removeCacheEquippedCosmetics() {
        this.cacheEquippedHat = null;
        this.cacheEquippedAnimatedHat = null;
        this.cacheEquippedParticle = null;
        this.cacheEquippedSuitEquipment.clear();
        this.cacheEquippedGadget = null;
        this.cacheEquippedPet = null;
        this.cacheEquippedMorph = null;
        this.cacheEquippedBanner = null;
        this.cacheEquippedEmote = null;
        this.cacheEquippedCloak = null;
    }

    public void loadEquippedCosmeticsFromCache() {
        if (this.getPlayer() == null) {
            return;
        }
        if (!WorldUtils.isWorldEnabled(this.getPlayer().getWorld())) {
            return;
        }
        if (!GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            if (this.getPlayer() == null || !WorldUtils.isWorldEnabled(this.getPlayer().getWorld())) {
                return;
            }
            HatType hat = this.cacheEquippedHat;
            AnimatedHatType animatedHat = this.cacheEquippedAnimatedHat;
            ParticleType particle = this.cacheEquippedParticle;
            SuitEquipmentType suitHelmet = this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.HELMET);
            SuitEquipmentType suitChestplate = this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE);
            SuitEquipmentType suitLeggings = this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.LEGGINGS);
            SuitEquipmentType suitBoots = this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.BOOTS);
            GadgetType gadget = this.cacheEquippedGadget;
            PetType pet = this.cacheEquippedPet;
            MorphType morph = this.cacheEquippedMorph;
            BannerType banner = this.cacheEquippedBanner;
            EmoteType emote = this.cacheEquippedEmote;
            CloakType cloak = this.cacheEquippedCloak;
            if (hat != null) {
                this.equipHat(hat);
            }
            if (animatedHat != null) {
                this.equipAnimatedHat(animatedHat);
            }
            if (particle != null) {
                this.equipParticle(particle);
            }
            if (suitHelmet != null) {
                this.equipSuitEquipment(EnumArmorType.HELMET, suitHelmet);
            }
            if (suitChestplate != null) {
                this.equipSuitEquipment(EnumArmorType.CHESTPLATE, suitChestplate);
            }
            if (suitLeggings != null) {
                this.equipSuitEquipment(EnumArmorType.LEGGINGS, suitLeggings);
            }
            if (suitBoots != null) {
                this.equipSuitEquipment(EnumArmorType.BOOTS, suitBoots);
            }
            if (gadget != null) {
                GadgetType finalGadget = gadget;
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.equipGadget(finalGadget));
            }
            if (pet != null) {
                PetType finalPet = pet;
                Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.equipPet(finalPet));
            }
            if (morph != null) {
                MorphType finalMorph = morph;
                Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> this.equipMorph(finalMorph), 10L);
            }
            if (banner != null) {
                this.equipBanner(banner);
            }
            if (emote != null) {
                this.equipEmote(emote);
            }
            if (cloak != null) {
                this.equipCloak(cloak);
            }
            this.removeCacheEquippedCosmetics();
        }, 10L);
    }

    private void syncCachedCosmetics(boolean async) {
        if (!GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            return;
        }
        List<String> values = Arrays.asList(this.cacheEquippedHat == null ? null : this.cacheEquippedHat.getName(), this.cacheEquippedAnimatedHat == null ? null : this.cacheEquippedAnimatedHat.getName(), this.cacheEquippedParticle == null ? null : this.cacheEquippedParticle.getName(), this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.HELMET) == null ? null : this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.HELMET).getName(), this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE) == null ? null : this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE).getName(), this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.LEGGINGS) == null ? null : this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.LEGGINGS).getName(), this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.BOOTS) == null ? null : this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.BOOTS).getName(), this.cacheEquippedGadget == null ? null : this.cacheEquippedGadget.getName(), this.cacheEquippedPet == null ? null : this.cacheEquippedPet.getName(), this.cacheEquippedMorph == null ? null : this.cacheEquippedMorph.getName(), this.cacheEquippedBanner == null ? null : this.cacheEquippedBanner.getName(), this.cacheEquippedEmote == null ? null : this.cacheEquippedEmote.getName(), this.cacheEquippedCloak == null ? null : this.cacheEquippedCloak.getName());
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> GadgetsMenu.getDatabaseManager().getDatabaseUtils().syncEquippedCosmetics(Category.getMySQLIndexes(), values, this.getUID()));
        } else {
            GadgetsMenu.getDatabaseManager().getDatabaseUtils().syncEquippedCosmetics(Category.getMySQLIndexes(), values, this.getUID());
        }
    }

    public void syncSelectedCosmetics(boolean async) {
        if (!GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            return;
        }
        if (!WorldUtils.isWorldEnabled(this.getPlayer().getWorld())) {
            this.syncCachedCosmetics(async);
        } else {
            List<String> values = Arrays.asList(this.selectedHat == null ? null : this.selectedHat.getName(), this.selectedAnimatedHat == null ? null : this.selectedAnimatedHat.getName(), this.selectedParticle == null ? null : this.selectedParticle.getName(), this.selectedSuitEquipment.get((Object)EnumArmorType.HELMET) == null ? null : this.selectedSuitEquipment.get((Object)EnumArmorType.HELMET).getName(), this.selectedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE) == null ? null : this.selectedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE).getName(), this.selectedSuitEquipment.get((Object)EnumArmorType.LEGGINGS) == null ? null : this.selectedSuitEquipment.get((Object)EnumArmorType.LEGGINGS).getName(), this.selectedSuitEquipment.get((Object)EnumArmorType.BOOTS) == null ? null : this.selectedSuitEquipment.get((Object)EnumArmorType.BOOTS).getName(), this.selectedGadget == null ? null : this.selectedGadget.getName(), this.selectedPet == null ? null : this.selectedPet.getName(), this.selectedMorph == null ? null : this.selectedMorph.getName(), this.selectedBanner == null ? null : this.selectedBanner.getName(), this.selectedEmote == null ? null : this.selectedEmote.getName(), this.selectedCloak == null ? null : this.selectedCloak.getName());
            if (async) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> GadgetsMenu.getDatabaseManager().getDatabaseUtils().syncEquippedCosmetics(Category.getMySQLIndexes(), values, this.getUID()));
            } else {
                GadgetsMenu.getDatabaseManager().getDatabaseUtils().syncEquippedCosmetics(Category.getMySQLIndexes(), values, this.getUID());
            }
        }
    }

    public void loadSelectedCosmetics() {
        if (this.getPlayer() == null) {
            return;
        }
        if (!GadgetsMenu.getGadgetsMenuData().syncCosmeticsOnJoin()) {
            return;
        }
        if (GadgetsMenu.getInstance() != null) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
                if (this.getPlayer() == null) {
                    return;
                }
                HatType hat = null;
                AnimatedHatType animatedHat = null;
                ParticleType particle = null;
                SuitEquipmentType suitHelmet = null;
                SuitEquipmentType suitChestplate = null;
                SuitEquipmentType suitLeggings = null;
                SuitEquipmentType suitBoots = null;
                GadgetType gadget = null;
                PetType pet = null;
                MorphType morph = null;
                BannerType banner = null;
                EmoteType emote = null;
                CloakType cloak = null;
                DatabaseUtils sql = GadgetsMenu.getDatabaseManager().getDatabaseUtils();
                List<String> selectedCosmetics = sql.getEquippedCosmetics(Category.getMySQLIndexes(), this.getUID());
                hat = HatType.valueOf(selectedCosmetics.get(0));
                animatedHat = AnimatedHatType.valueOf(selectedCosmetics.get(1));
                particle = ParticleType.valueOf(selectedCosmetics.get(2));
                suitHelmet = SuitEquipmentType.valueOf(selectedCosmetics.get(3));
                suitChestplate = SuitEquipmentType.valueOf(selectedCosmetics.get(4));
                suitLeggings = SuitEquipmentType.valueOf(selectedCosmetics.get(5));
                suitBoots = SuitEquipmentType.valueOf(selectedCosmetics.get(6));
                gadget = GadgetType.valueOf(selectedCosmetics.get(7));
                pet = PetType.valueOf(selectedCosmetics.get(8));
                morph = MorphType.valueOf(selectedCosmetics.get(9));
                banner = BannerType.valueOf(selectedCosmetics.get(10));
                emote = EmoteType.valueOf(selectedCosmetics.get(11));
                cloak = CloakType.valueOf(selectedCosmetics.get(12));
                if (!WorldUtils.isWorldEnabled(this.getPlayer().getWorld())) {
                    if (hat != null) {
                        this.cacheEquippedHat = hat;
                    }
                    if (animatedHat != null) {
                        this.cacheEquippedAnimatedHat = animatedHat;
                    }
                    if (particle != null) {
                        this.cacheEquippedParticle = particle;
                    }
                    if (suitHelmet != null) {
                        if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.HELMET) != null) {
                            this.cacheEquippedSuitEquipment.replace(EnumArmorType.HELMET, suitHelmet);
                        } else {
                            this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.HELMET, suitHelmet);
                        }
                    }
                    if (suitChestplate != null) {
                        if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.CHESTPLATE) != null) {
                            this.cacheEquippedSuitEquipment.replace(EnumArmorType.CHESTPLATE, suitChestplate);
                        } else {
                            this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.CHESTPLATE, suitChestplate);
                        }
                    }
                    if (suitLeggings != null) {
                        if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.LEGGINGS) != null) {
                            this.cacheEquippedSuitEquipment.replace(EnumArmorType.LEGGINGS, suitLeggings);
                        } else {
                            this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.LEGGINGS, suitLeggings);
                        }
                    }
                    if (suitBoots != null) {
                        if (this.cacheEquippedSuitEquipment.get((Object)EnumArmorType.BOOTS) != null) {
                            this.cacheEquippedSuitEquipment.replace(EnumArmorType.BOOTS, suitBoots);
                        } else {
                            this.cacheEquippedSuitEquipment.putIfAbsent(EnumArmorType.BOOTS, suitBoots);
                        }
                    }
                    if (gadget != null) {
                        this.cacheEquippedGadget = gadget;
                    }
                    if (pet != null) {
                        this.cacheEquippedPet = pet;
                    }
                    if (morph != null) {
                        this.cacheEquippedMorph = morph;
                    }
                    if (banner != null) {
                        this.cacheEquippedBanner = banner;
                    }
                    if (emote != null) {
                        this.cacheEquippedEmote = emote;
                    }
                    if (cloak != null) {
                        this.cacheEquippedCloak = cloak;
                    }
                } else {
                    if (hat != null) {
                        this.equipHat(hat);
                    }
                    if (animatedHat != null) {
                        this.equipAnimatedHat(animatedHat);
                    }
                    if (particle != null) {
                        this.equipParticle(particle);
                    }
                    if (suitHelmet != null) {
                        this.equipSuitEquipment(EnumArmorType.HELMET, suitHelmet);
                    }
                    if (suitChestplate != null) {
                        this.equipSuitEquipment(EnumArmorType.CHESTPLATE, suitChestplate);
                    }
                    if (suitLeggings != null) {
                        this.equipSuitEquipment(EnumArmorType.LEGGINGS, suitLeggings);
                    }
                    if (suitBoots != null) {
                        this.equipSuitEquipment(EnumArmorType.BOOTS, suitBoots);
                    }
                    if (gadget != null) {
                        GadgetType finalGadget = gadget;
                        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.equipGadget(finalGadget));
                    }
                    if (pet != null) {
                        PetType finalPet = pet;
                        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> this.equipPet(finalPet));
                    }
                    if (morph != null) {
                        MorphType finalMorph = morph;
                        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> this.equipMorph(finalMorph), 10L);
                    }
                    if (banner != null) {
                        this.equipBanner(banner);
                    }
                    if (emote != null) {
                        this.equipEmote(emote);
                    }
                    if (cloak != null) {
                        this.equipCloak(cloak);
                    }
                }
            }, 10L);
        }
    }

    public boolean getCosmeticUsageStatus() {
        return this.cosmeticUsageStatus;
    }

    public void setCosmeticUsage(boolean enable) {
        this.cosmeticUsageStatus = enable;
        if (!enable) {
            this.unequipActiveCosmetics();
        }
    }

    public void giveMenuSelector() {
        if (this.getPlayer() == null) {
            return;
        }
        if (!this.getPlayer().hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
            return;
        }
        this.removeMenuSelector();
        int slot = GadgetsMenu.getGadgetsMenuData().getMenuSelectorSlot();
        Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
            if (this.getPlayer() == null || !this.getPlayer().isOnline()) {
                return;
            }
            if (this.getPlayer().getInventory().getItem(slot) != null) {
                if (GadgetsMenu.getNMSManager().hasNBTTag(this.getPlayer().getInventory().getItem(slot), "Menu_Selector")) {
                    this.getPlayer().getInventory().remove(GadgetsMenu.getGadgetsMenuData().getMenuSelector());
                    this.getPlayer().getInventory().setItem(slot, null);
                    this.getPlayer().updateInventory();
                } else {
                    this.getPlayer().getWorld().dropItemNaturally(this.getPlayer().getLocation(), this.getPlayer().getInventory().getItem(slot).clone());
                    this.getPlayer().getInventory().setItem(slot, null);
                    this.getPlayer().updateInventory();
                }
            }
            ItemStack menuSelector = ItemUtils.item(GadgetsMenu.getGadgetsMenuData().getMenuSelector(), Arrays.asList("{MYSTERY_DUST}", "{MYSTERY_BOXES}"), Arrays.asList(String.valueOf(this.getMysteryDust()), String.valueOf(this.getMysteryBoxes())));
            menuSelector = GadgetsMenu.getNMSManager().setNBTTag(menuSelector, "Menu_Selector", "true");
            this.getPlayer().getInventory().setItem(slot, menuSelector);
            this.getPlayer().updateInventory();
        });
    }

    public void removeMenuSelector() {
        if (this.getPlayer() == null) {
            return;
        }
        if (!GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() || !this.getPlayer().hasPermission(EnumPermission.MENU_SELECTOR.getPermission())) {
            return;
        }
        int slot = GadgetsMenu.getGadgetsMenuData().getMenuSelectorSlot();
        if (GadgetsMenu.getNMSManager().hasNBTTag(this.getPlayer().getInventory().getItem(slot), "Menu_Selector")) {
            this.getPlayer().getInventory().setItem(slot, null);
            this.getPlayer().updateInventory();
        }
        if (this.getPlayer().getInventory().contains(GadgetsMenu.getGadgetsMenuData().getMenuSelector().getType())) {
            for (int i = 0; i < this.getPlayer().getInventory().getSize(); ++i) {
                ItemStack item = this.getPlayer().getInventory().getItem(i);
                if (!GadgetsMenu.getNMSManager().hasNBTTag(item, "Menu_Selector")) continue;
                this.getPlayer().getInventory().setItem(i, null);
                this.getPlayer().updateInventory();
            }
        }
    }

    public void updateMenuSelectorDescription() {
        if (this.getPlayer() == null) {
            return;
        }
        if (!(GadgetsMenu.getGadgetsMenuData().isGiveMenuSelectorOnJoin() && this.getPlayer().hasPermission(EnumPermission.MENU_SELECTOR.getPermission()) && WorldUtils.isWorldEnabled(this.getPlayer().getWorld()))) {
            return;
        }
        if (this.getPlayer().getInventory().contains(GadgetsMenu.getGadgetsMenuData().getMenuSelector().getType())) {
            for (int i = 0; i < this.getPlayer().getInventory().getSize(); ++i) {
                try {
                    ItemStack item = this.getPlayer().getInventory().getItem(i);
                    if (!GadgetsMenu.getNMSManager().hasNBTTag(item, "Menu_Selector")) continue;
                    ItemMeta itemMeta = item.getItemMeta();
                    ArrayList<String> itemLore = new ArrayList<String>();
                    List lore = GadgetsMenu.getGadgetsMenuData().getMenuSelector().getItemMeta().getLore();
                    if (lore != null) {
                        for (String s1 : lore) {
                            itemLore.add(ChatUtil.format(s1.replace("{MYSTERY_DUST}", String.valueOf(this.getMysteryDust())).replace("{MYSTERY_BOXES}", String.valueOf(this.getMysteryBoxes()))));
                        }
                    }
                    itemMeta.setLore(itemLore);
                    item.setItemMeta(itemMeta);
                    this.getPlayer().getInventory().setItem(i, item);
                    this.getPlayer().updateInventory();
                    continue;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public String getPetName() {
        if (!this.isLoaded) {
            return GadgetsMenu.getGadgetsMenuData().getDefaultPetName();
        }
        return ChatUtil.format(this.petName);
    }

    @Override
    public void setPetName(String name) {
        Pattern p = Pattern.compile("[$+,:;=?@#|'<>.^*()%!]");
        Matcher m = p.matcher(name);
        if (m.find()) {
            name = name.replaceAll("[$+,:;=?@#|'<>.^*()%!]", "");
        }
        name = ChatUtil.format(name);
        Pet pet = this.getCurrentPet();
        if (pet != null && pet.getEntity() != null && pet.getEntity().isValid()) {
            if (!pet.getEntity().isCustomNameVisible()) {
                pet.getEntity().setCustomNameVisible(true);
            }
            pet.getEntity().setCustomName(name);
        }
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().setPetName(this, name);
        this.petName = name;
    }

    public boolean isBypassCooldown() {
        if (this.isBypassCooldown != EnumCache.UNLOADED) {
            return this.isBypassCooldown == EnumCache.ENABLED;
        }
        if (GadgetsMenu.getDatabaseManager().getDatabaseUtils().isCooldownBypass(this)) {
            this.isBypassCooldown = EnumCache.ENABLED;
            return true;
        }
        this.isBypassCooldown = EnumCache.DISABLED;
        return false;
    }

    public void setBypassCooldown(boolean enabled) {
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().setCooldownBypass(this, enabled);
        if (enabled) {
            this.getPlayer().sendMessage(MessageType.ENABLED_BYPASS_COOLDOWN.getFormatMessage());
            this.isBypassCooldown = EnumCache.ENABLED;
        } else {
            this.getPlayer().sendMessage(MessageType.DISABLED_BYPASS_COOLDOWN.getFormatMessage());
            this.isBypassCooldown = EnumCache.DISABLED;
        }
    }

    public boolean canSeeSelfMorph() {
        if (!GadgetsMenu.getGadgetsMenuData().isSelfMorphViewEnabled()) {
            return false;
        }
        if (this.canSeeSelfMorph != EnumCache.UNLOADED) {
            return this.canSeeSelfMorph == EnumCache.ENABLED;
        }
        if (GadgetsMenu.getDatabaseManager().getDatabaseUtils().canSeeSelfMorph(this)) {
            this.canSeeSelfMorph = EnumCache.ENABLED;
            return true;
        }
        this.canSeeSelfMorph = EnumCache.DISABLED;
        return false;
    }

    public void setSeeSelfMorph(boolean enabled) {
        if (!GadgetsMenu.getGadgetsMenuData().isSelfMorphViewEnabled()) {
            return;
        }
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().setSeeSelfMorph(this, enabled);
        if (enabled) {
            this.getPlayer().sendMessage(MessageType.ENABLED_SELF_MORPH_VIEW.getFormatMessage());
            this.canSeeSelfMorph = EnumCache.ENABLED;
        } else {
            this.getPlayer().sendMessage(MessageType.DISABLED_SELF_MORPH_VIEW.getFormatMessage());
            this.canSeeSelfMorph = EnumCache.DISABLED;
        }
        if ((GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() || GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) && GadgetsMenu.getGDisguise().isDisguised(this.getPlayer()) && this.selectedMorph != null) {
            GadgetsMenu.getGDisguise().setViewDisguiseToggled(this.getPlayer(), enabled);
        }
    }

    public boolean isRenamingPet() {
        return this.renamingPet;
    }

    public void setRenamingPet(boolean arg0) {
        this.renamingPet = arg0;
    }

    public ArrayList<MysteryBoxes> mysteryBoxes() {
        this.syncMysteryBoxesCache();
        return this.mysteryBoxes;
    }

    public ArrayList<MysteryBoxes> mysteryBoxesCache() {
        return this.mysteryBoxesCache;
    }

    public void syncMysteryBoxesCache() {
        if (this.mysteryBoxesCache.isEmpty() || !this.isLoaded) {
            return;
        }
        ArrayList<MysteryBoxes> removeList = new ArrayList<MysteryBoxes>();
        for (MysteryBoxes boxes : this.mysteryBoxesCache) {
            if (boxes.isExpirable()) {
                if (!boxes.isExpired()) {
                    this.mysteryBoxes.add(boxes);
                    GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryBox(this.getUUID(), this.getUID(), boxes);
                }
            } else {
                this.mysteryBoxes.add(boxes);
                GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryBox(this.getUUID(), this.getUID(), boxes);
            }
            removeList.add(boxes);
        }
        this.mysteryBoxesCache.removeAll(removeList);
    }

    public boolean isRandomMysteryVaultAnimationSelected() {
        return this.getMysteryVaultAnimation() == AnimationType.RANDOM;
    }

    public AnimationType getMysteryVaultAnimation() {
        if (this.mysteryVaultAnimation == null) {
            AnimationType ani = GadgetsMenu.getDatabaseManager().getDatabaseUtils().getMysteryVaultAnimation(this);
            this.mysteryVaultAnimation = ani == null ? this.getRandomMysteryVaultAnimation() : ani;
            return this.mysteryVaultAnimation;
        }
        return this.mysteryVaultAnimation;
    }

    public AnimationType getRandomMysteryVaultAnimation() {
        ArrayList<AnimationType> animations = new ArrayList<AnimationType>();
        for (AnimationType ani : AnimationType.enabled()) {
            if (PermissionUtils.noPermission(this.getPlayer(), ani.getPermission(), EnumPermission.ALL_MYSTERY_VAULT_ANIMATIONS.getPermission(), false)) continue;
            animations.add(ani);
        }
        if (animations.isEmpty()) {
            return AnimationType.NORMAL;
        }
        return (AnimationType)animations.get(GadgetsMenu.random().nextInt(animations.size()));
    }

    public void setMysteryVaultAnimation(AnimationType animation) {
        if (animation == null) {
            throw new NullPointerException("The animation can not be null.");
        }
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().setMysteryVaultAnimation(this, animation);
        this.mysteryVaultAnimation = animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public void stopAnimation() {
        if (this.animation == null) {
            return;
        }
        this.animation.onClear();
        this.animation.clear();
        this.animation = null;
    }

    @Override
    public int getMysteryBoxes() {
        return this.mysteryBoxes.size();
    }

    @Override
    public void giveMysteryBoxes(Long expiryDate, boolean requirePerm, String details, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("The amount must be positive number!");
        }
        this.syncMysteryBoxesCache();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            for (int i = 1; i <= amount; ++i) {
                int random = GadgetsMenu.random().nextInt(5) + 1;
                MysteryBoxesManager.giveMysteryBoxes(this, MysteryBoxType.valueOfByName("Normal Mystery Box #" + random), requirePerm, details, expiryDate);
            }
            this.updateMenuSelectorDescription();
        });
    }

    @Override
    public void giveMysteryBoxes(MysteryBoxType mysteryBoxType, Long expiryDate, boolean requirePerm, String details, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("The amount must be positive number!");
        }
        this.syncMysteryBoxesCache();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            for (int i = 1; i <= amount; ++i) {
                MysteryBoxesManager.giveMysteryBoxes(this, mysteryBoxType, requirePerm, details, expiryDate);
            }
            this.updateMenuSelectorDescription();
        });
    }

    @Override
    public void giveMysteryBoxes(Long expiryDate, boolean requirePerm, String details, int amount, float totalChance, float oneStarChance, float twoStarChance, float threeStarChance, float fourStarChance, float fiveStarChance) {
        if (amount <= 0) {
            throw new IllegalArgumentException("The amount must be positive number!");
        }
        this.syncMysteryBoxesCache();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            for (int i = 1; i <= amount; ++i) {
                float allchance = oneStarChance + twoStarChance + threeStarChance + fourStarChance + fiveStarChance;
                float random = MathUtil.randomFloat(0.0f, allchance);
                int q = 1;
                q = random <= oneStarChance ? 1 : (random > oneStarChance && random <= oneStarChance + twoStarChance ? 2 : (random > oneStarChance + twoStarChance && random <= oneStarChance + twoStarChance + threeStarChance ? 3 : (random > oneStarChance + twoStarChance + threeStarChance && random <= oneStarChance + twoStarChance + threeStarChance + fourStarChance ? 4 : (random > oneStarChance + twoStarChance + threeStarChance + fourStarChance && random <= oneStarChance + twoStarChance + threeStarChance + fourStarChance + fiveStarChance ? 5 : GadgetsMenu.random().nextInt(5) + 1))));
                MysteryBoxType boxType = MysteryBoxType.valueOfByName("Normal Mystery Box #" + q);
                MysteryBoxesManager.giveMysteryBoxes(this, boxType, requirePerm, details, expiryDate);
            }
            this.updateMenuSelectorDescription();
        });
    }

    public void removeMysteryBox(MysteryBoxes mysteryBox) {
        this.mysteryBoxes.remove(mysteryBox);
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().removeMysteryBox(this.getUID(), mysteryBox);
        this.updateMenuSelectorDescription();
    }

    private boolean loadMysteryBoxes() {
        if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled()) {
            this.isLoaded = true;
            return true;
        }
        try {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
                GadgetsMenu.getDatabaseManager().getDatabaseUtils().loadMysteryBoxes(this);
                for (MysteryBoxes boxes : this.mysteryBoxesCache) {
                    if (boxes.isExpirable()) {
                        if (boxes.isExpired()) continue;
                        this.mysteryBoxes.add(boxes);
                        GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryBox(this.getUUID(), this.getUID(), boxes);
                        continue;
                    }
                    this.mysteryBoxes.add(boxes);
                    GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryBox(this.getUUID(), this.getUID(), boxes);
                }
                this.mysteryBoxesCache.clear();
                this.isLoaded = true;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isLoaded = true;
            return false;
        }
        return true;
    }

    public int getGiftPacks() {
        if (this.giftPacks == -1) {
            this.giftPacks = GadgetsMenu.getDatabaseManager().getDatabaseUtils().getMysteryGiftPacks(this);
            return this.giftPacks;
        }
        return this.giftPacks;
    }

    public void addGiftPacks(int arg0) {
        if (this.giftPacks == -1) {
            this.getGiftPacks();
        }
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryGiftPacks(this, arg0);
        this.giftPacks += arg0;
    }

    public void removeGiftPacks(int arg0) {
        int amount;
        if (this.giftPacks == -1) {
            this.getGiftPacks();
        }
        if ((amount = this.giftPacks - arg0) < 0) {
            this.giftPacks = 0;
            amount = 0;
        }
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().removeMysteryGiftPacks(this, arg0);
        this.giftPacks = amount;
    }

    public int getGiftSent() {
        if (this.giftSent == -1) {
            this.giftSent = GadgetsMenu.getDatabaseManager().getDatabaseUtils().getMysteryGiftSent(this);
            return this.giftSent;
        }
        return this.giftSent;
    }

    public void addGiftSent(int arg0) {
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryGiftSent(this, arg0);
        this.giftSent = this.getGiftSent() + arg0;
    }

    public int getGiftReceived() {
        if (this.giftReceived == -1) {
            this.giftReceived = GadgetsMenu.getDatabaseManager().getDatabaseUtils().getMysteryGiftReceived(this);
            return this.giftReceived;
        }
        return this.giftReceived;
    }

    public void addGiftReceived(int arg0) {
        GadgetsMenu.getDatabaseManager().getDatabaseUtils().addMysteryGiftReceived(this, arg0);
        this.giftReceived = this.getGiftReceived() + arg0;
    }

    public String[] getRecentLootsFound() {
        if (this.recentLootsFound == null) {
            this.recentLootsFound = GadgetsMenu.getDatabaseManager().getDatabaseUtils().getRecentLootsFound(this);
        }
        return this.recentLootsFound == null ? null : this.recentLootsFound.split("\\, ", 5);
    }

    public void setRecentLootsFound(String loot) {
        this.recentLootsFound = loot.replace("\u00a7", "&");
    }

    public boolean isRefreshTaskActivated() {
        return this.isRefreshTaskActivated;
    }

    public void setRefreshTaskActivated(boolean arg0) {
        this.isRefreshTaskActivated = arg0;
    }

    public Player getSelectedSendGiftPlayer() {
        return this.selectedSendGiftPlayer;
    }

    public void setSelectedSendGiftPlayer(Player player) {
        this.selectedSendGiftPlayer = player;
    }

    public MysteryVault getSelectedMysteryVault() {
        return this.selectedMysteryVault;
    }

    public void setSelectedMysteryVault(MysteryVault mysteryVault) {
        this.selectedMysteryVault = mysteryVault;
    }

    public MysteryBoxes getSelectedMysteryBox() {
        return this.selectedMysteryBox;
    }

    public void setSelectedMysteryBox(MysteryBoxes mysteryBox) {
        this.selectedMysteryBox = mysteryBox;
    }

    public boolean isOpeningMysteryBox() {
        return this.isOpeningMysteryBox;
    }

    public void setOpeningMysteryBox(boolean arg0) {
        this.isOpeningMysteryBox = arg0;
    }

    public ConfirmOpenMultipleBoxesMenu.OpenMultipleBoxesType getOpenMultipleBoxesType() {
        return this.openType;
    }

    public void setOpenMultipleBoxesType(ConfirmOpenMultipleBoxesMenu.OpenMultipleBoxesType openType) {
        this.openType = openType;
    }

    public HatType getSelectedHat() {
        return this.selectedHat;
    }

    public void setSelectedHat(HatType type) {
        this.selectedHat = type;
    }

    public AnimatedHatType getSelectedAnimatedHat() {
        return this.selectedAnimatedHat;
    }

    public void setSelectedAnimatedHat(AnimatedHatType type) {
        this.selectedAnimatedHat = type;
    }

    public ParticleType getSelectedParticle() {
        return this.selectedParticle;
    }

    public void setSelectedParticle(ParticleType type) {
        this.selectedParticle = type;
    }

    public Map<EnumArmorType, SuitEquipmentType> getSelectedSuitEquipment() {
        return this.selectedSuitEquipment;
    }

    public GadgetCategoryType getSelectedCategoryGadget() {
        return this.selectedCategoryGadget;
    }

    public void setSelectedCategoryGadget(GadgetCategoryType type) {
        this.selectedCategoryGadget = type;
    }

    public GadgetType getSelectedGadget() {
        return this.selectedGadget;
    }

    public void setSelectedGadget(GadgetType type) {
        this.selectedGadget = type;
    }

    public PetCategoryType getSelectedCategoryPet() {
        return this.selectedCategoryPet;
    }

    public void setSelectedCategoryPet(PetCategoryType type) {
        this.selectedCategoryPet = type;
    }

    public PetType getSelectedPet() {
        return this.selectedPet;
    }

    public void setSelectedPet(PetType type) {
        this.selectedPet = type;
    }

    public MorphType getSelectedMorph() {
        return this.selectedMorph;
    }

    public void setSelectedMorph(MorphType type) {
        this.selectedMorph = type;
    }

    public BannerType getSelectedBanner() {
        return this.selectedBanner;
    }

    public void setSelectedBanner(BannerType type) {
        this.selectedBanner = type;
    }

    public EmoteType getSelectedEmote() {
        return this.selectedEmote;
    }

    public void setSelectedEmote(EmoteType type) {
        this.selectedEmote = type;
    }

    public CloakType getSelectedCloak() {
        return this.selectedCloak;
    }

    public void setSelectedCloak(CloakType type) {
        this.selectedCloak = type;
    }

    public AnimatedHat getCurrentAnimatedHat() {
        return this.animatedHat;
    }

    public AnimatedHat setCurrentAnimatedHat(AnimatedHat animatedHat) {
        this.animatedHat = animatedHat;
        return this.animatedHat;
    }

    public void removeAnimatedHat() {
        if (this.animatedHat == null) {
            return;
        }
        this.animatedHat.clear();
        this.animatedHat = null;
    }

    public Suit getCurrentSuit() {
        return this.suit;
    }

    public Suit setCurrentSuit(Suit suit) {
        this.suit = suit;
        return this.suit;
    }

    public void removeSuit() {
        if (this.suit == null) {
            return;
        }
        this.suit.clear();
        this.suit = null;
    }

    public Gadget getCurrentGadget() {
        return this.gadget;
    }

    public Gadget setCurrentGadget(Gadget gadget) {
        this.gadget = gadget;
        return this.gadget;
    }

    public void removeGadget() {
        if (this.gadget == null) {
            return;
        }
        this.gadget.clear();
        this.gadget = null;
    }

    public Pet getCurrentPet() {
        return this.pet;
    }

    public Pet setCurrentPet(Pet pet) {
        this.pet = pet;
        return this.pet;
    }

    public void removePet() {
        if (this.pet == null) {
            return;
        }
        this.pet.clear();
        this.pet = null;
    }

    public Morph getCurrentMorph() {
        return this.morph;
    }

    public Morph setCurrentMorph(Morph morph) {
        this.morph = morph;
        return this.morph;
    }

    public void removeMorph() {
        if (this.morph == null) {
            return;
        }
        this.morph.clear();
        this.morph = null;
    }

    public Emote getCurrentEmote() {
        return this.emote;
    }

    public Emote setCurrentEmote(Emote emote) {
        this.emote = emote;
        return this.emote;
    }

    public void removeEmote() {
        if (this.emote == null) {
            return;
        }
        this.emote.clear();
        this.emote = null;
    }

    public Cloak getCurrentCloak() {
        return this.cloak;
    }

    public Cloak setCurrentCloak(Cloak cloak) {
        this.cloak = cloak;
        return this.cloak;
    }

    public void removeCloak() {
        if (this.cloak == null) {
            return;
        }
        this.cloak.clear();
        this.cloak = null;
    }

    public HashMap<SuitType, Long> suitCooldown() {
        return this.suitCooldown;
    }

    public HashMap<GadgetType, Long> gadgetCooldown() {
        return this.gadgetCooldown;
    }

    public HashMap<MorphType, Long> morphCooldown() {
        return this.morphCooldown;
    }

    public HashMap<EmoteType, Long> emoteCooldown() {
        return this.emoteCooldown;
    }

    public void sendCooldownBar(String displayName, Long cooldown, int maxCooldown) {
        if (this.getPlayer() == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        double currentCooldown = (cooldown - System.currentTimeMillis()) / 1000L;
        int rest = (int)(currentCooldown / (double)maxCooldown * (double)GadgetsMenu.getGadgetsMenuData().getTheAmountOfCooldownBlocks());
        String symbol = GadgetsMenu.getGadgetsMenuData().getRemainCooldownBlock();
        for (int i = 0; i < GadgetsMenu.getGadgetsMenuData().getTheAmountOfCooldownBlocks(); ++i) {
            symbol = GadgetsMenu.getGadgetsMenuData().getRemainCooldownBlock();
            if (i < GadgetsMenu.getGadgetsMenuData().getTheAmountOfCooldownBlocks() - rest) {
                symbol = GadgetsMenu.getGadgetsMenuData().getRetainCooldownBlock();
            }
            stringBuilder.append(ChatUtil.format(symbol));
        }
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator('.');
        otherSymbols.setPatternSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0", otherSymbols);
        String timeLeft = decimalFormat.format((cooldown - System.currentTimeMillis()) / 1000L + 1L);
        this.sendActionMessage(GadgetsMenu.getGadgetsMenuData().getCooldownMessage().replace("{NAME}", displayName).replace("{COOLDOWN_BLOCK}", stringBuilder.toString()).replace("{TIME_LEFT}", timeLeft));
    }

    public void resetCooldownBar() {
        this.sendActionMessage("");
    }

    public void sendActionMessage(String message) {
        GadgetsMenu.getNMSManager().sendActionbarMessage(this.getPlayer(), message);
    }

    public boolean isBlockDamageDisabled() {
        return this.disableBlockDamage;
    }

    public void enableBlockDamage() {
        this.disableBlockDamage = true;
        if (true) {
            this.disableBlockDamage = false;
        }
    }

    public void disableBlockDamage() {
        this.disableBlockDamage = true;
    }

    public boolean isFallDamageDisabled() {
        return this.disableFallDamage;
    }

    public void enableFallDamage() {
        this.disableFallDamage = true;
        if (true) {
            this.disableFallDamage = false;
        }
    }

    public void disableFallDamage() {
        this.disableFallDamage = true;
    }

    public boolean isFireDamageDisabled() {
        return this.disableFireDamage;
    }

    public void enableFireDamage() {
        this.disableFireDamage = true;
        if (true) {
            this.disableFireDamage = false;
        }
    }

    public void disableFireDamage() {
        this.disableFireDamage = true;
    }

    public int getCurrentMenuPageByCategory(Category category) {
        if (category == null) {
            return 1;
        }
        if (category == Category.HATS) {
            return this.currentHatsPage;
        }
        if (category == Category.PARTICLES) {
            return this.currentParticlesPage;
        }
        if (category == Category.GADGETS) {
            return this.currentGadgetsPage;
        }
        if (category == Category.PETS) {
            return this.currentPetsPage;
        }
        if (category == Category.BANNERS) {
            return this.currentBannersPage;
        }
        if (category == Category.EMOTES) {
            return this.currentEmotesPage;
        }
        if (category == Category.CLOAKS || category == Category.SUITS || category == Category.MORPHS) {
            return 1;
        }
        return 1;
    }

    public int getCurrentHatsPage() {
        return this.currentHatsPage;
    }

    public void setCurrentHatsPage(int currentHatsPage) {
        this.currentHatsPage = currentHatsPage;
    }

    public int getCurrentParticlesPage() {
        return this.currentParticlesPage;
    }

    public void setCurrentParticlesPage(int currentParticlesPage) {
        this.currentParticlesPage = currentParticlesPage;
    }

    public int getCurrentGadgetsPage() {
        return this.currentGadgetsPage;
    }

    public void setCurrentGadgetsPage(int currentGadgetsPage) {
        this.currentGadgetsPage = currentGadgetsPage;
    }

    public int getCurrentPetsPage() {
        return this.currentPetsPage;
    }

    public void setCurrentPetsPage(int currentPetsPage) {
        this.currentPetsPage = currentPetsPage;
    }

    public int getCurrentBannersPage() {
        return this.currentBannersPage;
    }

    public void setCurrentBannersPage(int currentBannersPage) {
        this.currentBannersPage = currentBannersPage;
    }

    public int getCurrentEmotesPage() {
        return this.currentEmotesPage;
    }

    public void setCurrentEmotesPage(int currentEmotesPage) {
        this.currentEmotesPage = currentEmotesPage;
    }

    public int getCurrentMysteryVaultPage() {
        return this.currentMysteryVaultPage;
    }

    public void setCurrentMysteryVaultPage(int currentMysteryVaultPage) {
        this.currentMysteryVaultPage = currentMysteryVaultPage;
    }

    public int getCurrentRadioGadgetPage() {
        return this.currentRadioGadgetPage;
    }

    public void setCurrentRadioGadgetPage(int currentRadioGadgetPage) {
        this.currentRadioGadgetPage = currentRadioGadgetPage;
    }

    public int getCurrentGiftInventoryPage() {
        return this.currentGiftInventoryPage;
    }

    public void setCurrentGiftInventoryPage(int currentGiftInventoryPage) {
        this.currentGiftInventoryPage = currentGiftInventoryPage;
    }

    public int getCurrentSendGiftPage() {
        return this.currentSendGiftPage;
    }

    public void setCurrentSendGiftPage(int currentSendGiftPage) {
        this.currentSendGiftPage = currentSendGiftPage;
    }

    public ItemCostDiscount getItemCostDiscount() {
        return this.itemCostDiscount;
    }

    public void setItemCostDiscount(ItemCostDiscount group) {
        this.itemCostDiscount = group;
    }

    public PurchaseData purchaseData() {
        if (this.purchaseData == null) {
            this.purchaseData = new PurchaseData();
            return this.purchaseData;
        }
        return this.purchaseData;
    }

    public boolean resetPurchaseData() {
        if (this.purchaseData == null) {
            return true;
        }
        this.purchaseData.reset();
        return true;
    }

    public BukkitRunnable getParticleRunnableTask() {
        return this.particleRunnableTask;
    }

    public void setParticleRunnableTask(BukkitRunnable runnable) {
        this.particleRunnableTask = runnable;
    }

    public int getUnlockedTotalCosmeticItems() {
        int size = 0;
        size += this.getUnlockedHats();
        size += this.getUnlockedAnimatedHats();
        size += this.getUnlockedParticles();
        size += this.getUnlockedSuits();
        size += this.getUnlockedGadgets();
        size += this.getUnlockedPets();
        size += this.getUnlockedMorphs();
        size += this.getUnlockedBanners();
        size += this.getUnlockedEmotes();
        return size += this.getUnlockedCloaks();
    }

    public int getUnlockedHats() {
        int size = 0;
        for (HatType type : HatType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.HATS.getPermission())) {
            size = HatType.enabled().size();
        }
        return size;
    }

    public int getUnlockedAnimatedHats() {
        int size = 0;
        for (AnimatedHatType type : AnimatedHatType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.ANIMATED_HATS.getPermission())) {
            size = AnimatedHatType.enabled().size();
        }
        return size;
    }

    public int getUnlockedParticles() {
        int size = 0;
        for (ParticleType type : ParticleType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.PARTICLES.getPermission())) {
            size = ParticleType.enabled().size();
        }
        return size;
    }

    public int getUnlockedSuits() {
        int size = 0;
        for (SuitEquipmentType equipment : SuitEquipmentType.values()) {
            SuitType type = SuitType.valueOf(equipment.getGroup());
            if (!type.isEnabled() || !this.getPlayer().hasPermission(equipment.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.SUITS.getPermission())) {
            size = SuitType.enabled().size() * 4;
        }
        return size;
    }

    public int getUnlockedGadgets() {
        int size = 0;
        for (GadgetType type : GadgetType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.GADGETS.getPermission())) {
            size = GadgetType.enabled().size();
        }
        return size;
    }

    public int getUnlockedPets() {
        int size = 0;
        for (PetType type : PetType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.PETS.getPermission())) {
            size = PetType.enabled().size();
        }
        return size;
    }

    public int getUnlockedMorphs() {
        int size = 0;
        for (MorphType type : MorphType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.MORPHS.getPermission())) {
            size = MorphType.enabled().size();
        }
        return size;
    }

    public int getUnlockedBanners() {
        int size = 0;
        for (BannerType type : BannerType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.BANNERS.getPermission())) {
            size = BannerType.enabled().size();
        }
        return size;
    }

    public int getUnlockedEmotes() {
        int size = 0;
        for (EmoteType type : EmoteType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.EMOTES.getPermission())) {
            size = EmoteType.enabled().size();
        }
        return size;
    }

    public int getUnlockedCloaks() {
        int size = 0;
        for (CloakType type : CloakType.enabled()) {
            if (!this.getPlayer().hasPermission(type.getPermission())) continue;
            ++size;
        }
        if (this.getPlayer().hasPermission(EnumPermission.ALL.getPermission()) || this.getPlayer().hasPermission(EnumPermission.CLOAKS.getPermission())) {
            size = CloakType.enabled().size();
        }
        return size;
    }

    public void startMysteryBoxReward() {
        if (this.mysteryBoxesRewardTask != null) {
            return;
        }
        this.mysteryBoxesRewardTask = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            if (this.getPlayer() == null || !this.getPlayer().isOnline() || !GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardEnabled()) {
                this.stopMysteryBoxReward();
                return;
            }
            if (this.mysteryBoxesRewardTask == null) {
                this.stopMysteryBoxReward();
                return;
            }
            if (!WorldUtils.isWorldEnabledForMysteryBoxReward(this.getPlayer().getWorld())) {
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesRewardAllowAFK()) {
                if (!this.isMoving()) {
                    ++this.afkTime;
                } else {
                    this.afkTime = 0;
                    this.setMoving(false);
                }
            }
            if (this.afkTime <= 10) {
                ++this.playTime;
                if ((long)this.playTime >= MysteryBoxesReward.getRewardTimePeriod()) {
                    MysteryBoxesReward.giveRewardIfHaveChance(this.getPlayer());
                    this.playTime = (int)((long)this.playTime - MysteryBoxesReward.getRewardTimePeriod());
                }
            }
        }, 0L, 20L);
    }

    public void stopMysteryBoxReward() {
        if (this.mysteryBoxesRewardTask == null) {
            return;
        }
        try {
            if (this.mysteryBoxesRewardTask.isCancelled()) {
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.mysteryBoxesRewardTask.cancel();
        this.mysteryBoxesRewardTask = null;
    }

    public void loadDatabaseData(int UID, int mysteryDust, int giftPacks, int giftSent, int giftReceived, String petName, boolean canSeeSelfMorph, boolean isBypassCooldown, AnimationType mysteryVaultAnimation, String recentLootsFound) {
        this.UID = UID;
        if (GadgetsMenu.getGadgetsMenuData().getMysteryDustStorage() == GStorage.DEFAULT) {
            this.mysteryDust = mysteryDust;
        }
        this.giftPacks = giftPacks;
        this.giftSent = giftSent;
        this.giftReceived = giftReceived;
        this.petName = petName;
        this.canSeeSelfMorph = canSeeSelfMorph ? EnumCache.ENABLED : EnumCache.DISABLED;
        this.isBypassCooldown = isBypassCooldown ? EnumCache.ENABLED : EnumCache.DISABLED;
        this.mysteryVaultAnimation = mysteryVaultAnimation;
        this.playTime += this.playTime;
        this.recentLootsFound = recentLootsFound;
    }

    public void savePlayerStats(boolean async) {
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> GadgetsMenu.getDatabaseManager().getDatabaseUtils().savePlayerStats(this.getUID(), this.recentLootsFound));
        } else {
            GadgetsMenu.getDatabaseManager().getDatabaseUtils().savePlayerStats(this.getUID(), this.recentLootsFound);
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void setMoving(boolean flag) {
        this.isMoving = flag;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public int getUID() {
        if (this.UID == -1) {
            this.UID = GadgetsMenu.getDatabaseManager().getDatabaseUtils().getUID(this.uuid);
            return this.UID;
        }
        return this.UID;
    }
}

