/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.nms.v1_8_R3;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.holograms.CraftHologram;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.nms.NMSManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.ArmorStandSlot;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.PetUtils;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSEntityBase;
import com.yapzhenyie.GadgetsMenu.nms.v1_8_R3.armorstand.ArmorStandFollower;
import com.yapzhenyie.GadgetsMenu.nms.v1_8_R3.armorstand.EntityNMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.v1_8_R3.entity.EntityUtils;
import com.yapzhenyie.GadgetsMenu.nms.v1_8_R3.pets.Pathfinder;
import com.yapzhenyie.GadgetsMenu.nms.v1_8_R3.pets.PetUtilsImpl;
import com.yapzhenyie.GadgetsMenu.nms.v1_8_R3.pets.PlayerFollower;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import java.lang.reflect.Method;
import net.minecraft.server.v1_8_R3.EntityTypes;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class NMSManagerImpl
implements NMSManager {
    public NMSManagerImpl() {
        try {
            ReflectionUtils.putPrivateFieldMap(EntityTypes.class, EntityNMSArmorStand.class, "d", "ArmorStand");
            ReflectionUtils.putPrivateFieldMap(EntityTypes.class, EntityNMSArmorStand.class, "f", 30);
            ReflectionUtils.putPrivateFieldMap(EntityTypes.class, ArmorStandFollower.class, "d", "ArmorStand");
            ReflectionUtils.putPrivateFieldMap(EntityTypes.class, ArmorStandFollower.class, "f", 30);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removePathfinders(Entity entity) {
        Pathfinder.removePathfinders(entity);
    }

    @Override
    public void followPlayer(Player player, Entity entity, double speed) {
        PlayerFollower.followPlayer(player, entity, speed);
    }

    @Override
    public void makeEntityPanic(Entity entity) {
        EntityUtils.makeEntityPanic(entity);
    }

    @Override
    public PetUtils pet(Entity entity) {
        return new PetUtilsImpl(entity);
    }

    @Override
    public NMSArmorStand spawnNMSArmorStand(org.bukkit.World world, double x, double y, double z, String displayName) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        CraftHologram craftHologram = new CraftHologram(new Location(world, x, y, z));
        EntityNMSArmorStand invisibleArmorStand = new EntityNMSArmorStand((World)nmsWorld, craftHologram);
        invisibleArmorStand.setLocationNMS(x, y, z);
        if (displayName != null && !displayName.isEmpty()) {
            invisibleArmorStand.setCustomNameNMS(ChatUtil.format(displayName));
        }
        craftHologram.setNMSNameable(invisibleArmorStand);
        invisibleArmorStand.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.server.v1_8_R3.Entity)invisibleArmorStand)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn mystery vault hologram!");
        }
        return invisibleArmorStand;
    }

    @Override
    public NMSArmorStand spawnNMSArmorStandFollower(org.bukkit.World world, double x, double y, double z, Player follower, double additionY, String displayName, ArmorStandSlot itemSlot, ItemStack itemStack) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ArmorStandFollower armorStandFollower = new ArmorStandFollower((World)nmsWorld, follower);
        armorStandFollower.setLocationNMS(x, y, z);
        armorStandFollower.setAdditionY(additionY);
        if (itemSlot != null && itemStack != null) {
            armorStandFollower.setSlotNMS(itemSlot.to_1_8_Format(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        }
        if (displayName != null && !displayName.isEmpty()) {
            armorStandFollower.setCustomNameNMS(ChatUtil.format(displayName));
        }
        armorStandFollower.getBukkitEntity().setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        if (!this.addEntityToWorld(nmsWorld, (net.minecraft.server.v1_8_R3.Entity)armorStandFollower)) {
            LoggerManager.printLog(LoggerManager.LogLevel.WARNING, "Could not spawn GadgetsMenu hologram!");
        }
        return armorStandFollower;
    }

    @Override
    public boolean isNMSEntityBase(Entity bukkitEntity) {
        return ((CraftEntity)bukkitEntity).getHandle() instanceof NMSEntityBase;
    }

    @Override
    public NMSEntityBase getNMSEntityBase(Entity bukkitEntity) {
        net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    @Override
    public NMSEntityBase getNMSEntityBaseById(org.bukkit.World world, int entityId) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_8_R3.Entity nmsEntity = nmsWorld.a(entityId);
        if (nmsEntity instanceof NMSEntityBase) {
            return (NMSEntityBase)nmsEntity;
        }
        return null;
    }

    public void registerEntity() {
        ArmorStandFollower.registerEntity();
    }

    private boolean addEntityToWorld(WorldServer nmsWorld, net.minecraft.server.v1_8_R3.Entity nmsEntity) {
        int chunkZ;
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalArgumentException("Async entity add");
        }
        Method validateEntityMethod = null;
        try {
            validateEntityMethod = World.class.getDeclaredMethod("a", net.minecraft.server.v1_8_R3.Entity.class);
            validateEntityMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (validateEntityMethod == null) {
            return nmsWorld.addEntity(nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        }
        int chunkX = MathHelper.floor((double)(nmsEntity.locX / 16.0));
        if (!nmsWorld.chunkProviderServer.isChunkLoaded(chunkX, chunkZ = MathHelper.floor((double)(nmsEntity.locZ / 16.0)))) {
            nmsEntity.dead = true;
            return false;
        }
        nmsWorld.getChunkAt(chunkX, chunkZ).a(nmsEntity);
        nmsWorld.entityList.add(nmsEntity);
        try {
            validateEntityMethod.invoke((Object)nmsWorld, nmsEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

