/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.mysteryboxes.SendGiftMenu;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class GiftInventoryMenu
implements Listener {
    public static void openGiftInventoryMenu(Player player, int page) {
        int size = GadgetsMenu.getPlayerManager(player).getGiftPacks();
        int maxPages = GInventory.getMaxPagesAmount(36, size);
        if (page <= 0) {
            page = 1;
        }
        if (page > 1 && maxPages < page) {
            page = 1;
        }
        Inventory invGift = Bukkit.createInventory(null, (int)54, (String)GadgetsMenu.getGadgetsMenuData().getGiftInventoryGUIName());
        int i = 0;
        int from = 1;
        if (page > 1) {
            from = 36 * (page - 1) + 1;
        }
        int to = 36;
        if (size < 36) {
            to = size;
        }
        if (page > 1) {
            to = size >= 36 * page ? 36 * page : size;
        }
        if (size > 0) {
            for (int h = from; h <= to; ++h) {
                try {
                    if (h <= size) {
                        InventoryUtils.inventory(invGift, EnumItem.MYSTERY_GIFT.getDisplayName(), EnumItem.MYSTERY_GIFT.getMaterial(), 5, EnumItem.MYSTERY_GIFT.getLore(), GInventory.LAY_OUT_36_I.getLayOut()[i++]);
                        continue;
                    }
                    break;
                }
                catch (Exception Ex) {
                    Ex.printStackTrace();
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    return;
                }
            }
        } else {
            InventoryUtils.inventory(invGift, EnumItem.NO_MYSTERY_GIFT_ERROR.getDisplayName(), EnumItem.NO_MYSTERY_GIFT_ERROR.getMaterial(), EnumItem.NO_MYSTERY_GIFT_ERROR.getLore(), EnumItem.NO_MYSTERY_GIFT_ERROR.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invGift, EnumItem.GO_BACK.getItemStack(), 49);
        }
        if (page > 1) {
            InventoryUtils.inventory(invGift, EnumItem.PREVIOUS_PAGE.getItemStack(), "{PAGE}", String.valueOf(page - 1), 45);
        }
        if (page < maxPages) {
            InventoryUtils.inventory(invGift, EnumItem.NEXT_PAGE.getItemStack(), "{PAGE}", String.valueOf(page + 1), 53);
        }
        InventoryUtils.fillItems(invGift);
        player.openInventory(invGift);
        GadgetsMenu.getPlayerManager(player).setCurrentGiftInventoryPage(page);
    }

    @EventHandler
    public void onInvClickGiftInventoryMenu(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(GadgetsMenu.getGadgetsMenuData().getGiftInventoryGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                SoundEffect.ENTITY_ENDERMAN_TELEPORT.playSound(player, 1.0f, 0.5f);
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), 49)) {
                GadgetsMenu.getPlayerManager(player).openMysteryVaultMenu(1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.PREVIOUS_PAGE.getDisplayName(), 45)) {
                GiftInventoryMenu.openGiftInventoryMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentGiftInventoryPage() - 1);
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.NEXT_PAGE.getDisplayName(), 53)) {
                GiftInventoryMenu.openGiftInventoryMenu(player, GadgetsMenu.getPlayerManager(player).getCurrentGiftInventoryPage() + 1);
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(EnumItem.MYSTERY_GIFT.getDisplayName()))) {
                for (int slot : GInventory.LAY_OUT_36_I.getLayOut()) {
                    if (!ItemUtils.getCurrentItem(event, slot)) continue;
                    SendGiftMenu.openSendGiftMenu(player, 1);
                    event.setCancelled(true);
                    return;
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

