/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.menu.menus;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.api.GadgetsMenuAPI;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.CloakType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumItem;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.GInventory;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.WorldUtils;
import com.yapzhenyie.GadgetsMenu.utils.discount.DiscountManager;
import com.yapzhenyie.GadgetsMenu.utils.discount.ItemCostDiscount;
import com.yapzhenyie.GadgetsMenu.utils.items.InventoryUtils;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class CloaksMenu
implements Listener {
    public static void openCloaksMenu(Player player) {
        int size = CloakType.enabled().size();
        Inventory invCloaks = Bukkit.createInventory(null, (int)54, (String)ChatUtil.format(Category.CLOAKS.getGUIName()));
        int i = 0;
        int from = 1;
        int to = 21;
        if (size < 21) {
            to = size;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        for (int h = from; h <= to; ++h) {
            try {
                if (h > size) break;
                CloakType cloaks = CloakType.enabled().get(h - 1);
                if (PermissionUtils.noPermission(player, cloaks.getPermission(), EnumPermission.CLOAKS.getPermission(), false)) {
                    DiscountManager discountManager = new DiscountManager(pManager, Category.CLOAKS.isPurchasable() && cloaks.isPurchasable(), cloaks.getMysteryDust());
                    if (EnumItem.NO_PERMISSION.showCustomItem()) {
                        InventoryUtils.inventory(invCloaks, cloaks.getDisplayName(), EnumItem.NO_PERMISSION.getCustomItem(), cloaks.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                        continue;
                    }
                    InventoryUtils.inventory(invCloaks, cloaks.getDisplayName(), cloaks.getMaterial(), cloaks.getLore(), EnumItem.NO_PERMISSION.isShowInLore() ? EnumItem.NO_PERMISSION.getLore() : null, discountManager.getLore(), GInventory.LAY_OUT_21.getLayOut()[i++]);
                    continue;
                }
                InventoryUtils.inventoryAddGlow(invCloaks, cloaks.getDisplayName(), cloaks.getMaterial(), cloaks.getLore(), EnumItem.HAS_PERMISSION.isShowInLore() ? EnumItem.HAS_PERMISSION.getLore() : null, GInventory.LAY_OUT_21.getLayOut()[i++], pManager.getSelectedCloak() == null ? null : pManager.getSelectedCloak().getDisplayName());
                continue;
            }
            catch (Exception Ex) {
                player.sendMessage(MessageType.ERROR.getFormatMessage());
                Ex.printStackTrace();
                return;
            }
        }
        if (EnumItem.RESET_CLOAK.show()) {
            InventoryUtils.inventory(invCloaks, EnumItem.RESET_CLOAK.getItemStack(), EnumItem.RESET_CLOAK.getSlot());
        }
        if (EnumItem.GO_BACK.show()) {
            InventoryUtils.inventory(invCloaks, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot());
        }
        if (EnumItem.MAIN_MENU_ITEM.show()) {
            InventoryUtils.mainMenuButton(pManager, invCloaks, EnumItem.MAIN_MENU_ITEM.getSlot());
        }
        InventoryUtils.fillItems(invCloaks);
        player.openInventory(invCloaks);
    }

    @EventHandler
    public void onInvClickCloaks(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().equals(Category.CLOAKS.getGUIName())) {
            if (event.getClickedInventory() == null || event.getClickedInventory().getSize() != 54 || event.getClickedInventory().getType() != InventoryType.CHEST) {
                event.setCancelled(true);
                return;
            }
            if (!Category.CLOAKS.isEnabled() || !WorldUtils.isWorldEnabled(player, true)) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || event.getCurrentItem().getItemMeta().getDisplayName() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT || event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.UNKNOWN) {
                player.updateInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.GO_BACK.getItemStack(), EnumItem.GO_BACK.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (ItemUtils.getCurrentItem(event, EnumItem.RESET_CLOAK.getItemStack(), EnumItem.RESET_CLOAK.getSlot())) {
                pManager.unequipCloak();
                player.sendMessage(MessageType.RESET_CLOAK.getFormatMessage());
                if (EnumItem.RESET_CLOAK.isPlaySoundEnabled()) {
                    EnumItem.RESET_CLOAK.getSound().playSound(player, 1.0f, 2.0f);
                }
                player.closeInventory();
                event.setCancelled(true);
                return;
            }
            if (ItemUtils.getCurrentItem(event, EnumItem.MAIN_MENU_ITEM.getDisplayName(), EnumItem.MAIN_MENU_ITEM.getSlot())) {
                GadgetsMenuAPI.goBackToMainMenu(player);
                event.setCancelled(true);
                return;
            }
            for (CloakType cloak : CloakType.values()) {
                if (!event.getCurrentItem().getItemMeta().getDisplayName().equals(ChatUtil.format(cloak.getDisplayName()))) continue;
                if (PermissionUtils.noPermission(player, cloak.getPermission(), EnumPermission.CLOAKS.getPermission(), false)) {
                    if (Category.CLOAKS.isPurchasable()) {
                        if (!cloak.isPurchasable()) {
                            player.sendMessage(MessageType.ITEM_UNPURCHASABLE.getFormatMessage());
                            if (EnumItem.ITEM_UNPURCHASABLE.isPlaySoundEnabled()) {
                                EnumItem.ITEM_UNPURCHASABLE.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                            event.setCancelled(true);
                            return;
                        }
                        ItemCostDiscount discount = pManager.getItemCostDiscount();
                        int discountedPrice = cloak.getMysteryDust();
                        if (discount != null) {
                            discountedPrice = discount.getPriceAfterDiscount(cloak.getMysteryDust());
                        }
                        if (pManager.getMysteryDust() >= discountedPrice) {
                            pManager.purchaseData().setData(Category.CLOAKS, cloak.getName(), cloak.getDisplayName(), discount, cloak.getMysteryDust(), cloak.getPermission());
                            pManager.openItemPurchaseMenu();
                        } else {
                            player.sendMessage(MessageType.NOT_ENOUGH_MYSTERY_DUST_TO_PURCHASE.getFormatMessage());
                            if (EnumItem.NOT_ENOUGH_MYSTERY_DUST.isPlaySoundEnabled()) {
                                EnumItem.NOT_ENOUGH_MYSTERY_DUST.getSound().playSound(player, 1.0f, 0.5f);
                            }
                            player.closeInventory();
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (!PermissionUtils.noPermission(player, cloak.getPermission(), EnumPermission.CLOAKS.getPermission(), true)) continue;
                    if (EnumItem.NO_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.NO_PERMISSION.getSound().playSound(player, 1.0f, 0.5f);
                    }
                    if (EnumItem.NO_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    }
                    event.setCancelled(true);
                    return;
                }
                try {
                    if (pManager.getSelectedCloak() != null && ChatUtil.format(cloak.getDisplayName()).equals(pManager.getSelectedCloak().getDisplayName())) {
                        pManager.unequipCloak();
                        player.sendMessage(MessageType.RESET_CLOAK.getFormatMessage());
                        if (EnumItem.RESET_CLOAK.isPlaySoundEnabled()) {
                            EnumItem.RESET_CLOAK.getSound().playSound(player, 1.0f, 2.0f);
                        }
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    if (!CloakManager.checkRequirement(player, cloak)) {
                        player.closeInventory();
                        event.setCancelled(true);
                        return;
                    }
                    pManager.equipCloak(cloak);
                    player.sendMessage(MessageType.SELECT_CLOAK.getFormatMessage().replace("{CLOAK}", cloak.getDisplayNameStripColor()));
                    if (EnumItem.HAS_PERMISSION.isPlaySoundEnabled()) {
                        EnumItem.HAS_PERMISSION.getSound().playSound(player, 1.0f, 2.0f);
                    }
                    if (EnumItem.HAS_PERMISSION.isCloseGUIMenuAfterSelect()) {
                        player.closeInventory();
                    } else {
                        CloaksMenu.openCloaksMenu(player);
                    }
                    event.setCancelled(true);
                    return;
                }
                catch (Exception Ex) {
                    player.sendMessage(MessageType.ERROR.getFormatMessage());
                    Ex.printStackTrace();
                }
            }
            event.setCancelled(true);
            return;
        }
    }
}

