/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.hook.protocollib.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.collect.Lists;
import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.holograms.CraftHologram;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.ProtocolLibHook;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.packets.EntityPacketWrapper;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.packets.WrapperPlayServerEntityDestroy;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.packets.WrapperPlayServerEntityMetadata;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.packets.WrapperPlayServerSpawnEntity;
import com.yapzhenyie.GadgetsMenu.hook.protocollib.packets.WrapperPlayServerSpawnEntityLiving;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.nms.NMSManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSArmorStand;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSEntityBase;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.MysteryVaultManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProtocolLibHookImpl
implements ProtocolLibHook {
    private NMSManager nmsManager;
    private WrappedDataWatcher.Serializer byteSerializer;
    private WrappedDataWatcher.Serializer stringSerializer;
    private WrappedDataWatcher.Serializer booleanSerializer;
    private WrappedDataWatcher.Serializer chatComponentSerializer;
    private int customNameWatcherIndex;
    private boolean outdatedVersion = false;

    @Override
    public boolean hook(Plugin plugin, NMSManager nmsManager) {
        PacketType[] packetTypeArray;
        String version = Bukkit.getPluginManager().getPlugin("ProtocolLib").getDescription().getVersion();
        if (version.startsWith("3.7-SNAPSHOT")) {
            LoggerManager.warn("Detected development version of ProtocolLib, mystery boxes individual hologram support disabled.Please update ProtocolLib.");
            return false;
        }
        this.nmsManager = nmsManager;
        this.customNameWatcherIndex = 2;
        if (VersionManager.is1_9OrAbove()) {
            this.byteSerializer = WrappedDataWatcher.Registry.get(Byte.class);
            this.stringSerializer = WrappedDataWatcher.Registry.get(String.class);
            this.booleanSerializer = WrappedDataWatcher.Registry.get(Boolean.class);
        }
        if (VersionManager.is1_13OrAbove()) {
            this.chatComponentSerializer = WrappedDataWatcher.Registry.get((Class)MinecraftReflection.getIChatBaseComponentClass(), (boolean)true);
        }
        PacketAdapter.AdapterParameteters adapterParameteters = PacketAdapter.params().plugin(plugin);
        if (VersionManager.is1_19OrAbove()) {
            PacketType[] packetTypeArray2 = new PacketType[2];
            packetTypeArray2[0] = PacketType.Play.Server.SPAWN_ENTITY;
            packetTypeArray = packetTypeArray2;
            packetTypeArray2[1] = PacketType.Play.Server.ENTITY_METADATA;
        } else {
            PacketType[] packetTypeArray3 = new PacketType[3];
            packetTypeArray3[0] = PacketType.Play.Server.SPAWN_ENTITY_LIVING;
            packetTypeArray3[1] = PacketType.Play.Server.SPAWN_ENTITY;
            packetTypeArray = packetTypeArray3;
            packetTypeArray3[2] = PacketType.Play.Server.ENTITY_METADATA;
        }
        PacketAdapter.AdapterParameteters params = adapterParameteters.types(packetTypeArray).serverSide().listenerPriority(ListenerPriority.NORMAL).options(new ListenerOptions[]{ListenerOptions.ASYNC});
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter(params){

            public void onPacketSending(PacketEvent event) {
                if (!ProtocolLibHookImpl.this.outdatedVersion) {
                    try {
                        if (event.isPlayerTemporary()) {
                            return;
                        }
                    }
                    catch (NoSuchMethodError e) {
                        ProtocolLibHookImpl.this.outdatedVersion = true;
                    }
                }
                PacketContainer packet = event.getPacket();
                Player player = event.getPlayer();
                if (ProtocolLibHookImpl.this.outdatedVersion) {
                    try {
                        if (Class.forName("com.comphenix.net.sf.cglib.proxy.Factory").isInstance(player)) {
                            return;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (packet.getType() == PacketType.Play.Server.SPAWN_ENTITY_LIVING) {
                    String customName;
                    WrapperPlayServerSpawnEntityLiving spawnEntityPacket = new WrapperPlayServerSpawnEntityLiving(packet);
                    if (!ProtocolLibHookImpl.this.isHologram(event, spawnEntityPacket)) {
                        return;
                    }
                    CraftHologram hologram = ProtocolLibHookImpl.this.getEntity(event, spawnEntityPacket);
                    if (hologram == null) {
                        return;
                    }
                    if (!hologram.getVisibilityManager().isVisibleTo(player)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (VersionManager.is1_15OrAbove()) {
                        return;
                    }
                    WrappedWatchableObject customNameWatchableObject = spawnEntityPacket.getMetadata().getWatchableObject(ProtocolLibHookImpl.this.customNameWatcherIndex);
                    if (customNameWatchableObject == null || !(customNameWatchableObject.getValue() instanceof String)) {
                        return;
                    }
                    Object customNameObject = customNameWatchableObject.getValue();
                    if (VersionManager.is1_13OrAbove()) {
                        if (!(customNameObject instanceof Optional)) {
                            return;
                        }
                        Optional customNameOptional = (Optional)customNameObject;
                        if (!customNameOptional.isPresent()) {
                            return;
                        }
                        WrappedChatComponent componentWrapper = WrappedChatComponent.fromHandle(customNameOptional.get());
                        customName = componentWrapper.getJson();
                    } else {
                        if (!(customNameObject instanceof String)) {
                            return;
                        }
                        customName = (String)customNameObject;
                    }
                    if (customName.contains("{MYSTERY_BOXES}") || customName.contains("{MYSTERY_DUST}")) {
                        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
                        if (pManager == null) {
                            return;
                        }
                        String replacement = customName.replace("{MYSTERY_BOXES}", String.valueOf(pManager.getMysteryBoxes())).replace("{MYSTERY_DUST}", String.valueOf(pManager.getMysteryDust()));
                        if (pManager.getMysteryBoxes() == 0) {
                            replacement = VersionManager.is1_13OrAbove() ? "{\"text\":\"" + MysteryVaultManager.getZeroMysteryBoxAvailableHologram() + "\"}" : MysteryVaultManager.getZeroMysteryBoxAvailableHologram();
                        }
                        if (!pManager.isLoaded() || pManager.isOpeningMysteryBox()) {
                            replacement = ChatUtil.format("&c");
                        }
                        WrappedWatchableObject newWatchableObject = VersionManager.is1_13OrAbove() ? new WrappedWatchableObject(customNameWatchableObject.getWatcherObject(), Optional.of(WrappedChatComponent.fromJson((String)replacement).getHandle())) : (VersionManager.is1_9OrAbove() ? new WrappedWatchableObject(customNameWatchableObject.getWatcherObject(), (Object)replacement) : new WrappedWatchableObject(customNameWatchableObject.getIndex(), (Object)replacement));
                        customNameWatchableObject.setValue(newWatchableObject.getValue());
                    }
                } else if (packet.getType() == PacketType.Play.Server.SPAWN_ENTITY) {
                    WrapperPlayServerSpawnEntity spawnEntityPacket = new WrapperPlayServerSpawnEntity(packet);
                    if (!ProtocolLibHookImpl.this.isHologram(event, spawnEntityPacket)) {
                        return;
                    }
                    CraftHologram hologram = ProtocolLibHookImpl.this.getEntity(event, spawnEntityPacket);
                    if (hologram == null) {
                        return;
                    }
                    if (!hologram.getVisibilityManager().isVisibleTo(player)) {
                        event.setCancelled(true);
                        return;
                    }
                } else if (packet.getType() == PacketType.Play.Server.ENTITY_METADATA) {
                    WrapperPlayServerEntityMetadata entityMetadataPacket = new WrapperPlayServerEntityMetadata(packet);
                    if (!ProtocolLibHookImpl.this.isHologram(event, entityMetadataPacket)) {
                        return;
                    }
                    CraftHologram hologram = ProtocolLibHookImpl.this.getEntity(event, entityMetadataPacket);
                    if (hologram == null) {
                        return;
                    }
                    if (!hologram.getVisibilityManager().isVisibleTo(player)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (VersionManager.isVersionGreaterEqual(VersionManager.getMinecraftVersion(), "1.19.3")) {
                        Entity entity = (Entity)packet.getEntityModifier(event).read(0);
                        WrappedDataWatcher dataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)entity).deepClone();
                        WrappedWatchableObject watchableObject = dataWatcher.getWatchableObject(ProtocolLibHookImpl.this.customNameWatcherIndex);
                        ProtocolLibHookImpl.this.updateWatchableObject(event, packet, player, watchableObject, null, 0, dataWatcher);
                    } else {
                        List<WrappedWatchableObject> dataWatcherValues = entityMetadataPacket.getEntityMetadata();
                        if (dataWatcherValues == null) {
                            return;
                        }
                        for (int i = 0; i < dataWatcherValues.size(); ++i) {
                            WrappedWatchableObject watchableObject = dataWatcherValues.get(i);
                            if (watchableObject.getIndex() != ProtocolLibHookImpl.this.customNameWatcherIndex) continue;
                            ProtocolLibHookImpl.this.updateWatchableObject(event, packet, player, watchableObject, dataWatcherValues, i, null);
                        }
                    }
                }
            }
        });
        return true;
    }

    @Override
    public void sendDestroyEntitiesPacket(Player player, CraftHologram hologram) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int id : new int[]{hologram.getNMSNameable().getIdNMS()}) {
            ids.add(id);
        }
        if (!ids.isEmpty()) {
            WrapperPlayServerEntityDestroy packet = new WrapperPlayServerEntityDestroy();
            packet.setEntities(ids);
            packet.sendPacket(player);
        }
    }

    @Override
    public void sendCreateEntitiesPacket(Player player, CraftHologram hologram) {
        if (!hologram.getNMSNameable().isDeadNMS() || !hologram.getVisibilityManager().isVisibleTo(player)) {
            this.sendSpawnArmorStandPacket(player, (NMSArmorStand)hologram.getNMSNameable());
        }
    }

    private void sendSpawnArmorStandPacket(Player receiver, NMSArmorStand armorStand) {
        if (VersionManager.is1_11OrAbove()) {
            WrapperPlayServerSpawnEntity spawnPacket = new WrapperPlayServerSpawnEntity(armorStand.getBukkitEntityNMS(), 78, 1);
            spawnPacket.sendPacket(receiver);
            WrapperPlayServerEntityMetadata dataPacket = new WrapperPlayServerEntityMetadata();
            WrappedDataWatcher dataWatcher = new WrappedDataWatcher();
            dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, this.byteSerializer), (Object)32);
            String customName = armorStand.getCustomNameNMS();
            if (customName != null && !customName.isEmpty()) {
                if (VersionManager.is1_13OrAbove()) {
                    dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(this.customNameWatcherIndex, this.chatComponentSerializer), Optional.of(WrappedChatComponent.fromText((String)customName).getHandle()));
                } else {
                    dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(this.customNameWatcherIndex, this.stringSerializer), (Object)customName);
                }
                dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, this.booleanSerializer), (Object)true);
            }
            dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(5, this.booleanSerializer), (Object)true);
            dataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(11, this.byteSerializer), (Object)25);
            if (VersionManager.isVersionGreaterEqual(VersionManager.getMinecraftVersion(), "1.19.3")) {
                ArrayList wrappedDataValueList = Lists.newArrayList();
                dataWatcher.getWatchableObjects().stream().filter(Objects::nonNull).forEach(entry -> {
                    WrappedDataWatcher.WrappedDataWatcherObject dataWatcherObject = entry.getWatcherObject();
                    wrappedDataValueList.add(new WrappedDataValue(dataWatcherObject.getIndex(), dataWatcherObject.getSerializer(), entry.getRawValue()));
                });
                dataPacket.getDataValueCollectionModifier().write(0, (Object)wrappedDataValueList);
            } else {
                dataPacket.setEntityMetadata(dataWatcher.getWatchableObjects());
            }
            dataPacket.setEntityId(armorStand.getIdNMS());
            dataPacket.sendPacket(receiver);
        } else {
            WrapperPlayServerSpawnEntityLiving spawnPacket = new WrapperPlayServerSpawnEntityLiving(armorStand.getBukkitEntityNMS());
            System.out.println(armorStand.getBukkitEntityNMS().getCustomName());
            spawnPacket.sendPacket(receiver);
        }
    }

    private void updateWatchableObject(PacketEvent event, PacketContainer packet, Player player, WrappedWatchableObject watchableObject, List<WrappedWatchableObject> dataWatcherValues, int index, WrappedDataWatcher dataWatcher) {
        String customName;
        Object customNameObject = watchableObject.getValue();
        if (VersionManager.is1_13OrAbove()) {
            if (!(customNameObject instanceof Optional)) {
                return;
            }
            Optional customNameOptional = (Optional)customNameObject;
            if (!customNameOptional.isPresent()) {
                return;
            }
            WrappedChatComponent componentWrapper = customNameOptional.get() instanceof WrappedChatComponent ? (WrappedChatComponent)customNameOptional.get() : WrappedChatComponent.fromHandle(customNameOptional.get());
            customName = componentWrapper.getJson();
        } else {
            if (!(customNameObject instanceof String)) {
                return;
            }
            customName = (String)customNameObject;
        }
        if (customName.contains("{MYSTERY_BOXES}") || customName.contains("{MYSTERY_DUST}")) {
            PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
            if (pManager == null) {
                return;
            }
            String replacement = customName.replace("{MYSTERY_BOXES}", String.valueOf(pManager.getMysteryBoxes())).replace("{MYSTERY_DUST}", String.valueOf(pManager.getMysteryDust()));
            if (pManager.getMysteryBoxes() == 0) {
                replacement = VersionManager.is1_13OrAbove() ? "{\"text\":\"" + MysteryVaultManager.getZeroMysteryBoxAvailableHologram() + "\"}" : MysteryVaultManager.getZeroMysteryBoxAvailableHologram();
            }
            if (!pManager.isLoaded() || pManager.isOpeningMysteryBox()) {
                replacement = ChatUtil.format("&c");
            }
            WrappedWatchableObject newWatchableObject = VersionManager.is1_13OrAbove() ? new WrappedWatchableObject(watchableObject.getWatcherObject(), Optional.of(WrappedChatComponent.fromJson((String)replacement).getHandle())) : (VersionManager.is1_9OrAbove() ? new WrappedWatchableObject(watchableObject.getWatcherObject(), (Object)replacement) : new WrappedWatchableObject(watchableObject.getIndex(), (Object)replacement));
            if (VersionManager.isVersionGreaterEqual(VersionManager.getMinecraftVersion(), "1.19.3")) {
                dataWatcher.setObject(this.customNameWatcherIndex, newWatchableObject);
                ArrayList wrappedDataValueList = Lists.newArrayList();
                dataWatcher.getWatchableObjects().stream().filter(Objects::nonNull).forEach(entry -> {
                    WrappedDataWatcher.WrappedDataWatcherObject dataWatcherObject = entry.getWatcherObject();
                    wrappedDataValueList.add(new WrappedDataValue(dataWatcherObject.getIndex(), dataWatcherObject.getSerializer(), entry.getRawValue()));
                });
                packet.getDataValueCollectionModifier().write(0, (Object)wrappedDataValueList);
                event.setPacket(packet);
            } else {
                dataWatcherValues.set(index, newWatchableObject);
                PacketContainer clone = packet.shallowClone();
                clone.getWatchableCollectionModifier().write(0, dataWatcherValues);
                event.setPacket(clone);
            }
        }
    }

    private boolean isHologram(PacketEvent event, EntityPacketWrapper entityPacketWrapper) {
        try {
            Entity entity = entityPacketWrapper.getEntity(event);
            return entity != null && entity.getType() == EntityType.ARMOR_STAND;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private CraftHologram getHologram(World world, int entityId) {
        NMSEntityBase entity = this.nmsManager.getNMSEntityBaseById(world, entityId);
        if (entity != null) {
            return entity.getHologram();
        }
        return null;
    }

    private CraftHologram getEntity(PacketEvent event, EntityPacketWrapper entityPacketWrapper) {
        return this.getHologram(event.getPlayer().getWorld(), entityPacketWrapper.getEntityId());
    }
}

