/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.hook.protocollib.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.base.Objects;
import java.lang.reflect.Method;
import org.bukkit.entity.Player;

public abstract class AbstractPacket {
    private static boolean isNewVersion = true;
    protected PacketContainer handle;

    protected AbstractPacket(PacketContainer handle, PacketType type) {
        if (handle == null) {
            throw new IllegalArgumentException("Packet handle cannot be NULL.");
        }
        if (!Objects.equal((Object)handle.getType(), (Object)type)) {
            throw new IllegalArgumentException(handle.getHandle() + " is not a packet of type " + type);
        }
        this.handle = handle;
    }

    public PacketContainer getHandle() {
        return this.handle;
    }

    public void sendPacket(Player receiver) {
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(receiver, this.getHandle());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot send packet.", e);
        }
    }

    public void receivePacket(Player sender) {
        try {
            if (isNewVersion) {
                ProtocolLibrary.getProtocolManager().receiveClientPacket(sender, this.getHandle());
            } else {
                Method receivePacketMethod = ProtocolLibrary.getProtocolManager().getClass().getDeclaredMethod("recieveClientPacket", Player.class, PacketContainer.class);
                receivePacketMethod.setAccessible(true);
                receivePacketMethod.invoke(null, sender, this.getHandle());
            }
        }
        catch (NoSuchMethodError e) {
            isNewVersion = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot receive packet.", e);
        }
    }
}

