/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.holograms;

import com.yapzhenyie.GadgetsMenu.holograms.CraftVisibilityManager;
import com.yapzhenyie.GadgetsMenu.nms.interfaces.entity.NMSNameable;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class CraftHologram {
    private World world;
    private double x;
    private double y;
    private double z;
    private int chunkX;
    private int chunkZ;
    private NMSNameable nmsNameable;
    private CraftVisibilityManager visibilityManager;

    public CraftHologram(Location location) {
        this.updateLocation(location.getWorld(), location.getX(), location.getY(), location.getZ());
        this.visibilityManager = new CraftVisibilityManager(this);
    }

    public boolean isInChunk(Chunk chunk) {
        return chunk.getX() == this.chunkX && chunk.getZ() == this.chunkZ;
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Location getLocation() {
        return new Location(this.world, this.x, this.y, this.z);
    }

    public NMSNameable getNMSNameable() {
        return this.nmsNameable;
    }

    public void setNMSNameable(NMSNameable arg0) {
        this.nmsNameable = arg0;
    }

    private void updateLocation(World world, double x, double y, double z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.chunkX = MathUtil.floor(x) >> 4;
        this.chunkZ = MathUtil.floor(z) >> 4;
    }

    public CraftVisibilityManager getVisibilityManager() {
        return this.visibilityManager;
    }
}

