/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.database.sqlite;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.database.DatabaseConnection;
import com.yapzhenyie.GadgetsMenu.database.DatabaseManager;
import com.yapzhenyie.GadgetsMenu.database.DatabaseUtils;
import com.yapzhenyie.GadgetsMenu.database.Table;
import com.yapzhenyie.GadgetsMenu.database.sqlite.SQLiteConnection;
import com.yapzhenyie.GadgetsMenu.database.sqlite.SQLiteUtils;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SQLiteManager
implements DatabaseManager {
    private DatabaseConnection dbConnection;
    private Connection connection;
    private DatabaseUtils sqliteUtils;
    private Table table;
    private Table mysteryBoxesTable;
    public String tableName = "GadgetsMenu_Data";
    public String mysteryBoxesTableName = "GadgetsMenu_Mystery_Boxes";
    private int reconnectTimes = 5;

    @Override
    public void init() {
        this.sqliteUtils = new SQLiteUtils(this);
        try {
            if (this.dbConnection != null) {
                this.dbConnection.closeConnection();
            }
            this.dbConnection = new SQLiteConnection();
            LoggerManager.info(MessageType.CONNECTING_TO_DATABASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            this.connection = this.dbConnection.openConnection();
            PreparedStatement tables = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.tableName + "(id INTEGER PRIMARY KEY AUTOINCREMENT, UUID VARCHAR(36) NOT NULL, Name VARCHAR(255) NOT NULL, Mystery_Dust INTEGER DEFAULT 0 NOT NULL, Mystery_Gift_Packs INTEGER DEFAULT 0 NOT NULL, Mystery_Gift_Sent INTEGER DEFAULT 0 NOT NULL, Mystery_Gift_Received INTEGER DEFAULT 0 NOT NULL, Pet_Name VARCHAR(255) DEFAULT 'Pet' NOT NULL, Self_Morph_View VARCHAR(5) DEFAULT 'true' NOT NULL, Bypass_Cooldown VARCHAR(5) DEFAULT 'false' NOT NULL, Mystery_Vault_Animation VARCHAR(255) DEFAULT 'Normal' NOT NULL, Recent_Loots_Found VARCHAR(255) DEFAULT '' NOT NULL, Selected_Hat VARCHAR(255) DEFAULT 'none' not NULL, Selected_Animated_Hat VARCHAR(255) DEFAULT 'none' not NULL, Selected_Particle VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Helmet VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Chestplate VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Leggings VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Boots VARCHAR(255) DEFAULT 'none' not NULL, Selected_Gadget VARCHAR(255) DEFAULT 'none' not NULL, Selected_Pet VARCHAR(255) DEFAULT 'none' not NULL, Selected_Morph VARCHAR(255) DEFAULT 'none' not NULL, Selected_Banner VARCHAR(255) DEFAULT 'none' not NULL, Selected_Emote VARCHAR(255) DEFAULT 'none' not NULL, Selected_Cloak VARCHAR(255) DEFAULT 'none' not NULL)");
            tables.executeUpdate();
            this.table = new Table(this.connection, this.tableName);
            tables = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.mysteryBoxesTableName + "(id INTEGER PRIMARY KEY AUTOINCREMENT, UUID VARCHAR(36) NOT NULL, UID INTEGER NOT NULL, Loots VARCHAR(2000) NOT NULL)");
            tables.executeUpdate();
            this.mysteryBoxesTable = new Table(this.connection, this.mysteryBoxesTableName);
            tables.close();
            LoggerManager.info(MessageType.SUCCESSFULLY_CONNECTED_TO_DATABASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            if (this.reconnectTimes < 5) {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
                    if (this.reconnectTimes < 5) {
                        ++this.reconnectTimes;
                    }
                }, 6000L);
            }
        }
        catch (Exception e) {
            LoggerManager.info("--------------------------------------------------");
            LoggerManager.consoleMessage(ChatUtil.format("&c&l" + MessageType.FAILED_TO_CONNECT_TO_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName())));
            LoggerManager.info("--------------------------------------------------");
            e.printStackTrace();
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)GadgetsMenu.getInstance());
        }
    }

    @Override
    public synchronized void reconnect() {
        try {
            if ((this.connection == null || this.connection.isClosed()) && GadgetsMenu.getInstance() != null) {
                if (this.reconnectTimes <= 0) {
                    LoggerManager.printLogWithHeader(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.DATABASE_RECONNECTION_IS_TOO_FREQUENT.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
                    return;
                }
                this.init();
                --this.reconnectTimes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DatabaseConnection getDBConnection() {
        return this.dbConnection;
    }

    @Override
    public Connection getConnection() {
        this.reconnect();
        return this.connection;
    }

    @Override
    public Table getTable() {
        this.reconnect();
        return this.table;
    }

    @Override
    public Table getMysteryBoxesTable() {
        this.reconnect();
        return this.mysteryBoxesTable;
    }

    @Override
    public DatabaseUtils getDatabaseUtils() {
        return this.sqliteUtils;
    }
}

