/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.database.sqlite;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.database.DatabaseConnection;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SQLiteConnection
implements DatabaseConnection {
    private Connection connection;

    @Override
    public Connection openConnection() throws Exception {
        if (!GadgetsMenu.getInstance().getDataFolder().exists()) {
            GadgetsMenu.getInstance().getDataFolder().mkdir();
        }
        File file = new File(GadgetsMenu.getInstance().getDataFolder(), "/database.db");
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + file);
        return this.connection;
    }

    @Override
    public boolean checkConnection() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.FAILED_TO_CONNECT_TO_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isClosed() {
        if (this.connection == null) {
            return true;
        }
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.FAILED_TO_CLOSE_THE_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean closeConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.close();
            LoggerManager.info(MessageType.DATABASE_CONNECTION_IS_CLOSED.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
        }
        catch (SQLException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.FAILED_TO_CLOSE_THE_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            e.printStackTrace();
        }
        return true;
    }
}

