/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.database.mysql;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.database.DatabaseUtils;
import com.yapzhenyie.GadgetsMenu.database.mysql.MySQLManager;
import com.yapzhenyie.GadgetsMenu.database.query.SelectQuery;
import com.yapzhenyie.GadgetsMenu.mysteryboxes.MysteryBoxes;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.mysteryvault.animations.AnimationType;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class MySQLUtils
extends DatabaseUtils {
    private MySQLManager mySQLManager;

    public MySQLUtils(MySQLManager mySQLManager) {
        super(mySQLManager);
        this.mySQLManager = mySQLManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initPlayerStats(PlayerManager pManager) {
        if (pManager == null) {
            return;
        }
        if (this.mySQLManager.getConnection() == null) {
            return;
        }
        SelectQuery sQuery = null;
        ResultSet rs = null;
        try {
            String uuid = pManager.getUUID().toString();
            String playername = pManager.getName();
            sQuery = this.mySQLManager.getTable().select().where("UUID", uuid);
            rs = sQuery.execute();
            if (!rs.next()) {
                this.mySQLManager.getTable().insert().insert("UUID, Name, Mystery_Dust").value(uuid).value(playername).value(GadgetsMenu.getGadgetsMenuData().getDefaultMysteryDust()).execute();
                this.mySQLManager.getTable().update().set("Pet_Name", ChatUtil.format(GadgetsMenu.getGadgetsMenuData().getDefaultPetName()).replace("{PLAYER}", playername)).where("UUID", uuid).execute();
            } else {
                ResultSet res = null;
                SelectQuery selectQuery = this.mySQLManager.getTable().select().where("UUID", uuid);
                res = selectQuery.execute();
                res.first();
                int uid = res.getInt("id");
                String s = res.getString("Name");
                int mysteryDust = res.getInt("Mystery_Dust");
                int giftPacks = res.getInt("Mystery_Gift_Packs");
                int giftSent = res.getInt("Mystery_Gift_Sent");
                int giftReceived = res.getInt("Mystery_Gift_Received");
                String petName = res.getString("Pet_Name");
                boolean selfMorphView = res.getBoolean("Self_Morph_View");
                boolean bypassCooldown = res.getBoolean("Bypass_Cooldown");
                AnimationType animation = AnimationType.valueOf(res.getString("Mystery_Vault_Animation"));
                String recentLootsFound = res.getString("Recent_Loots_Found");
                pManager.loadDatabaseData(uid, mysteryDust, giftPacks, giftSent, giftReceived, petName, selfMorphView, bypassCooldown, animation, recentLootsFound);
                if (s == null) {
                    this.mySQLManager.getTable().update().set("Name", playername).where("UUID", uuid).execute();
                }
                if (s != null && !s.equals(playername)) {
                    this.mySQLManager.getTable().update().set("Name", playername).where("UUID", uuid).execute();
                }
                if (selectQuery != null) {
                    selectQuery.close();
                }
                if (res != null) {
                    res.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void savePlayerStats(int UID, String recentLootsFound) {
        if (recentLootsFound == null) {
            recentLootsFound = "";
        }
        this.mySQLManager.getTable().update().set("Recent_Loots_Found", recentLootsFound).where("id", UID).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExist(OfflinePlayer player) {
        if (player == null) {
            return false;
        }
        if (this.mySQLManager.getConnection() == null) {
            return false;
        }
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("UUID", player.getUniqueId().toString());
            res = sQuery.execute();
            boolean bl = res.first();
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUID(UUID uuid) {
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("UUID", uuid.toString());
            res = sQuery.execute();
            res.first();
            int n = res.getInt("id");
            return n;
        }
        catch (SQLException e) {
            int n = -1;
            return n;
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMysteryDust(UUID uuid) {
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("UUID", uuid.toString());
            res = sQuery.execute();
            res.first();
            int n = res.getInt("Mystery_Dust");
            return n;
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean addMysteryDust(UUID uuid, int mysteryDust) {
        if (this.mySQLManager == null || this.mySQLManager.getTable() == null) {
            return false;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Mystery_Dust", this.getMysteryDust(uuid) + mysteryDust).where("UUID", uuid.toString()).execute());
        return true;
    }

    @Override
    public boolean removeMysteryDust(UUID uuid, int mysteryDust) {
        if (this.mySQLManager == null || this.mySQLManager.getTable() == null) {
            return false;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            int md = this.getMysteryDust(uuid);
            this.mySQLManager.getTable().update().set("Mystery_Dust", md <= 0 ? 0 : md - mysteryDust).where("UUID", uuid.toString()).execute();
        });
        return true;
    }

    @Override
    public boolean setMysteryDust(UUID uuid, int mysteryDust) {
        if (this.mySQLManager == null || this.mySQLManager.getTable() == null) {
            return false;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Mystery_Dust", mysteryDust).where("UUID", uuid.toString()).execute());
        return true;
    }

    @Override
    public void setPetName(OfflinePlayerManager pManager, String name) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            DatabaseMetaData metaData = null;
            ResultSet rs = null;
            try {
                metaData = this.mySQLManager.getConnection().getMetaData();
                rs = metaData.getColumns(null, null, this.mySQLManager.tableName, "Pet_Name");
                if (!rs.next()) {
                    PreparedStatement statement = this.mySQLManager.getConnection().prepareStatement("ALTER TABLE " + this.mySQLManager.tableName + " ADD Pet_Name VARCHAR(255) NOT NULL", 1004, 1007);
                    statement.executeUpdate();
                    statement.close();
                    this.mySQLManager.getTable().update().set("Pet_Name", GadgetsMenu.getGadgetsMenuData().getDefaultPetName()).where("id", pManager.getUID()).execute();
                    return;
                }
                this.mySQLManager.getTable().update().set("Pet_Name", name != null ? name.replace("'", "''") : "Unknown").where("id", pManager.getUID()).execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMysteryGiftPacks(OfflinePlayerManager pManager) {
        int statement2;
        ResultSet rs = null;
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            DatabaseMetaData metaData = this.mySQLManager.getConnection().getMetaData();
            rs = metaData.getColumns(null, null, this.mySQLManager.tableName, "Mystery_Gift_Packs");
            if (!rs.next()) {
                PreparedStatement statement2 = this.mySQLManager.getConnection().prepareStatement("ALTER TABLE " + this.mySQLManager.tableName + " ADD Mystery_Gift_Packs INT(11) DEFAULT 0 NOT NULL", 1004, 1007);
                statement2.executeUpdate();
                statement2.close();
                int n = 0;
                return n;
            }
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            statement2 = res.getInt("Mystery_Gift_Packs");
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return statement2;
    }

    @Override
    public void addMysteryGiftPacks(OfflinePlayerManager pManager, int pack) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Mystery_Gift_Packs", this.getMysteryGiftPacks(pManager) + pack).where("id", pManager.getUID()).execute());
    }

    @Override
    public void removeMysteryGiftPacks(OfflinePlayerManager pManager, int pack) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            int md = this.getMysteryGiftPacks(pManager);
            this.mySQLManager.getTable().update().set("Mystery_Gift_Packs", md <= 0 ? 0 : md - pack).where("id", pManager.getUID()).execute();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMysteryGiftSent(OfflinePlayerManager pManager) {
        int statement2;
        ResultSet rs = null;
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            DatabaseMetaData metaData = this.mySQLManager.getConnection().getMetaData();
            rs = metaData.getColumns(null, null, this.mySQLManager.tableName, "Mystery_Gift_Sent");
            if (!rs.next()) {
                PreparedStatement statement2 = this.mySQLManager.getConnection().prepareStatement("ALTER TABLE " + this.mySQLManager.tableName + " ADD Mystery_Gift_Sent INT(11) DEFAULT 0 NOT NULL", 1004, 1007);
                statement2.executeUpdate();
                statement2.close();
                int n = 0;
                return n;
            }
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            statement2 = res.getInt("Mystery_Gift_Sent");
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return statement2;
    }

    @Override
    public void addMysteryGiftSent(OfflinePlayerManager pManager, int amount) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Mystery_Gift_Sent", this.getMysteryGiftSent(pManager) + amount).where("id", pManager.getUID()).execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMysteryGiftReceived(OfflinePlayerManager pManager) {
        int statement2;
        ResultSet rs = null;
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            DatabaseMetaData metaData = this.mySQLManager.getConnection().getMetaData();
            rs = metaData.getColumns(null, null, this.mySQLManager.tableName, "Mystery_Gift_Received");
            if (!rs.next()) {
                PreparedStatement statement2 = this.mySQLManager.getConnection().prepareStatement("ALTER TABLE " + this.mySQLManager.tableName + " ADD Mystery_Gift_Received INT(11) DEFAULT 0 NOT NULL", 1004, 1007);
                statement2.executeUpdate();
                statement2.close();
                int n = 0;
                return n;
            }
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            statement2 = res.getInt("Mystery_Gift_Received");
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return statement2;
    }

    @Override
    public void addMysteryGiftReceived(OfflinePlayerManager pManager, int amount) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Mystery_Gift_Received", this.getMysteryGiftReceived(pManager) + amount).where("id", pManager.getUID()).execute());
    }

    @Override
    public void setSeeSelfMorph(OfflinePlayerManager pManager, boolean enabled) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Self_Morph_View", enabled ? "true" : "false").where("id", pManager.getUID()).execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSeeSelfMorph(OfflinePlayerManager pManager) {
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            boolean bl = res.getBoolean("Self_Morph_View");
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void setCooldownBypass(OfflinePlayerManager pManager, boolean enabled) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getTable().update().set("Bypass_Cooldown", enabled ? "true" : "false").where("id", pManager.getUID()).execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCooldownBypass(OfflinePlayerManager pManager) {
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            boolean bl = res.getBoolean("Bypass_Cooldown");
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnimationType getMysteryVaultAnimation(OfflinePlayerManager pManager) {
        AnimationType statement2;
        ResultSet rs = null;
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            DatabaseMetaData metaData = this.mySQLManager.getConnection().getMetaData();
            rs = metaData.getColumns(null, null, this.mySQLManager.tableName, "Mystery_Vault_Animation");
            if (!rs.next()) {
                PreparedStatement statement2 = this.mySQLManager.getConnection().prepareStatement("ALTER TABLE " + this.mySQLManager.tableName + " ADD Mystery_Vault_Animation VARCHAR(255) DEFAULT 'Normal' NOT NULL", 1004, 1007);
                statement2.executeUpdate();
                statement2.close();
                this.setMysteryVaultAnimation(pManager, AnimationType.NORMAL);
                AnimationType animationType = AnimationType.NORMAL;
                return animationType;
            }
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            statement2 = AnimationType.valueOf(res.getString("Mystery_Vault_Animation"));
        }
        catch (SQLException e) {
            AnimationType animationType = AnimationType.NORMAL;
            return animationType;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return statement2;
    }

    @Override
    public void setMysteryVaultAnimation(OfflinePlayerManager pManager, AnimationType animation) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            if (animation == null) {
                throw new NullPointerException("The animation can not be null.");
            }
            this.mySQLManager.getTable().update().set("Mystery_Vault_Animation", animation.getName()).where("id", pManager.getUID()).execute();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRecentLootsFound(OfflinePlayerManager pManager) {
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("id", pManager.getUID());
            res = sQuery.execute();
            res.first();
            String string = res.getString("Recent_Loots_Found");
            return string;
        }
        catch (SQLException e) {
            String string = "";
            return string;
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEquippedCosmetics(List<String> cosmeticIndexes, int uid) {
        ResultSet resultSet = null;
        SelectQuery sQuery = null;
        try {
            sQuery = this.mySQLManager.getTable().select().where("id", uid);
            resultSet = sQuery.execute();
            resultSet.first();
            ArrayList<String> results = new ArrayList<String>();
            for (int i = 0; i < cosmeticIndexes.size(); ++i) {
                results.add(resultSet.getString(cosmeticIndexes.get(i)));
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            List<String> list = null;
            return list;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sQuery != null) {
                sQuery.close();
            }
        }
    }

    @Override
    public void syncEquippedCosmetics(List<String> cosmeticIndexes, List<String> name, int uid) {
        if (cosmeticIndexes.size() != name.size()) {
            return;
        }
        String query = "";
        for (int i = 0; i < cosmeticIndexes.size(); ++i) {
            String finalName = name.get(i);
            if (finalName == null) {
                finalName = "none";
            }
            query = query + cosmeticIndexes.get(i) + " = '" + finalName + "', ";
        }
        if (query.endsWith(", ")) {
            query = query.substring(0, query.length() - 2);
        }
        try {
            PreparedStatement statement = this.mySQLManager.getConnection().prepareStatement("UPDATE " + this.mySQLManager.tableName + " SET " + query + "  WHERE `id` = " + uid, 1004, 1007);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadMysteryBoxes(PlayerManager pManager) {
        Validate.notNull((Object)pManager);
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getMysteryBoxesTable().select("Loots").where("UID", pManager.getUID());
            res = sQuery.execute();
            while (res.next()) {
                String loots = res.getString("Loots");
                try {
                    MysteryBoxes boxes = new MysteryBoxes(loots);
                    if (boxes.isExpirable()) {
                        if (!boxes.isExpired()) {
                            pManager.mysteryBoxes().add(boxes);
                            continue;
                        }
                        this.removeMysteryBox(pManager.getUID(), boxes);
                        continue;
                    }
                    pManager.mysteryBoxes().add(boxes);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            boolean loots = true;
            return loots;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sQuery != null) {
                sQuery.close();
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMysteryBoxes(OfflinePlayerManager pManager) {
        Validate.notNull((Object)pManager);
        int count = 0;
        SelectQuery sQuery = null;
        ResultSet res = null;
        try {
            sQuery = this.mySQLManager.getMysteryBoxesTable().select("Loots").where("UID", pManager.getUID());
            res = sQuery.execute();
            while (res.next()) {
                String loots = res.getString("Loots");
                try {
                    MysteryBoxes boxes = new MysteryBoxes(loots);
                    if (boxes.isExpirable() && boxes.isExpired()) {
                        this.removeMysteryBox(pManager.getUID(), boxes);
                        continue;
                    }
                    ++count;
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            int loots = count;
            return loots;
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sQuery != null) {
                sQuery.close();
            }
        }
    }

    @Override
    public void addMysteryBox(UUID uuid, int uid, MysteryBoxes mysteryBox) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getMysteryBoxesTable().insert().insert("UUID, UID, Loots").value(uuid.toString()).value(uid).value(mysteryBox.toEncodedString()).execute());
    }

    @Override
    public void removeMysteryBox(int uid, MysteryBoxes mysteryBox) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.mySQLManager.getMysteryBoxesTable().delete().where("UID", uid).where("Loots", mysteryBox.toEncodedString()).execute());
    }
}

