/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.database.mysql;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.database.DatabaseConnection;
import com.yapzhenyie.GadgetsMenu.database.DatabaseManager;
import com.yapzhenyie.GadgetsMenu.database.DatabaseUtils;
import com.yapzhenyie.GadgetsMenu.database.Table;
import com.yapzhenyie.GadgetsMenu.database.mysql.MySQLConnection;
import com.yapzhenyie.GadgetsMenu.database.mysql.MySQLUtils;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MySQLManager
implements DatabaseManager {
    private MySQLConnection dbConnection;
    private Connection connection;
    private DatabaseUtils sqlUtils;
    private Table table;
    private Table mysteryBoxesTable;
    public String tableName = "GadgetsMenu_Data";
    public String mysteryBoxesTableName = "GadgetsMenu_Mystery_Boxes";
    private static boolean keepConnectionTask = false;
    private int reconnectTimes = 5;

    @Override
    public void init() {
        this.sqlUtils = new MySQLUtils(this);
        try {
            if (this.dbConnection != null) {
                this.dbConnection.closeConnection();
            }
            this.dbConnection = new MySQLConnection();
            LoggerManager.info(MessageType.CONNECTING_TO_DATABASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            this.connection = this.dbConnection.openConnection();
            PreparedStatement statement = null;
            try {
                statement = this.dbConnection.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS " + this.tableName + "(id INT(11) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id), UUID VARCHAR(36) NOT NULL, Name VARCHAR(255) NOT NULL, Mystery_Dust INT(11) DEFAULT 0 NOT NULL, Mystery_Gift_Packs INT(11) DEFAULT 0 NOT NULL, Mystery_Gift_Sent INT(11) DEFAULT 0 NOT NULL, Mystery_Gift_Received INT(11) DEFAULT 0 NOT NULL, Pet_Name VARCHAR(255) DEFAULT 'Pet' NOT NULL, Self_Morph_View VARCHAR(5) DEFAULT 'true' NOT NULL, Bypass_Cooldown VARCHAR(5) DEFAULT 'false' NOT NULL, Mystery_Vault_Animation VARCHAR(255) DEFAULT 'Normal' NOT NULL, Recent_Loots_Found VARCHAR(255) COLLATE utf8mb4_unicode_ci DEFAULT '' NOT NULL, Selected_Hat VARCHAR(255) DEFAULT 'none' not NULL, Selected_Animated_Hat VARCHAR(255) DEFAULT 'none' not NULL, Selected_Particle VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Helmet VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Chestplate VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Leggings VARCHAR(255) DEFAULT 'none' not NULL, Selected_Suit_Boots VARCHAR(255) DEFAULT 'none' not NULL, Selected_Gadget VARCHAR(255) DEFAULT 'none' not NULL, Selected_Pet VARCHAR(255) DEFAULT 'none' not NULL, Selected_Morph VARCHAR(255) DEFAULT 'none' not NULL, Selected_Banner VARCHAR(255) DEFAULT 'none' not NULL, Selected_Emote VARCHAR(255) DEFAULT 'none' not NULL, Selected_Cloak VARCHAR(255) DEFAULT 'none' not NULL,KEY `playeruuid` (`uuid`) USING HASH)");
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                statement = this.dbConnection.getConnection().prepareStatement("ALTER TABLE `" + this.tableName + "` CHANGE `Pet_Name` `Pet_Name` VARCHAR(255) DEFAULT 'Pet' not NULL");
                statement.executeUpdate();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                statement = this.connection.prepareStatement("ALTER TABLE `" + this.tableName + "` CHANGE `Recent_Loots_Found` `Recent_Loots_Found` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''");
                statement.executeUpdate();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                statement = this.dbConnection.getConnection().prepareStatement("ALTER TABLE `" + this.tableName + "` ADD KEY `playeruuid` (`uuid`) USING HASH");
                statement.executeUpdate();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                statement = this.dbConnection.getConnection().prepareStatement("ALTER TABLE `" + this.tableName + "` ADD `Selected_Animated_Hat` VARCHAR(255) DEFAULT 'none' not NULL");
                statement.executeUpdate();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.table = new Table(this.connection, this.tableName);
            statement = this.dbConnection.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS " + this.mysteryBoxesTableName + "(id INT(11) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id), UUID VARCHAR(36) NOT NULL, UID INT(11) NOT NULL, Loots VARCHAR(2000) NOT NULL,KEY `playeruuid` (`uuid`) USING HASH)");
            statement.executeUpdate();
            try {
                statement = this.connection.prepareStatement("ALTER TABLE `" + this.mysteryBoxesTableName + "` ADD `UID` INT(11) NOT NULL");
                statement.executeUpdate();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.mysteryBoxesTable = new Table(this.connection, this.mysteryBoxesTableName);
            if (FileManager.getConfigFile().get("Update-MySQL") != null) {
                PreparedStatement updateUID = this.connection.prepareStatement("UPDATE `" + this.mysteryBoxesTableName + "` mb, `" + this.tableName + "` gd SET mb.UID = gd.id WHERE mb.UUID = gd.UUID AND mb.UID = 0");
                updateUID.executeUpdate();
                updateUID.close();
                FileManager.getConfigFile().set("Update-MySQL", null);
                try {
                    FileManager.getConfigFile().save(GadgetsMenu.getInstance().getFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            statement.close();
            LoggerManager.info(MessageType.SUCCESSFULLY_CONNECTED_TO_DATABASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            if (!keepConnectionTask) {
                Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
                    ResultSet res = null;
                    Statement sm = null;
                    try {
                        if (this.dbConnection == null) {
                            return;
                        }
                        if (this.dbConnection.isClosed()) return;
                        if (this.connection.isClosed()) {
                            return;
                        }
                        sm = this.dbConnection.getConnection().prepareStatement("SELECT * FROM " + this.tableName + " WHERE id = 1");
                        res = sm.executeQuery();
                        res.first();
                        res.getString("UUID");
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    finally {
                        if (res != null) {
                            try {
                                res.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (sm != null) {
                            try {
                                sm.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }, 1200L, 9600L);
                keepConnectionTask = true;
            }
            if (this.reconnectTimes < 5) {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
                    if (this.reconnectTimes < 5) {
                        ++this.reconnectTimes;
                    }
                }, 6000L);
            }
        }
        catch (Exception e) {
            LoggerManager.info("--------------------------------------------------");
            LoggerManager.consoleMessage(ChatUtil.format("&c&l" + MessageType.FAILED_TO_CONNECT_TO_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName())));
            LoggerManager.info("--------------------------------------------------");
            e.printStackTrace();
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)GadgetsMenu.getInstance());
        }
    }

    @Override
    public synchronized void reconnect() {
        try {
            if ((this.connection == null || this.connection.isClosed()) && GadgetsMenu.getInstance() != null) {
                if (this.reconnectTimes <= 0) {
                    LoggerManager.printLogWithHeader(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.DATABASE_RECONNECTION_IS_TOO_FREQUENT.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
                    return;
                }
                this.init();
                --this.reconnectTimes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DatabaseConnection getDBConnection() {
        return this.dbConnection;
    }

    @Override
    public Connection getConnection() {
        this.reconnect();
        return this.connection;
    }

    @Override
    public Table getTable() {
        this.reconnect();
        return this.table;
    }

    @Override
    public Table getMysteryBoxesTable() {
        this.reconnect();
        return this.mysteryBoxesTable;
    }

    @Override
    public DatabaseUtils getDatabaseUtils() {
        return this.sqlUtils;
    }
}

