/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.database.mysql;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.database.DatabaseConnection;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class MySQLConnection
implements DatabaseConnection {
    private final String hostname = FileManager.getConfigFile().getString("Player-Data.MySQL.hostname");
    private final String username = FileManager.getConfigFile().getString("Player-Data.MySQL.username");
    private final String database = FileManager.getConfigFile().getString("Player-Data.MySQL.database");
    private final String port = FileManager.getConfigFile().getString("Player-Data.MySQL.port");
    private final String password = FileManager.getConfigFile().getString("Player-Data.MySQL.password");
    private final boolean useSSL = FileManager.getConfigFile().getBoolean("Player-Data.MySQL.useSSL");
    private Connection connection;

    @Override
    public Connection openConnection() throws Exception {
        if (this.checkConnection()) {
            return this.connection;
        }
        String mysqlDriver = "com.mysql.cj.jdbc.Driver";
        mysqlDriver = VersionManager.is1_18OrAbove() ? "com.mysql.cj.jdbc.Driver" : (VersionManager.isPaperServer() && VersionManager.isVersionGreaterEqual(VersionManager.getMinecraftVersion(), "1.16.5") ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver");
        try {
            Class.forName(mysqlDriver);
        }
        catch (ClassNotFoundException e) {
            mysqlDriver = mysqlDriver.equals("com.mysql.cj.jdbc.Driver") ? "com.mysql.jdbc.Driver" : "com.mysql.cj.jdbc.Driver";
            Class.forName(mysqlDriver);
        }
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database + "?&autoReconnect=true&wait_timeout=31536000&interactive_timeout=31536000&useUnicode=true&characterEncoding=utf8&useSSL=" + this.useSSL, this.username, this.password);
        return this.connection;
    }

    @Override
    public boolean checkConnection() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.FAILED_TO_CONNECT_TO_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isClosed() {
        if (this.connection == null) {
            return true;
        }
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.FAILED_TO_CLOSE_THE_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean closeConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.close();
            LoggerManager.info(MessageType.DATABASE_CONNECTION_IS_CLOSED.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
        }
        catch (SQLException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "--------------------------------------------------", MessageType.FAILED_TO_CLOSE_THE_DATEBASE.getFormatMessage().replace("{DATABASE}", GadgetsMenu.getGadgetsMenuData().getDatabaseStorage().getName()));
            e.printStackTrace();
        }
        return true;
    }
}

