/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SuitThor
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;
    private Location target = this.getPlayer().getLocation();
    private FallingBlock fallingBlock = null;

    public SuitThor(UUID uuid) {
        super(uuid, SuitType.THOR);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            Location loc2;
            Location location = BlockUtil.getTargetBlock(this.getPlayer(), 9).getLocation();
            if (location.getBlock().isEmpty()) {
                this.getPlayer().sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
                this.clicked = false;
                return;
            }
            Location loc1 = location.clone().add(0.0, 1.0, 0.0);
            CuboID checkCuboid = new CuboID(loc1, loc2 = location.clone().add(0.0, 16.0, 0.0));
            if (!checkCuboid.isEmpty() || this.getPlayer().getLocation().add(0.0, 16.0, 0.0).getBlockY() >= 256) {
                this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
                this.clicked = false;
                return;
            }
            location.add(0.5, 0.2, 0.5);
            this.target = location;
            this.activated = true;
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    SuitThor.this.spawnAnvil(SuitThor.this.getPlayer(), SuitThor.this.target);
                }
            }, 20L);
            this.clicked = false;
            this.addCooldownTimer();
        }
        if (this.fallingBlock != null) {
            ParticleEffect.FLAME.display(this.fallingBlock.getLocation(), 0.2f, 0.2f, 0.2f, 2.0f, 2);
            ParticleEffect.CLOUD.display(this.fallingBlock.getLocation(), 0.5f, 0.3f, 0.5f, 3);
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.fallingBlock != null) {
            this.fallingBlock.getWorld().strikeLightningEffect(this.fallingBlock.getLocation());
            ParticleEffect.PORTAL.display(this.fallingBlock.getLocation(), 0.7f, 0.7f, 0.7f, 25);
            SoundEffect.BLOCK_ANVIL_LAND.playSound(this.fallingBlock.getLocation());
            this.fallingBlock.remove();
        }
        this.fallingBlock = null;
        this.clicked = false;
        this.activated = false;
    }

    private void spawnAnvil(Player player, Location location) {
        FallingBlock fb = location.getWorld().spawnFallingBlock(location.clone().add(0.0, 15.0, 0.0), EnumMaterial.ANVIL.getType(), (byte)0);
        fb.setDropItem(false);
        fb.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.fallingBlock = fb;
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                SuitThor.this.clearAll();
            }
        }, 28L);
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                e.getPlayer().sendMessage(MessageType.SUIT_ABILITY_IS_ACTIVATED.getFormatMessage().replace("{SUIT}", this.getType().getDisplayNameStripColor()));
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockChange(EntityChangeBlockEvent event) {
        FallingBlock fb;
        if (event.getEntityType() == EntityType.FALLING_BLOCK && (fb = (FallingBlock)event.getEntity()).hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            event.setCancelled(true);
        }
    }
}

