/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SuitNecromancer
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;
    private ArrayList<Location> locations = new ArrayList();
    private ArrayList<Entity> entitys = new ArrayList();
    private EntityType[] entityTypes = new EntityType[]{EntityType.SKELETON, EntityType.ZOMBIE};

    public SuitNecromancer(UUID uuid) {
        super(uuid, SuitType.NECROMANCER);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            this.activated = true;
            for (Location locs : BlockUtil.getLocationsInRadius(this.getPlayer().getLocation(), 4, false)) {
                this.locations.add(locs);
            }
            for (int i = 1; i <= 8; ++i) {
                Location location = this.locations.get(GadgetsMenu.random().nextInt(this.locations.size()));
                Location loc2 = location.clone();
                loc2.setY((double)(this.getPlayer().getWorld().getHighestBlockYAt(location) + 1));
                Entity entity = this.getPlayer().getWorld().spawnEntity(loc2, this.entityTypes[GadgetsMenu.random().nextInt(this.entityTypes.length)]);
                entity.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                GadgetsMenu.getNMSManager().removePathfinders(entity);
                GadgetsMenu.getNMSManager().makeEntityPanic(entity);
                this.entitys.add(entity);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    SuitNecromancer.this.clearAll();
                }
            }, 160L);
            this.clicked = false;
            this.addCooldownTimer();
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Entity ent : this.entitys) {
            if (ent == null) continue;
            ent.remove();
        }
        this.entitys.clear();
        this.locations.clear();
        this.clicked = false;
        this.activated = false;
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                this.getPlayer().sendMessage(MessageType.SUIT_ABILITY_IS_ACTIVATED.getFormatMessage().replace("{SUIT}", this.getType().getDisplayNameStripColor()));
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }
}

