/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SuitFirefighter
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;

    public SuitFirefighter(UUID uuid) {
        super(uuid, SuitType.FIREFIGHTER);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            Location location = this.getPlayer().getEyeLocation().add(0.5, 0.0, 0.5);
            Location loc2 = location.clone().add(location.getDirection().multiply(15).add(new Vector(0, -4, 0)));
            this.drawArc(location, loc2, 2.0f, 150);
            this.activated = true;
            this.clicked = false;
            this.addCooldownTimer();
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.clicked = false;
        this.activated = false;
    }

    private void drawArc(Location location1, Location location2, float height, int particles) {
        if (location1 == null || location2 == null) {
            throw new NullPointerException();
        }
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> {
            Location location = location1;
            double currentY = location1.getY();
            for (int step = 0; step <= 400; ++step) {
                Vector link = location2.toVector().subtract(location.toVector());
                float length = (float)link.length();
                float pitch = (float)((double)(4.0f * height) / Math.pow(length, 2.0));
                Vector v = link.clone().normalize().multiply(length * (float)step / (float)particles);
                float x = (float)step / (float)particles * length - length / 2.0f;
                float y = (float)((double)(-pitch) * Math.pow(x, 2.0) + (double)height);
                location.add(v).add(0.0, (double)y, 0.0);
                if (Math.abs(location.getY() - currentY) > 15.0) {
                    this.clearAll();
                    break;
                }
                Block block = location1.getWorld().getBlockAt(location);
                if (block.getType().isSolid()) {
                    this.clearAll();
                    break;
                }
                ParticleEffect.DRIP_WATER.display(location, 0.07f, 0.07f, 0.07f, 0.0f, 3);
                location.subtract(0.0, (double)y, 0.0).subtract(v);
                try {
                    Thread.sleep(3L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (step != 400) continue;
                this.clearAll();
            }
        });
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                e.getPlayer().sendMessage(MessageType.SUIT_ABILITY_IS_ACTIVATED.getFormatMessage().replace("{SUIT}", this.getType().getDisplayNameStripColor()));
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }
}

