/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SuitDeathAngel
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;
    private Player targetPlayer = this.getPlayer();

    public SuitDeathAngel(UUID uuid) {
        super(uuid, SuitType.BAKER);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.isBeingCooldown()) {
            Entity target = PlayerUtils.getEntityPlayerLookingAt(this.getPlayer(), 10);
            if (target == null) {
                this.getPlayer().sendMessage(MessageType.TARGET_A_PLAYER.getFormatMessage());
                this.clicked = false;
                return;
            }
            if (!(target instanceof Player)) {
                this.getPlayer().sendMessage(MessageType.TARGET_A_PLAYER.getFormatMessage());
                this.clicked = false;
                return;
            }
            this.targetPlayer = (Player)target;
            this.activated = true;
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    SuitDeathAngel.this.targetPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 1));
                    SuitDeathAngel.this.targetPlayer.setPlayerTime(15000L, false);
                    SuitDeathAngel.this.getPlayer().setPlayerTime(15000L, false);
                    SuitDeathAngel.this.getPlayer().teleport(new Location(SuitDeathAngel.this.getPlayer().getWorld(), SuitDeathAngel.this.getPlayer().getLocation().getX() - SuitDeathAngel.this.getPlayer().getLocation().distance(SuitDeathAngel.this.targetPlayer.getLocation()), SuitDeathAngel.this.getPlayer().getLocation().getY(), SuitDeathAngel.this.getPlayer().getLocation().getZ() - SuitDeathAngel.this.getPlayer().getLocation().distance(SuitDeathAngel.this.targetPlayer.getLocation())));
                    Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            SuitDeathAngel.this.targetPlayer.resetPlayerTime();
                            SuitDeathAngel.this.getPlayer().resetPlayerTime();
                            SuitDeathAngel.this.clearAll();
                        }
                    }, 60L);
                }
            }, 10L);
            this.clicked = false;
            this.addCooldownTimer();
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.clicked = false;
        this.activated = false;
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                this.getPlayer().sendMessage(MessageType.SUIT_ABILITY_IS_ACTIVATED.getFormatMessage().replace("{SUIT}", this.getType().getDisplayNameStripColor()));
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }
}

