/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.types.Suit;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import depend.xxmicloxx.NoteBlockAPI.songplayer.PositionSongPlayer;
import depend.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SuitBumblebee
extends Suit {
    private boolean activated = false;
    private boolean clicked = false;
    private boolean flyToActivate = false;
    private PositionSongPlayer positionSongPlayer;
    private BukkitTask taskSongPlayer;

    public SuitBumblebee(UUID uuid) {
        super(uuid, SuitType.BUMBLEBEE);
    }

    @Override
    public void onUpdate() {
        if (this.clicked && !this.activated && !this.isBeingCooldown()) {
            this.activated = true;
            this.clicked = false;
            this.playSong(this.getPlayer(), 20);
            this.addCooldownTimer();
        }
        if (this.getPlayer().isFlying() && !this.activated && !this.isBeingCooldown()) {
            this.activated = true;
            this.flyToActivate = true;
            this.playSong(this.getPlayer(), 20);
            this.addCooldownTimer();
        }
        if (!this.getPlayer().isFlying() && this.flyToActivate) {
            this.clearAll();
        }
        if (this.positionSongPlayer != null && this.activated) {
            this.positionSongPlayer.setTargetLocation(this.getPlayer().getEyeLocation().add(-0.5, -0.5, -0.5));
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.positionSongPlayer != null && this.positionSongPlayer.isPlaying()) {
            this.positionSongPlayer.setPlaying(false);
        }
        this.positionSongPlayer = null;
        this.clicked = false;
        this.activated = false;
        this.flyToActivate = false;
        if (this.taskSongPlayer != null && !this.taskSongPlayer.isCancelled()) {
            this.taskSongPlayer.cancel();
            this.taskSongPlayer = null;
        }
    }

    private void playSong(Player player, int duration) {
        File song = new File(GadgetsMenu.getInstance().getDataFolder().getPath() + "/songs/Bumblebee.nbs");
        if (!song.exists()) {
            GadgetsMenu.getInstance().saveResource("songs/Bumblebee.nbs", true);
        }
        Song s = NBSDecoder.parse(song);
        this.positionSongPlayer = new PositionSongPlayer(s);
        this.positionSongPlayer.setTargetLocation(player.getEyeLocation().add(-0.5, -0.5, -0.5));
        this.positionSongPlayer.setPlaying(true);
        this.positionSongPlayer.addPlayer(player);
        this.positionSongPlayer.setVolume((byte)100);
        this.positionSongPlayer.getFadeIn().setFadeStart((byte)25);
        this.positionSongPlayer.getFadeOut().setFadeStart((byte)25);
        this.taskSongPlayer = Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
            if (this.taskSongPlayer == null) {
                return;
            }
            this.clearAll();
        }, (long)duration * 20L);
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent e) {
        if (!(e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK || e.getPlayer() != this.getPlayer() || this.clicked)) {
            if (e.getPlayer().getItemInHand().getType() != Material.AIR) {
                return;
            }
            if (this.getPlayer().isFlying() && this.activated) {
                return;
            }
            if (this.isBeingCooldown()) {
                e.setCancelled(true);
                return;
            }
            if (this.activated) {
                this.getPlayer().sendMessage(MessageType.TURN_OFF_BUMBLEBEE_SONG.getFormatMessage());
                this.clearAll();
                e.setCancelled(true);
                return;
            }
            this.clicked = true;
            e.setCancelled(true);
        }
    }
}

